/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.minimap;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import journeymap.client.JourneymapClient;
import journeymap.client.api.display.Context;
import journeymap.client.api.impl.ClientAPI;
import journeymap.client.api.util.UIState;
import journeymap.client.feature.Feature;
import journeymap.client.feature.FeatureManager;
import journeymap.client.forge.event.MiniMapOverlayHandler;
import journeymap.client.forge.helper.ForgeHelper;
import journeymap.client.forge.helper.IForgeHelper;
import journeymap.client.log.JMLogger;
import journeymap.client.log.StatTimer;
import journeymap.client.model.MapState;
import journeymap.client.model.MapType;
import journeymap.client.properties.MiniMapProperties;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.draw.DrawWayPointStep;
import journeymap.client.render.draw.RadarDrawStepFactory;
import journeymap.client.render.draw.WaypointDrawStepFactory;
import journeymap.client.render.map.GridRenderer;
import journeymap.client.render.texture.TextureCache;
import journeymap.client.render.texture.TextureImpl;
import journeymap.client.ui.minimap.DisplayVars;
import journeymap.client.ui.minimap.Position;
import journeymap.client.ui.minimap.ReticleOrientation;
import journeymap.client.ui.minimap.Shape;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.lwjgl.opengl.GL11;

public class MiniMap {
    private static final MapState state = new MapState();
    private static final float lightmapS = 240.0f;
    private static final float lightmapT = 240.0f;
    private static final long labelRefreshRate = 400L;
    private static final GridRenderer gridRenderer = new GridRenderer(Context.UI.Minimap, 3);
    private final IForgeHelper forgeHelper = ForgeHelper.INSTANCE;
    private final Minecraft mc = FMLClientHandler.instance().getClient();
    private final WaypointDrawStepFactory waypointRenderer = new WaypointDrawStepFactory();
    private final RadarDrawStepFactory radarRenderer = new RadarDrawStepFactory();
    private TextureImpl playerLocatorTex;
    private MiniMapProperties miniMapProperties;
    private EntityPlayer player;
    private StatTimer drawTimer;
    private StatTimer refreshStateTimer;
    private DisplayVars dv;
    private long lastLabelRefresh = 0L;
    private String fpsLabelText;
    private String locationLabelText;
    private String biomeLabelText;
    private Point2D.Double centerPoint;
    private Rectangle2D.Double centerRect;
    private long initTime = System.currentTimeMillis();

    public MiniMap(MiniMapProperties miniMapProperties) {
        this.player = this.mc.field_71439_g;
        this.setMiniMapProperties(miniMapProperties);
    }

    public static synchronized MapState state() {
        return state;
    }

    public static synchronized UIState uiState() {
        return gridRenderer.getUIState();
    }

    public static void updateUIState(boolean isActive) {
        if (FMLClientHandler.instance().getClient().field_71441_e != null) {
            gridRenderer.updateUIState(isActive);
        }
    }

    private void initGridRenderer() {
        gridRenderer.clear();
        state.requireRefresh();
        if (this.player == null || this.player.field_70128_L) {
            return;
        }
        boolean showCaves = this.shouldShowCaves();
        state.refresh(this.mc, this.player, this.miniMapProperties);
        MapType mapType = state.getMapType(showCaves);
        int gridSize = this.miniMapProperties.getSize() <= 768 ? 3 : 5;
        gridRenderer.setGridSize(gridSize);
        gridRenderer.setContext(state.getWorldDir(), mapType);
        gridRenderer.center(state.getWorldDir(), mapType, this.mc.field_71439_g.field_70165_t, this.mc.field_71439_g.field_70161_v, this.miniMapProperties.zoomLevel.get());
        boolean highQuality = JourneymapClient.getCoreProperties().tileHighDisplayQuality.get();
        gridRenderer.updateTiles(state.getMapType(showCaves), state.getZoom(), highQuality, this.mc.field_71443_c, this.mc.field_71440_d, true, 0.0, 0.0);
    }

    public void resetInitTime() {
        this.initTime = System.currentTimeMillis();
    }

    public void setMiniMapProperties(MiniMapProperties miniMapProperties) {
        this.miniMapProperties = miniMapProperties;
        this.reset();
    }

    public MiniMapProperties getCurrentMinimapProperties() {
        return this.miniMapProperties;
    }

    public void drawMap() {
        this.drawMap(false);
    }

    private boolean shouldShowCaves() {
        return FeatureManager.isAllowed(Feature.MapCaves) && (this.forgeHelper.hasNoSky((Entity)this.player) || this.miniMapProperties.showCaves.get() != false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawMap(boolean preview) {
        StatTimer timer = this.drawTimer;
        RenderHelper.func_74518_a();
        try {
            boolean doStateRefresh;
            this.player = this.mc.field_71439_g;
            if (this.player == null || this.player.field_70128_L) {
                return;
            }
            gridRenderer.clearGlErrors(false);
            boolean bl = doStateRefresh = gridRenderer.hasUnloadedTile() || state.shouldRefresh(this.mc, this.miniMapProperties);
            if (doStateRefresh) {
                timer = this.refreshStateTimer.start();
                gridRenderer.setContext(state.getWorldDir(), state.getCurrentMapType());
                if (!preview) {
                    state.refresh(this.mc, this.player, this.miniMapProperties);
                }
                ClientAPI.INSTANCE.flagOverlaysForRerender();
            } else {
                timer.start();
            }
            boolean moved = gridRenderer.center(state.getWorldDir(), state.getCurrentMapType(), this.mc.field_71439_g.field_70165_t, this.mc.field_71439_g.field_70161_v, this.miniMapProperties.zoomLevel.get());
            if (moved || doStateRefresh) {
                boolean showCaves = this.shouldShowCaves();
                gridRenderer.updateTiles(state.getMapType(showCaves), state.getZoom(), state.isHighQuality(), this.mc.field_71443_c, this.mc.field_71440_d, doStateRefresh || preview, 0.0, 0.0);
            }
            if (doStateRefresh) {
                boolean checkWaypointDistance = JourneymapClient.getWaypointProperties().maxDistance.get() > 0;
                state.generateDrawSteps(this.mc, gridRenderer, this.waypointRenderer, this.radarRenderer, this.miniMapProperties, this.dv.drawScale, checkWaypointDistance);
                state.updateLastRefresh();
            }
            this.updateDisplayVars(false);
            long now = System.currentTimeMillis();
            if (now - this.lastLabelRefresh > 400L) {
                this.updateLabels();
            }
            DrawUtil.sizeDisplay(this.mc.field_71443_c, this.mc.field_71440_d);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)0);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179126_j();
            this.beginStencil();
            double rotation = 0.0;
            switch (this.dv.orientation) {
                case North: {
                    rotation = 0.0;
                    break;
                }
                case OldNorth: {
                    rotation = 90.0;
                    break;
                }
                case PlayerHeading: {
                    if (this.dv.shape != Shape.Circle) break;
                    rotation = 180.0f - this.mc.field_71439_g.field_70759_as;
                }
            }
            this.startMapRotation(rotation);
            try {
                Point2D.Double windowCenter;
                float alpha;
                long lastMapChangeTime;
                GlStateManager.func_179109_b((float)this.dv.translateX, (float)this.dv.translateY, (float)0.0f);
                gridRenderer.draw(this.dv.terrainAlpha, 0.0, 0.0, this.miniMapProperties.showGrid.get());
                gridRenderer.draw(state.getDrawSteps(), 0.0, 0.0, this.dv.drawScale, this.dv.fontScale, rotation);
                this.centerPoint = gridRenderer.getPixel(this.mc.field_71439_g.field_70165_t, this.mc.field_71439_g.field_70161_v);
                this.centerRect = new Rectangle2D.Double(this.centerPoint.x - (double)(this.dv.minimapWidth / 2), this.centerPoint.y - (double)(this.dv.minimapHeight / 2), this.dv.minimapWidth, this.dv.minimapHeight);
                this.drawOnMapWaypoints(rotation);
                if (this.miniMapProperties.showSelf.get().booleanValue() && this.playerLocatorTex != null && this.centerPoint != null) {
                    DrawUtil.drawEntity(this.centerPoint.getX(), this.centerPoint.getY(), this.mc.field_71439_g.field_70759_as, false, this.playerLocatorTex, this.dv.drawScale, rotation);
                }
                GlStateManager.func_179109_b((float)(-this.dv.translateX), (float)(-this.dv.translateY), (float)0.0f);
                ReticleOrientation reticleOrientation = null;
                if (this.dv.showReticle) {
                    reticleOrientation = this.dv.minimapFrame.getReticleOrientation();
                    if (reticleOrientation == ReticleOrientation.Compass) {
                        this.dv.minimapFrame.drawReticle();
                    } else {
                        this.startMapRotation(this.player.field_70759_as);
                        this.dv.minimapFrame.drawReticle();
                        this.stopMapRotation(this.player.field_70759_as);
                    }
                }
                if (now - (lastMapChangeTime = state.getLastMapTypeChange()) <= 1000L) {
                    this.stopMapRotation(rotation);
                    GlStateManager.func_179109_b((float)this.dv.translateX, (float)this.dv.translateY, (float)0.0f);
                    alpha = (float)Math.min(255L, Math.max(0L, 1100L - (now - lastMapChangeTime))) / 255.0f;
                    windowCenter = gridRenderer.getWindowPosition(this.centerPoint);
                    this.dv.getMapTypeStatus(state.getCurrentMapType()).draw(windowCenter, alpha, 0.0);
                    GlStateManager.func_179109_b((float)(-this.dv.translateX), (float)(-this.dv.translateY), (float)0.0f);
                    this.startMapRotation(rotation);
                }
                if (now - this.initTime <= 1000L) {
                    this.stopMapRotation(rotation);
                    GlStateManager.func_179109_b((float)this.dv.translateX, (float)this.dv.translateY, (float)0.0f);
                    alpha = (float)Math.min(255L, Math.max(0L, 1100L - (now - this.initTime))) / 255.0f;
                    windowCenter = gridRenderer.getWindowPosition(this.centerPoint);
                    this.dv.getMapPresetStatus(state.getCurrentMapType(), this.miniMapProperties.getId()).draw(windowCenter, alpha, 0.0);
                    GlStateManager.func_179109_b((float)(-this.dv.translateX), (float)(-this.dv.translateY), (float)0.0f);
                    this.startMapRotation(rotation);
                }
                this.endStencil();
                if (this.dv.shape == Shape.Circle || rotation == 0.0) {
                    this.dv.minimapFrame.drawFrame();
                } else {
                    this.stopMapRotation(rotation);
                    try {
                        this.dv.minimapFrame.drawFrame();
                    }
                    finally {
                        this.startMapRotation(rotation);
                    }
                }
                if (this.dv.showCompass) {
                    this.dv.minimapCompassPoints.drawPoints(rotation);
                }
                GlStateManager.func_179109_b((float)this.dv.translateX, (float)this.dv.translateY, (float)0.0f);
                this.drawOffMapWaypoints(rotation);
                if (this.dv.showCompass) {
                    GlStateManager.func_179109_b((float)(-this.dv.translateX), (float)(-this.dv.translateY), (float)0.0f);
                    this.dv.minimapCompassPoints.drawLabels(rotation);
                }
            }
            finally {
                GlStateManager.func_179121_F();
            }
            if (this.dv.showFps) {
                this.dv.labelFps.draw(this.fpsLabelText);
            }
            if (this.dv.showLocation) {
                this.dv.labelLocation.draw(this.locationLabelText);
            }
            if (this.dv.showBiome) {
                this.dv.labelBiome.draw(this.biomeLabelText);
            }
            DrawUtil.sizeDisplay(this.dv.scaledResolution.func_78327_c(), this.dv.scaledResolution.func_78324_d());
        }
        catch (Throwable t) {
            JMLogger.logOnce("Error during MiniMap.drawMap(): " + t.getMessage(), t);
        }
        finally {
            this.cleanup();
            timer.stop();
            gridRenderer.clearGlErrors(true);
        }
    }

    private void drawOnMapWaypoints(double rotation) {
        boolean showLabel = this.miniMapProperties.showWaypointLabels.get();
        for (DrawStep.Pass pass : DrawStep.Pass.values()) {
            for (DrawWayPointStep drawWayPointStep : state.getDrawWaypointSteps()) {
                boolean onScreen = false;
                if (pass == DrawStep.Pass.Object) {
                    Point2D.Double waypointPos = drawWayPointStep.getPosition(0.0, 0.0, gridRenderer, true);
                    onScreen = this.isOnScreen(waypointPos, this.centerPoint, this.centerRect);
                    drawWayPointStep.setOnScreen(onScreen);
                } else {
                    onScreen = drawWayPointStep.isOnScreen();
                }
                if (!onScreen) continue;
                drawWayPointStep.setShowLabel(showLabel);
                drawWayPointStep.draw(pass, 0.0, 0.0, gridRenderer, this.dv.drawScale, this.dv.fontScale, rotation);
            }
        }
    }

    private void drawOffMapWaypoints(double rotation) {
        for (DrawWayPointStep drawWayPointStep : state.getDrawWaypointSteps()) {
            if (drawWayPointStep.isOnScreen()) continue;
            Point2D.Double point = this.getPointOnFrame(drawWayPointStep.getPosition(0.0, 0.0, gridRenderer, false), this.centerPoint, this.dv.minimapSpec.waypointOffset);
            drawWayPointStep.drawOffscreen(DrawStep.Pass.Object, point, rotation);
        }
    }

    private void startMapRotation(double rotation) {
        GlStateManager.func_179094_E();
        if (rotation % 360.0 != 0.0) {
            double width = this.dv.displayWidth / 2 + this.dv.translateX;
            double height = this.dv.displayHeight / 2 + this.dv.translateY;
            GlStateManager.func_179137_b((double)width, (double)height, (double)0.0);
            GlStateManager.func_179114_b((float)((float)rotation), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)(-width), (double)(-height), (double)0.0);
        }
        gridRenderer.updateRotation(rotation);
    }

    private void stopMapRotation(double rotation) {
        GlStateManager.func_179121_F();
        gridRenderer.updateRotation(rotation);
    }

    private boolean isOnScreen(Point2D.Double objectPixel, Point2D centerPixel, Rectangle2D.Double centerRect) {
        if (this.dv.shape == Shape.Circle) {
            return centerPixel.distance(objectPixel) < (double)(this.dv.minimapWidth / 2);
        }
        return centerRect.contains(gridRenderer.getWindowPosition(objectPixel));
    }

    private Point2D.Double getPointOnFrame(Point2D.Double objectPixel, Point2D centerPixel, double offset) {
        if (this.dv.shape == Shape.Circle) {
            double bearing = Math.atan2(objectPixel.getY() - centerPixel.getY(), objectPixel.getX() - centerPixel.getX());
            Point2D.Double framePos = new Point2D.Double((double)(this.dv.minimapWidth / 2) * Math.cos(bearing) + centerPixel.getX(), (double)(this.dv.minimapHeight / 2) * Math.sin(bearing) + centerPixel.getY());
            return framePos;
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(this.dv.textureX - this.dv.translateX, this.dv.textureY - this.dv.translateY, this.dv.minimapWidth, this.dv.minimapHeight);
        if (objectPixel.x > rect.getMaxX()) {
            objectPixel.x = rect.getMaxX();
        } else if (objectPixel.x < rect.getMinX()) {
            objectPixel.x = rect.getMinX();
        }
        if (objectPixel.y > rect.getMaxY()) {
            objectPixel.y = rect.getMaxY();
        } else if (objectPixel.y < rect.getMinY()) {
            objectPixel.y = rect.getMinY();
        }
        return objectPixel;
    }

    private void beginStencil() {
        try {
            this.cleanup();
            DrawUtil.zLevel = 1000.0;
            GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            this.dv.minimapFrame.drawMask();
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            DrawUtil.zLevel = 0.0;
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179143_c((int)516);
        }
        catch (Throwable t) {
            JMLogger.logOnce("Error during MiniMap.beginStencil()", t);
        }
    }

    private void endStencil() {
        try {
            GlStateManager.func_179097_i();
        }
        catch (Throwable t) {
            JMLogger.logOnce("Error during MiniMap.endStencil()", t);
        }
    }

    private void cleanup() {
        try {
            DrawUtil.zLevel = 0.0;
            GlStateManager.func_179132_a((boolean)true);
            GL11.glClear((int)256);
            GlStateManager.func_179126_j();
            GlStateManager.func_179143_c((int)515);
            GlStateManager.func_179141_d();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179082_a((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        catch (Throwable t) {
            JMLogger.logOnce("Error during MiniMap.cleanup()", t);
        }
    }

    public void reset() {
        this.initTime = System.currentTimeMillis();
        this.initGridRenderer();
        this.updateDisplayVars((Shape)this.miniMapProperties.shape.get(), (Position)this.miniMapProperties.position.get(), true);
        MiniMapOverlayHandler.checkEventConfig();
        GridRenderer.clearDebugMessages();
        this.playerLocatorTex = TextureCache.instance().getPlayerLocatorSmall();
    }

    public void updateDisplayVars(boolean force) {
        if (this.dv != null) {
            this.updateDisplayVars(this.dv.shape, this.dv.position, force);
        }
    }

    public void updateDisplayVars(Shape shape, Position position, boolean force) {
        if (this.dv != null && !force && this.mc.field_71440_d == this.dv.displayHeight && this.mc.field_71443_c == this.dv.displayWidth && this.dv.shape == shape && this.dv.position == position && this.dv.fontScale == (double)this.miniMapProperties.fontScale.get().intValue()) {
            return;
        }
        this.initGridRenderer();
        if (force) {
            shape = (Shape)this.miniMapProperties.shape.get();
            position = (Position)this.miniMapProperties.position.get();
        }
        this.miniMapProperties.shape.set(shape);
        this.miniMapProperties.position.set(position);
        this.miniMapProperties.save();
        DisplayVars oldDv = this.dv;
        this.dv = new DisplayVars(this.mc, this.miniMapProperties);
        if (oldDv == null || oldDv.shape != this.dv.shape) {
            String timerName = String.format("MiniMap%s.%s", this.miniMapProperties.getId(), shape.name());
            this.drawTimer = StatTimer.get(timerName, 100);
            this.drawTimer.reset();
            this.refreshStateTimer = StatTimer.get(timerName + "+refreshState", 5);
            this.refreshStateTimer.reset();
        }
        this.updateLabels();
        double xpad = 0.0;
        double ypad = 0.0;
        Rectangle2D.Double viewPort = new Rectangle2D.Double((double)this.dv.textureX + xpad, (double)this.dv.textureY + ypad, (double)this.dv.minimapWidth - 2.0 * xpad, (double)this.dv.minimapHeight - 2.0 * ypad);
        gridRenderer.setViewPort(viewPort);
        MiniMap.updateUIState(true);
    }

    private void updateLabels() {
        try {
            if (this.mc.field_71439_g != null) {
                if (this.dv.showFps) {
                    this.fpsLabelText = this.forgeHelper.getFPS();
                }
                if (this.dv.showLocation) {
                    int playerX = MathHelper.func_76128_c((double)this.player.field_70165_t);
                    int playerZ = MathHelper.func_76128_c((double)this.player.field_70161_v);
                    int playerY = MathHelper.func_76128_c((double)this.forgeHelper.getEntityBoundingBox((EntityLivingBase)this.player).field_72338_b);
                    this.locationLabelText = this.dv.locationFormatKeys.format(this.dv.locationFormatVerbose, playerX, playerZ, playerY, this.mc.field_71439_g.field_70162_ai);
                }
                if (this.dv.showBiome) {
                    this.biomeLabelText = state.getPlayerBiome();
                }
            }
            this.lastLabelRefresh = System.currentTimeMillis();
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Unexpected error updating minimap labels: " + LogFormatter.toString(e));
        }
    }
}

