/*
 * Decompiled with CFR 0.152.
 */
package journeymap.server;

import java.io.File;
import java.util.Map;
import journeymap.common.CommonProxy;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.migrate.Migration;
import journeymap.common.network.PacketHandler;
import journeymap.server.nbt.WorldNbtIDSaveHandler;
import journeymap.server.oldservercode.chat.ChatHandler;
import journeymap.server.oldservercode.config.ConfigHandler;
import journeymap.server.oldservercode.events.ForgeEvents;
import journeymap.server.oldservercode.network.ForgePacketHandler;
import journeymap.server.oldservercode.network.PacketManager;
import journeymap.server.oldservercode.reference.Controller;
import journeymap.server.oldservercode.util.ForgeChat;
import journeymap.server.oldservercode.util.ForgePlayerUtil;
import journeymap.server.oldservercode.util.PlayerUtil;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.SERVER)
public class JourneymapServer
implements CommonProxy {
    public static String WORLD_NAME;
    private Logger logger = Journeymap.getLogger();

    public static String getWorldName() {
        return WORLD_NAME;
    }

    public static void setWorldName(String worldName) {
        WORLD_NAME = worldName;
    }

    @Override
    @SideOnly(value=Side.SERVER)
    @Mod.EventHandler
    public void preInitialize(FMLPreInitializationEvent event) {
        try {
            boolean migrationOk = new Migration("journeymap.server.task.migrate").performTasks();
            ConfigHandler.init(new File(event.getModConfigurationDirectory() + "/JourneyMapServer/"));
        }
        catch (Throwable t) {
            if (this.logger == null) {
                this.logger = LogManager.getLogger((String)"journeymap");
            }
            this.logger.error(LogFormatter.toString(t));
        }
    }

    @Override
    @SideOnly(value=Side.SERVER)
    public void initialize(FMLInitializationEvent event) {
        Controller.setController(Controller.FORGE);
        MinecraftForge.EVENT_BUS.register((Object)new ForgeEvents());
        PacketManager.init(new ForgePacketHandler());
        PlayerUtil.init(new ForgePlayerUtil());
        ChatHandler.init(new ForgeChat());
    }

    @Override
    @SideOnly(value=Side.SERVER)
    public void postInitialize(FMLPostInitializationEvent event) {
    }

    @Override
    public boolean checkModLists(Map<String, String> modList, Side side) {
        this.logger.info(side.toString());
        for (String s : modList.keySet()) {
        }
        return true;
    }

    @Override
    public boolean isUpdateCheckEnabled() {
        return false;
    }

    @Override
    public void handleWorldIdMessage(String message, EntityPlayerMP playerEntity) {
        WorldNbtIDSaveHandler nbt = new WorldNbtIDSaveHandler();
        PacketHandler.sendPlayerWorldID(nbt.getWorldID(), playerEntity);
    }
}

