/*
 * Decompiled with CFR 0.152.
 */
package journeymap.server.oldservercode.network;

import journeymap.common.Journeymap;
import journeymap.server.oldservercode.network.IPacketHandler;
import journeymap.server.oldservercode.network.WorldIDPacket;
import journeymap.server.oldservercode.util.ForgePlayerUtil;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class ForgePacketHandler
implements IPacketHandler {
    public static final SimpleNetworkWrapper WORLD_INFO_CHANNEL = NetworkRegistry.INSTANCE.newSimpleChannel("world_info");

    @Override
    public void init() {
        WORLD_INFO_CHANNEL.registerMessage(WorldIDPacket.WorldIdListener.class, WorldIDPacket.class, 0, Side.SERVER);
    }

    @Override
    public void sendAllPlayersWorldID(String worldID) {
        WORLD_INFO_CHANNEL.sendToAll((IMessage)new WorldIDPacket(worldID));
    }

    @Override
    public void sendPlayerWorldID(String worldID, String playerName) {
        EntityPlayerMP player = ForgePlayerUtil.instance.getPlayerEntityByName(playerName);
        if (player instanceof EntityPlayerMP && player != null) {
            try {
                WORLD_INFO_CHANNEL.sendTo((IMessage)new WorldIDPacket(worldID), player);
            }
            catch (RuntimeException rte) {
                Journeymap.getLogger().error(playerName + " is not a real player. WorldID:" + worldID + " Error: " + rte);
            }
            catch (Exception e) {
                Journeymap.getLogger().error("Unknown Exception - PlayerName:" + playerName + " WorldID:" + worldID + " Exception " + e);
            }
        }
    }
}

