/*
 * Decompiled with CFR 0.152.
 */
package se.rupy.http;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permissions;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import se.rupy.http.Chain;
import se.rupy.http.Deploy;
import se.rupy.http.Event;
import se.rupy.http.Failure;
import se.rupy.http.Query;
import se.rupy.http.Service;
import se.rupy.http.Session;
import se.rupy.http.Test;
import se.rupy.http.Worker;

public class Daemon
implements Runnable {
    protected Properties properties;
    protected boolean verbose;
    protected boolean debug;
    protected boolean host;
    protected boolean alive;
    protected boolean panel;
    protected int threads;
    protected int timeout;
    protected int cookie;
    protected int delay;
    protected int size;
    protected int port;
    private int selected;
    private int valid;
    private int accept;
    private int readwrite;
    private HashMap archive;
    private HashMap service;
    protected ConcurrentHashMap events;
    protected ConcurrentHashMap session;
    private Chain workers;
    private Chain queue;
    private Heart heart;
    private Selector selector;
    private String pass;
    protected PrintStream out;
    protected PrintStream access;
    protected PrintStream error;
    private static DateFormat DATE;
    public AccessControlContext control;
    private Listener listener;

    public Daemon() {
        this(new Properties());
    }

    public Daemon(Properties properties) {
        this.properties = properties;
        this.threads = Integer.parseInt(properties.getProperty("threads", "5"));
        this.cookie = Integer.parseInt(properties.getProperty("cookie", "4"));
        this.port = Integer.parseInt(properties.getProperty("port", "8000"));
        this.timeout = Integer.parseInt(properties.getProperty("timeout", "300")) * 1000;
        this.delay = Integer.parseInt(properties.getProperty("delay", "5000"));
        this.size = Integer.parseInt(properties.getProperty("size", "1024"));
        this.verbose = properties.getProperty("verbose", "false").toLowerCase().equals("true");
        this.debug = properties.getProperty("debug", "false").toLowerCase().equals("true");
        this.host = properties.getProperty("host", "false").toLowerCase().equals("true");
        this.panel = properties.getProperty("panel", "false").toLowerCase().equals("true");
        if (this.host) {
            Permissions permissions = new Permissions();
            this.control = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
        }
        if (!this.verbose) {
            this.debug = false;
        }
        this.archive = new HashMap();
        this.service = new HashMap();
        this.session = new ConcurrentHashMap();
        this.events = new ConcurrentHashMap();
        this.workers = new Chain();
        this.queue = new Chain();
        try {
            this.out = new PrintStream((OutputStream)System.out, true, "UTF-8");
            if (properties.getProperty("log") != null || properties.getProperty("test", "false").toLowerCase().equals("true")) {
                this.log();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Properties properties() {
        return this.properties;
    }

    protected void log() throws IOException {
        this.access = System.out;
        this.error = System.err;
        DATE = new SimpleDateFormat("yy-MM-dd HH:mm:ss.SSS");
    }

    protected void error(Event event, Throwable t) throws IOException {
        if (this.error != null && t != null && !(t instanceof Failure.Close)) {
            Calendar date = Calendar.getInstance();
            StringBuilder b = new StringBuilder();
            b.append(DATE.format(date.getTime()));
            b.append(' ');
            b.append(event.remote());
            b.append(' ');
            b.append(event.query().path());
            String parameters = event.query().parameters();
            if (parameters != null) {
                b.append(' ');
                b.append(parameters);
            }
            b.append("\r\n");
            this.error.write(b.toString().getBytes("UTF-8"));
            t.printStackTrace(this.error);
        }
    }

    protected String access(Event event) throws IOException {
        if (this.access != null && !event.reply().push()) {
            Calendar date = Calendar.getInstance();
            StringBuilder b = new StringBuilder();
            b.append(DATE.format(date.getTime()));
            b.append(' ');
            b.append(event.remote());
            b.append(' ');
            b.append(event.query().path());
            b.append(' ');
            b.append(event.reply().code());
            int length = event.reply().length();
            if (length > 0) {
                b.append(' ');
                b.append(length);
            }
            return b.toString();
        }
        return null;
    }

    protected void access(String row, boolean push) throws IOException {
        if (this.access != null) {
            StringBuilder b = new StringBuilder();
            b.append(row);
            if (push) {
                b.append(' ');
                b.append('>');
            }
            b.append("\r\n");
            this.access.write(b.toString().getBytes("UTF-8"));
        }
    }

    public void init() {
        this.heart = new Heart();
        int threads = Integer.parseInt(this.properties.getProperty("threads", "5"));
        for (int i = 0; i < threads; ++i) {
            this.workers.add(new Worker(this, i));
        }
        this.alive = true;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void start() {
        try {
            this.init();
            new Thread((Runnable)this, "RupyDaemon").start();
        }
        catch (Exception e) {
            e.printStackTrace(this.out);
        }
    }

    public void stop() {
        for (Worker worker : this.workers) {
            worker.stop();
        }
        this.workers.clear();
        this.alive = false;
        this.heart.stop();
        this.selector.wakeup();
    }

    public ConcurrentHashMap session() {
        return this.session;
    }

    protected Selector selector() {
        return this.selector;
    }

    protected void chain(Deploy.Archive archive) throws Exception {
        Deploy.Archive old = (Deploy.Archive)this.archive.get(archive.name());
        if (old != null) {
            for (final Service service : old.service()) {
                try {
                    if (this.host) {
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                service.destroy();
                                return null;
                            }
                        }, archive.access());
                        continue;
                    }
                    service.destroy();
                }
                catch (Exception e) {
                    e.printStackTrace(this.out);
                }
            }
        }
        for (final Service service : archive.service()) {
            this.add(archive.chain(), service, archive);
        }
        this.archive.put(archive.name(), archive);
    }

    public Deploy.Archive archive(String name) {
        if (!name.endsWith(".jar")) {
            name = name + ".jar";
        }
        if (this.host) {
            if (name.equals("host.rupy.se.jar")) {
                return Deploy.Archive.deployer;
            }
            Deploy.Archive archive = (Deploy.Archive)this.archive.get(name);
            if (archive == null) {
                return (Deploy.Archive)this.archive.get("www." + name);
            }
            return archive;
        }
        return (Deploy.Archive)this.archive.get(name);
    }

    public Object send(Object message) throws Exception {
        if (this.listener == null) {
            return message;
        }
        return this.listener.receive(message);
    }

    public void set(Listener listener) {
        this.listener = listener;
    }

    public void add(Service service) throws Exception {
        this.add(this.service, service, null);
    }

    protected void add(HashMap map, final Service service, Deploy.Archive archive) throws Exception {
        String path = null;
        path = this.host ? (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return service.path();
            }
        }, this.control) : service.path();
        if (path == null) {
            path = "null";
        }
        StringTokenizer paths = new StringTokenizer(path, ":");
        while (paths.hasMoreTokens()) {
            path = paths.nextToken();
            Chain chain = (Chain)map.get(path);
            if (chain == null) {
                chain = new Chain();
                map.put(path, chain);
            }
            final Service old = (Service)chain.put(service);
            if (this.host) {
                final String p = path;
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        if (old != null) {
                            throw new Exception(service.getClass().getName() + " with path '" + p + "' and index [" + service.index() + "] is conflicting with " + old.getClass().getName() + " for the same path and index.");
                        }
                        return null;
                    }
                }, this.control);
            } else if (old != null) {
                throw new Exception(service.getClass().getName() + " with path '" + path + "' and index [" + service.index() + "] is conflicting with " + old.getClass().getName() + " for the same path and index.");
            }
            if (this.verbose) {
                this.out.println(path + this.padding(path) + chain);
            }
            try {
                if (this.host) {
                    final Daemon daemon = this;
                    Event e = (Event)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            service.create(daemon);
                            return null;
                        }
                    }, archive == null ? this.control : archive.access());
                    continue;
                }
                service.create(this);
            }
            catch (Exception e) {
                e.printStackTrace(this.out);
            }
        }
    }

    protected String padding(String path) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < 10 - path.length(); ++i) {
            buffer.append(' ');
        }
        return buffer.toString();
    }

    protected void verify(final Deploy.Archive archive) throws Exception {
        for (final String path : archive.chain().keySet()) {
            Chain chain = (Chain)archive.chain().get(path);
            for (int i = 0; i < chain.size(); ++i) {
                final Service service = (Service)chain.get(i);
                if (this.host) {
                    final HashMap a = this.archive;
                    final int j = i;
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            if (j != service.index()) {
                                a.remove(archive.name());
                                throw new Exception(service.getClass().getName() + " with path '" + path + "' has index [" + service.index() + "] which is too high.");
                            }
                            return null;
                        }
                    }, this.control);
                    continue;
                }
                if (i == service.index()) continue;
                this.archive.remove(archive.name());
                throw new Exception(service.getClass().getName() + " with path '" + path + "' has index [" + service.index() + "] which is too high.");
            }
        }
    }

    protected Deploy.Stream content(Query query) {
        if (this.host) {
            return this.content(query.header("host"), query.path());
        }
        return this.content(query.path());
    }

    protected Deploy.Stream content(String path) {
        return this.content("content", path);
    }

    protected Deploy.Stream content(String host, String path) {
        File file = new File("app" + File.separator + host + File.separator + path);
        if (file.exists() && !file.isDirectory()) {
            return new Deploy.Big(file);
        }
        if (this.host && (file = new File("app" + File.separator + "www." + host + File.separator + path)).exists() && !file.isDirectory()) {
            return new Deploy.Big(file);
        }
        return null;
    }

    protected Chain chain(Query query) {
        if (this.host) {
            return this.chain(query.header("host"), query.path());
        }
        return this.chain(query.path());
    }

    public Chain chain(String path) {
        return this.chain("content", path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chain chain(String host, String path) {
        HashMap hashMap = this.service;
        synchronized (hashMap) {
            Chain chain = (Chain)this.service.get(path);
            if (chain != null) {
                return chain;
            }
        }
        hashMap = this.archive;
        synchronized (hashMap) {
            if (this.host) {
                Chain chain;
                Deploy.Archive archive = (Deploy.Archive)this.archive.get(host + ".jar");
                if (archive == null) {
                    archive = (Deploy.Archive)this.archive.get("www." + host + ".jar");
                }
                if (archive != null && (chain = (Chain)archive.chain().get(path)) != null) {
                    return chain;
                }
            } else {
                for (Deploy.Archive archive : this.archive.values()) {
                    Chain chain;
                    if (!archive.host().equals(host) || (chain = (Chain)archive.chain().get(path)) == null) continue;
                    return chain;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Event next(Worker worker) {
        Chain chain = this.queue;
        synchronized (chain) {
            if (this.queue.size() > 0) {
                if (this.debug) {
                    this.out.println("worker " + worker.index() + " found work " + this.queue);
                }
                return (Event)this.queue.remove(0);
            }
        }
        return null;
    }

    @Override
    public void run() {
        String pass = this.properties.getProperty("pass", "");
        ServerSocketChannel server = null;
        try {
            this.selector = Selector.open();
            server = ServerSocketChannel.open();
            server.socket().bind(new InetSocketAddress(this.port));
            server.configureBlocking(false);
            server.register(this.selector, 16);
            DecimalFormat decimal = (DecimalFormat)DecimalFormat.getInstance();
            decimal.applyPattern("#.##");
            if (this.verbose) {
                this.out.println("daemon started\n- pass       \t" + pass + "\n" + "- port       \t" + this.port + "\n" + "- worker(s)  \t" + this.threads + " thread" + (this.threads > 1 ? "s" : "") + "\n" + "- session    \t" + this.cookie + " characters\n" + "- timeout    \t" + decimal.format((double)this.timeout / 60000.0) + " minute" + (this.timeout / 60000 > 1 ? "s" : "") + "\n" + "- IO timeout \t" + this.delay + " ms." + "\n" + "- IO buffer  \t" + this.size + " bytes\n" + "- debug      \t" + this.debug + "\n" + "- live       \t" + this.properties.getProperty("live", "false").toLowerCase().equals("true"));
            }
            if (pass != null && pass.length() > 0 || this.host) {
                if (this.host) {
                    this.add(new Deploy("app" + File.separator));
                } else {
                    this.add(new Deploy("app" + File.separator, pass));
                }
                File[] app = new File(Deploy.path).listFiles(new Filter());
                if (app != null) {
                    for (int i = 0; i < app.length; ++i) {
                        Deploy.deploy(this, app[i]);
                    }
                }
            }
            if (this.panel) {
                this.add(new Service(){

                    @Override
                    public String path() {
                        return "/panel";
                    }

                    @Override
                    public void filter(Event event) throws Event, Exception {
                        Iterator<Object> it = Daemon.this.workers.iterator();
                        event.output().println("<pre>workers: {size: " + Daemon.this.workers.size() + ", ");
                        while (it.hasNext()) {
                            Worker worker = (Worker)it.next();
                            event.output().print(" worker: {index: " + worker.index() + ", busy: " + worker.busy() + ", lock: " + worker.lock());
                            if (worker.event() != null) {
                                event.output().println(", ");
                                event.output().println("  event: {index: " + worker.event() + ", init: " + worker.event().reply().output.init + ", done: " + worker.event().reply().output.done + "}");
                                event.output().println(" }");
                                continue;
                            }
                            event.output().println("}");
                        }
                        event.output().println("}");
                        event.output().println("events: {size: " + Daemon.this.events.size() + ", selected: " + Daemon.this.selected + ", valid: " + Daemon.this.valid + ", accept: " + Daemon.this.accept + ", readwrite: " + Daemon.this.readwrite + ", ");
                        for (Event e : Daemon.this.events.values()) {
                            event.output().println(" event: {index: " + e + ", last: " + (System.currentTimeMillis() - e.last()) + "}");
                        }
                        event.output().println("}</pre>");
                    }
                });
            }
            if (this.properties.getProperty("test", "false").toLowerCase().equals("true")) {
                new Test(this, 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace(this.out);
            throw new RuntimeException(e);
        }
        int index = 0;
        Event event = null;
        SelectionKey key = null;
        while (this.alive) {
            try {
                this.selector.select();
                Set<SelectionKey> set = this.selector.selectedKeys();
                int valid = 0;
                int accept = 0;
                int readwrite = 0;
                int selected = set.size();
                Iterator<SelectionKey> it = set.iterator();
                while (it.hasNext()) {
                    key = it.next();
                    it.remove();
                    if (!key.isValid()) continue;
                    ++valid;
                    if (key.isAcceptable()) {
                        ++accept;
                        event = new Event(this, key, index++);
                        this.events.put(new Integer(event.index()), event);
                        event.log("accept ---");
                        continue;
                    }
                    if (!key.isReadable() && !key.isWritable()) continue;
                    ++readwrite;
                    key.interestOps(0);
                    event = (Event)key.attachment();
                    Worker worker = event.worker();
                    if (this.debug) {
                        if (key.isReadable()) {
                            event.log("read ---");
                        }
                        if (key.isWritable()) {
                            event.log("write ---");
                        }
                    }
                    if (key.isReadable() && event.push()) {
                        event.disconnect(null);
                        continue;
                    }
                    if (worker == null) {
                        this.employ(event);
                        continue;
                    }
                    worker.wakeup();
                }
                this.valid = valid;
                this.accept = accept;
                this.readwrite = readwrite;
                this.selected = selected;
            }
            catch (Exception e) {
                if (event == null) {
                    System.out.println(this.events + " " + key);
                    continue;
                }
                event.disconnect(e);
            }
        }
        try {
            if (this.selector != null) {
                this.selector.close();
            }
            if (server != null) {
                server.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace(this.out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queue(Event event) {
        Chain chain = this.queue;
        synchronized (chain) {
            this.queue.add(event);
        }
        if (this.debug) {
            this.out.println("queue " + this.queue.size());
        }
    }

    protected synchronized void employ(Event event) {
        if (this.queue.size() > 0) {
            this.queue(event);
            return;
        }
        this.workers.reset();
        Worker worker = (Worker)this.workers.next();
        if (worker == null) {
            this.queue(event);
            return;
        }
        while (worker.busy()) {
            worker = (Worker)this.workers.next();
            if (worker != null) continue;
            this.queue(event);
            return;
        }
        if (this.debug) {
            this.out.println("worker " + worker.index() + " hired. (" + this.queue.size() + ")");
        }
        event.worker(worker);
        worker.event(event);
        worker.wakeup();
    }

    protected void log(PrintStream out) {
        if (out != null) {
            this.out = out;
        }
    }

    protected void log(Object o) {
        if (this.out != null) {
            this.out.println(o);
        }
    }

    public static void main(String[] args) {
        Properties properties = new Properties();
        for (int i = 0; i < args.length; ++i) {
            String flag = args[i];
            String value = null;
            if (flag.startsWith("-") && ++i < args.length && (value = args[i]).startsWith("-")) {
                --i;
                value = null;
            }
            if (value == null) {
                properties.put(flag.substring(1).toLowerCase(), "true");
                continue;
            }
            properties.put(flag.substring(1).toLowerCase(), value);
        }
        if (properties.getProperty("help", "false").toLowerCase().equals("true")) {
            System.out.println("Usage: java -jar http.jar -verbose");
            return;
        }
        new Daemon(properties).start();
    }

    class Heart
    implements Runnable {
        boolean alive = true;

        Heart() {
            new Thread((Runnable)this, "RupyHeart").start();
        }

        protected void stop() {
            this.alive = false;
        }

        @Override
        public void run() {
            while (this.alive) {
                try {
                    Thread.sleep(1000L);
                    Iterator<Object> it = Daemon.this.session.values().iterator();
                    while (it.hasNext()) {
                        Session se = (Session)it.next();
                        if (System.currentTimeMillis() - se.date() <= (long)Daemon.this.timeout) continue;
                        it.remove();
                        se.remove();
                        if (!Daemon.this.debug) continue;
                        Daemon.this.out.println("session timeout " + se.key());
                    }
                    for (Worker worker : Daemon.this.workers) {
                        worker.busy();
                    }
                    for (Event event : Daemon.this.events.values()) {
                        if (System.currentTimeMillis() - event.last() <= 300000L) continue;
                        event.disconnect(null);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(Daemon.this.out);
                }
            }
        }
    }

    class Filter
    implements FilenameFilter {
        Filter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    }

    public static interface Listener {
        public Object receive(Object var1) throws Exception;
    }
}

