/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified;

import com.almostreliable.unified.AlmostUnifiedPlatform;
import com.almostreliable.unified.api.StoneStrataHandler;
import com.almostreliable.unified.config.UnifyConfig;
import com.almostreliable.unified.utils.ReplacementMap;
import com.almostreliable.unified.utils.TagMap;
import com.almostreliable.unified.utils.TagOwnerships;
import com.almostreliable.unified.utils.UnifyTag;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public record ReplacementData(TagMap<Item> globalTagMap, TagMap<Item> filteredTagMap, StoneStrataHandler stoneStrataHandler, ReplacementMap replacementMap) {
    public static ReplacementData load(Map<ResourceLocation, Collection<Holder<Item>>> tags, UnifyConfig unifyConfig, TagOwnerships tagOwnerships) {
        TagMap<Item> globalTagMap = TagMap.createFromItemTags(tags);
        Set<UnifyTag<Item>> unifyTags = unifyConfig.bakeAndValidateTags(tags);
        TagMap<Item> filteredTagMap = globalTagMap.filtered(unifyTags::contains, unifyConfig::includeItem);
        StoneStrataHandler stoneStrataHandler = StoneStrataHandler.create(unifyConfig.getStoneStrata(), AlmostUnifiedPlatform.INSTANCE.getStoneStrataTags(unifyConfig.getStoneStrata()), globalTagMap);
        ReplacementMap replacementMap = new ReplacementMap(unifyConfig, filteredTagMap, stoneStrataHandler, tagOwnerships);
        return new ReplacementData(globalTagMap, filteredTagMap, stoneStrataHandler, replacementMap);
    }
}

