/*
 * Decompiled with CFR 0.152.
 */
package com.dreu.traversableleaves.mixin;

import com.dreu.traversableleaves.interfaces.ITraversableBlock;
import com.dreu.traversableleaves.interfaces.ITraversableEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockBehaviour.BlockStateBase.class})
public abstract class BlockStateBaseMixin {
    @Inject(method={"isSuffocating"}, at={@At(value="HEAD")}, cancellable=true)
    private void onIsSuffocating(BlockGetter level, BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        ITraversableBlock block;
        Block block2 = this.m_60734_();
        if (block2 instanceof ITraversableBlock && (block = (ITraversableBlock)block2).isTraversable()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"isPathfindable"}, at={@At(value="HEAD")}, cancellable=true)
    public void onIsPathfindable(BlockGetter level, BlockPos blockPos, PathComputationType pathType, CallbackInfoReturnable<Boolean> cir) {
        ITraversableBlock iTraversable;
        Block block = this.m_60734_();
        if (block instanceof ITraversableBlock && (iTraversable = (ITraversableBlock)block).isTraversable()) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"getCollisionShape(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/shapes/CollisionContext;)Lnet/minecraft/world/phys/shapes/VoxelShape;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetCollisionShapeWithContext(BlockGetter level, BlockPos blockPos, CollisionContext context, CallbackInfoReturnable<VoxelShape> cir) {
        EntityCollisionContext entityContext;
        ITraversableBlock block;
        Block block2 = this.m_60734_();
        if (block2 instanceof ITraversableBlock && (block = (ITraversableBlock)block2).isTraversable() && context instanceof EntityCollisionContext && (entityContext = (EntityCollisionContext)context).m_193113_() != null) {
            Entity entity = entityContext.m_193113_();
            if (entity instanceof LivingEntity) {
                Player player;
                LivingEntity livingEntity = (LivingEntity)entity;
                if (livingEntity instanceof Player && (player = (Player)livingEntity).m_7500_() && player.m_150110_().f_35935_) {
                    cir.setReturnValue((Object)Shapes.m_83040_());
                }
                if (context.m_6513_(this.m_60734_().m_5939_(this.m_7160_(), level, blockPos, context), blockPos, false) && !context.m_6226_()) {
                    cir.setReturnValue((Object)this.m_60734_().m_5939_(this.m_7160_(), level, blockPos, context));
                } else if (ITraversableEntity.canTraverse((Entity)livingEntity)) {
                    cir.setReturnValue((Object)Shapes.m_83040_());
                }
            } else if (!(entityContext.m_193113_() instanceof ItemEntity)) {
                cir.setReturnValue((Object)Shapes.m_83040_());
            }
        }
    }

    @Shadow
    protected abstract BlockState m_7160_();

    @Shadow
    public abstract Block m_60734_();
}

