/*
 * Decompiled with CFR 0.152.
 */
package com.maxwell.cyber_ware_port.common.block.cwb;

import com.maxwell.cyber_ware_port.common.block.cwb.recipe.AssemblyRecipe;
import com.maxwell.cyber_ware_port.common.block.cwb.recipe.EngineeringRecipe;
import com.maxwell.cyber_ware_port.common.container.CyberwareWorkbenchMenu;
import com.maxwell.cyber_ware_port.common.item.BlueprintItem;
import com.maxwell.cyber_ware_port.common.item.base.ICyberware;
import com.maxwell.cyber_ware_port.init.ModBlockEntities;
import com.maxwell.cyber_ware_port.init.ModRecipes;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CyberwareWorkbenchBlockEntity
extends BlockEntity
implements MenuProvider {
    public static final int INPUT_SLOT = 0;
    public static final int PAPER_SLOT = 1;
    public static final int BLUEPRINT_SLOT = 2;
    public static final int OUTPUT_SLOT_START = 3;
    public static final int OUTPUT_SLOT_END = 8;
    public static final int SPECIAL_OUTPUT_SLOT = 9;
    private static final int INVENTORY_SIZE = 10;
    public float animationProgress = 0.0f;
    public float prevAnimationProgress = 0.0f;
    private AssemblyRecipe cachedRecipe = null;
    private final ItemStackHandler itemHandler = new ItemStackHandler(10){

        protected void onContentsChanged(int slot) {
            CyberwareWorkbenchBlockEntity.this.m_6596_();
            if (slot == 2) {
                CyberwareWorkbenchBlockEntity.this.cachedRecipe = null;
            }
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot >= 3) {
                return true;
            }
            return switch (slot) {
                case 0 -> stack.m_41720_() instanceof ICyberware;
                case 1 -> stack.m_150930_(Items.f_42516_);
                case 2 -> stack.m_41720_() instanceof BlueprintItem;
                default -> false;
            };
        }
    };
    private final IItemHandler automationInputHandler = new IItemHandler(){

        public int getSlots() {
            return 10;
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return CyberwareWorkbenchBlockEntity.this.itemHandler.getStackInSlot(slot);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (stack.m_41619_()) {
                return stack;
            }
            if (stack.m_150930_(Items.f_42516_)) {
                return CyberwareWorkbenchBlockEntity.this.itemHandler.insertItem(1, stack, simulate);
            }
            if (stack.m_41720_() instanceof BlueprintItem) {
                return CyberwareWorkbenchBlockEntity.this.itemHandler.insertItem(2, stack, simulate);
            }
            if (stack.m_41720_() instanceof ICyberware) {
                return CyberwareWorkbenchBlockEntity.this.itemHandler.insertItem(0, stack, simulate);
            }
            AssemblyRecipe activeRecipe = CyberwareWorkbenchBlockEntity.this.getActiveAssemblyRecipe();
            if (activeRecipe != null && !CyberwareWorkbenchBlockEntity.this.isItemNeededForRecipe(activeRecipe, stack)) {
                return stack;
            }
            ItemStack remaining = stack.m_41777_();
            for (int i = 3; i < 9; ++i) {
                if (!(remaining = CyberwareWorkbenchBlockEntity.this.itemHandler.insertItem(i, remaining, simulate)).m_41619_()) continue;
                return ItemStack.f_41583_;
            }
            return remaining;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return CyberwareWorkbenchBlockEntity.this.itemHandler.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return true;
        }
    };
    private final IItemHandler automationOutputHandler = new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 3, 10){

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return stack;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack stackInSlot;
            int absoluteSlot = slot + 3;
            if (absoluteSlot == 9) {
                return super.extractItem(slot, amount, simulate);
            }
            AssemblyRecipe activeRecipe = CyberwareWorkbenchBlockEntity.this.getActiveAssemblyRecipe();
            if (activeRecipe != null && !(stackInSlot = CyberwareWorkbenchBlockEntity.this.itemHandler.getStackInSlot(absoluteSlot)).m_41619_() && CyberwareWorkbenchBlockEntity.this.isItemNeededForRecipe(activeRecipe, stackInSlot)) {
                return ItemStack.f_41583_;
            }
            return super.extractItem(slot, amount, simulate);
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private LazyOptional<IItemHandler> lazyInputHandler = LazyOptional.empty();
    private LazyOptional<IItemHandler> lazyOutputHandler = LazyOptional.empty();
    private int progress = 0;
    private boolean isCrafting = false;
    private int cooldown = 0;

    public CyberwareWorkbenchBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.CYBERWARE_WORKBENCH.get(), pPos, pBlockState);
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, CyberwareWorkbenchBlockEntity pBlockEntity) {
        pBlockEntity.prevAnimationProgress = pBlockEntity.animationProgress;
        if (pBlockEntity.cooldown > 0) {
            --pBlockEntity.cooldown;
        }
        float target = pBlockEntity.isCrafting ? 1.0f : 0.0f;
        float speed = 0.5f;
        if (pBlockEntity.animationProgress < target) {
            pBlockEntity.animationProgress = Math.min(pBlockEntity.animationProgress + speed, target);
        } else if (pBlockEntity.animationProgress > target) {
            pBlockEntity.animationProgress = Math.max(pBlockEntity.animationProgress - speed, target);
        }
        if (!pLevel.f_46443_) {
            if (pLevel.m_276867_(pPos)) {
                pBlockEntity.startCrafting();
            }
            if (pBlockEntity.cooldown == 0 && pBlockEntity.isCrafting) {
                pLevel.m_5594_(null, pPos, SoundEvents.f_11668_, SoundSource.BLOCKS, 0.5f, 1.2f);
                pBlockEntity.cooldown = 3;
                pBlockEntity.craftItem();
            }
            if (pBlockEntity.isCrafting && pBlockEntity.animationProgress >= 1.0f) {
                pBlockEntity.resetCrafting();
            }
        }
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public void startCrafting() {
        if (!this.isCrafting && this.canCraft()) {
            this.isCrafting = true;
            this.animationProgress = 0.0f;
            this.progress = 0;
            this.m_6596_();
            this.notifyClient();
        }
    }

    private void resetCrafting() {
        this.isCrafting = false;
        this.progress = 0;
        this.cooldown = 1;
        this.m_6596_();
        this.notifyClient();
    }

    private void notifyClient() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    private boolean checkOrConsumeIngredients(AssemblyRecipe recipe, boolean consume) {
        for (AssemblyRecipe.SizedIngredient req : recipe.getInputs()) {
            int needed = req.count();
            int found = 0;
            for (int i = 3; i < 9; ++i) {
                ItemStack stack = this.itemHandler.getStackInSlot(i);
                if (!req.ingredient().test(stack)) continue;
                int take = Math.min(stack.m_41613_(), needed - found);
                if (consume) {
                    this.itemHandler.extractItem(i, take, false);
                }
                if ((found += take) >= needed) break;
            }
            if (found >= needed) continue;
            return false;
        }
        return true;
    }

    private boolean canCraft() {
        AssemblyRecipe recipe = this.getActiveAssemblyRecipe();
        if (recipe != null) {
            if (this.checkOrConsumeIngredients(recipe, false)) {
                ItemStack result = recipe.m_8043_(Objects.requireNonNull(this.f_58857_).m_9598_());
                ItemStack currentOutput = this.itemHandler.getStackInSlot(9);
                if (currentOutput.m_41619_()) {
                    return true;
                }
                return ItemStack.m_150942_((ItemStack)currentOutput, (ItemStack)result) && currentOutput.m_41613_() + result.m_41613_() <= currentOutput.m_41741_();
            }
            return false;
        }
        ItemStack inputStack = this.itemHandler.getStackInSlot(0);
        if (inputStack.m_41619_()) {
            return false;
        }
        ItemStack paperStack = this.itemHandler.getStackInSlot(1);
        if (paperStack.m_41619_() || !paperStack.m_150930_(Items.f_42516_)) {
            return false;
        }
        SimpleContainer tempContainer = new SimpleContainer(1);
        tempContainer.m_6836_(0, inputStack);
        Optional recipeOpt = Objects.requireNonNull(this.f_58857_).m_7465_().m_44015_((RecipeType)ModRecipes.ENGINEERING_TYPE.get(), (Container)tempContainer, this.f_58857_);
        if (recipeOpt.isPresent()) {
            for (int i = 3; i < 9; ++i) {
                if (!this.itemHandler.getStackInSlot(i).m_41619_()) continue;
                return true;
            }
        }
        return false;
    }

    private ItemStack mergeIntoOutput(ItemStack stack) {
        ItemStack remainder = stack.m_41777_();
        for (int i = 3; i < 9; ++i) {
            if (!(remainder = this.itemHandler.insertItem(i, remainder, false)).m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return remainder;
    }

    private void craftItem() {
        AssemblyRecipe recipe = this.getActiveAssemblyRecipe();
        if (recipe != null) {
            if (this.checkOrConsumeIngredients(recipe, true)) {
                ItemStack result = recipe.m_8043_(Objects.requireNonNull(this.f_58857_).m_9598_()).m_41777_();
                Item item = result.m_41720_();
                if (item instanceof ICyberware) {
                    ICyberware cyberware = (ICyberware)item;
                    cyberware.setPristine(result, true);
                }
                this.itemHandler.insertItem(9, result, false);
                this.itemHandler.extractItem(2, 1, false);
            }
            return;
        }
        ItemStack inputStack = this.itemHandler.getStackInSlot(0);
        if (inputStack.m_41619_()) {
            return;
        }
        SimpleContainer tempContainer = new SimpleContainer(1);
        tempContainer.m_6836_(0, inputStack);
        Optional recipeOpt = Objects.requireNonNull(this.f_58857_).m_7465_().m_44015_((RecipeType)ModRecipes.ENGINEERING_TYPE.get(), (Container)tempContainer, this.f_58857_);
        if (recipeOpt.isPresent()) {
            EngineeringRecipe engRecipe = (EngineeringRecipe)recipeOpt.get();
            List<ItemStack> results = engRecipe.rollOutputs(this.f_58857_.f_46441_);
            this.itemHandler.extractItem(0, 1, false);
            for (ItemStack result : results) {
                ItemStack remainder = this.mergeIntoOutput(result);
                if (remainder.m_41619_()) continue;
                Block.m_49840_((Level)this.f_58857_, (BlockPos)this.f_58858_.m_7494_(), (ItemStack)remainder);
            }
            ItemStack paperStack = this.itemHandler.getStackInSlot(1);
            if (!paperStack.m_41619_() && paperStack.m_150930_(Items.f_42516_)) {
                ItemStack blueprint;
                ItemStack remainder;
                float chance = engRecipe.getBlueprintChance();
                if (this.f_58857_.f_46441_.m_188501_() < chance && (remainder = this.mergeIntoOutput(blueprint = BlueprintItem.createBlueprintFor(inputStack.m_41720_()))).m_41619_()) {
                    this.itemHandler.extractItem(1, 1, false);
                }
            }
        }
    }

    @Nullable
    private AssemblyRecipe getActiveAssemblyRecipe() {
        if (this.cachedRecipe != null) {
            return this.cachedRecipe;
        }
        if (this.f_58857_ == null) {
            return null;
        }
        ItemStack blueprintStack = this.itemHandler.getStackInSlot(2);
        if (blueprintStack.m_41619_() || !(blueprintStack.m_41720_() instanceof BlueprintItem)) {
            return null;
        }
        Item targetItem = BlueprintItem.getTargetItem(blueprintStack);
        if (targetItem == null) {
            return null;
        }
        List recipes = this.f_58857_.m_7465_().m_44013_((RecipeType)ModRecipes.ASSEMBLY_TYPE.get());
        for (AssemblyRecipe recipe : recipes) {
            if (recipe.m_8043_(this.f_58857_.m_9598_()).m_41720_() != targetItem) continue;
            this.cachedRecipe = recipe;
            return recipe;
        }
        return null;
    }

    private boolean isItemNeededForRecipe(AssemblyRecipe recipe, ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        for (AssemblyRecipe.SizedIngredient input : recipe.getInputs()) {
            if (!input.ingredient().test(stack)) continue;
            return true;
        }
        return false;
    }

    public float getRenderProgress(float pPartialTick) {
        return this.prevAnimationProgress + (this.animationProgress - this.prevAnimationProgress) * pPartialTick;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.cyber_ware_port.cyberware_workbench");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new CyberwareWorkbenchMenu(pContainerId, pPlayerInventory, this);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            if (side == Direction.DOWN) {
                return this.lazyOutputHandler.cast();
            }
            return this.lazyInputHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
        this.lazyInputHandler = LazyOptional.of(() -> this.automationInputHandler);
        this.lazyOutputHandler = LazyOptional.of(() -> this.automationOutputHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        this.lazyInputHandler.invalidate();
        this.lazyOutputHandler.invalidate();
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        pTag.m_128405_("workbench.progress", this.progress);
        pTag.m_128379_("workbench.isCrafting", this.isCrafting);
        pTag.m_128405_("workbench.cooldown", this.cooldown);
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
        this.progress = pTag.m_128451_("workbench.progress");
        this.isCrafting = pTag.m_128471_("workbench.isCrafting");
        this.cooldown = pTag.m_128451_("workbench.cooldown");
        this.cachedRecipe = null;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (pkt.m_131708_() != null) {
            this.m_142466_(pkt.m_131708_());
        }
    }
}

