/*
 * Decompiled with CFR 0.152.
 */
package com.maxwell.cyber_ware_port.common.entity;

import com.maxwell.cyber_ware_port.common.entity.ICyberwareMob;
import com.maxwell.cyber_ware_port.common.entity.monster.cybercreeper.CyberCreeperEntity;
import com.maxwell.cyber_ware_port.common.entity.monster.cyberwither.CyberWitherBoss;
import com.maxwell.cyber_ware_port.common.entity.monster.cyberwitherskeleton.CyberWitherSkeletonEntity;
import com.maxwell.cyber_ware_port.common.item.base.CyberwareItem;
import com.maxwell.cyber_ware_port.init.ModItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="cyber_ware_port")
public class EntitiesItemDropEvents {
    private static List<Item> CACHED_COMMON_POOL = null;
    private static List<Item> CACHED_HIGH_TIER_POOL = null;

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        int looting;
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof ICyberwareMob)) {
            return;
        }
        ICyberwareMob cyberMob = (ICyberwareMob)entity;
        if (CACHED_COMMON_POOL == null) {
            EntitiesItemDropEvents.initDropPools();
        }
        RandomSource random = entity.m_217043_();
        LivingEntity attacker = null;
        Entity entity2 = event.getSource().m_7639_();
        if (entity2 instanceof LivingEntity) {
            LivingEntity livingAttacker;
            attacker = livingAttacker = (LivingEntity)entity2;
        }
        int n = looting = attacker != null ? EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44982_, (LivingEntity)attacker) : 0;
        if (entity instanceof CyberWitherBoss) {
            EntitiesItemDropEvents.addScavengedDrop(event, (Item)ModItems.INTERNAL_DEFIBRILLATOR.get());
            List<Item> witherPool = EntitiesItemDropEvents.generateMobDropPool(cyberMob);
            witherPool.remove(ModItems.INTERNAL_DEFIBRILLATOR.get());
            if (!witherPool.isEmpty()) {
                int dropCount = 5 + random.m_188503_(4);
                for (int i = 0; i < dropCount; ++i) {
                    Item randomItem = witherPool.get(random.m_188503_(witherPool.size()));
                    EntitiesItemDropEvents.addScavengedDrop(event, randomItem);
                }
            }
            return;
        }
        List<Item> pool = EntitiesItemDropEvents.generateMobDropPool(cyberMob);
        if (pool.isEmpty()) {
            return;
        }
        float dropChance = 0.25f + (float)looting * 0.05f;
        if (random.m_188501_() < dropChance) {
            Item selectedItem = pool.get(random.m_188503_(pool.size()));
            EntitiesItemDropEvents.addScavengedDrop(event, selectedItem);
        }
        if (attacker != null && attacker.m_21205_().m_41720_() == ModItems.KATANA.get()) {
            float katanaChance = 0.5f + (float)looting * 0.1f;
            if (random.m_188501_() < katanaChance) {
                Item katanaDrop = pool.get(random.m_188503_(pool.size()));
                EntitiesItemDropEvents.addScavengedDrop(event, katanaDrop);
            }
        }
        if (entity instanceof CyberWitherSkeletonEntity && random.m_188501_() < 0.05f + (float)looting * 0.02f) {
            EntitiesItemDropEvents.addScavengedDrop(event, (Item)ModItems.CYBER_WITHER_SKELETON_SKULL_ITEM.get());
        }
    }

    private static List<Item> generateMobDropPool(ICyberwareMob cyberMob) {
        List<Item> forbiddenDrops;
        List<Item> specialDrops;
        ArrayList<Item> pool = new ArrayList<Item>();
        pool.addAll(CACHED_COMMON_POOL);
        if (cyberMob.isHighTierMob()) {
            pool.addAll(CACHED_HIGH_TIER_POOL);
        }
        if ((specialDrops = cyberMob.getSpecialDrops()) != null && !specialDrops.isEmpty()) {
            pool.addAll(specialDrops);
            pool.addAll(specialDrops);
        }
        if ((forbiddenDrops = cyberMob.getForbiddenDrops()) != null && !forbiddenDrops.isEmpty()) {
            pool.removeAll(forbiddenDrops);
        }
        return pool;
    }

    private static void addScavengedDrop(LivingDropsEvent event, Item item) {
        EntitiesItemDropEvents.addScavengedDrop(event, new ItemStack((ItemLike)item));
    }

    private static void addScavengedDrop(LivingDropsEvent event, ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof CyberwareItem) {
            CyberwareItem cw = (CyberwareItem)item;
            cw.setPristine(stack, false);
        }
        event.getDrops().add(new ItemEntity(event.getEntity().m_9236_(), event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), stack));
    }

    private static void initDropPools() {
        CACHED_COMMON_POOL = new ArrayList<Item>();
        CACHED_HIGH_TIER_POOL = new ArrayList<Item>();
        ArrayList<Item> highTierItems = new ArrayList<Item>();
        highTierItems.add((Item)ModItems.INTERNAL_DEFIBRILLATOR.get());
        highTierItems.add((Item)ModItems.RAPID_FIRE_FLYWHEEL.get());
        highTierItems.add((Item)ModItems.LINEAR_ACTUATORS.get());
        highTierItems.add((Item)ModItems.CONSCIOUSNESS_TRANSMITTER.get());
        highTierItems.add((Item)ModItems.STEM_CELL_SYNTHESIZER.get());
        for (RegistryObject entry : ModItems.ITEMS.getEntries()) {
            ResourceLocation id;
            Item item = (Item)entry.get();
            if (!(item instanceof CyberwareItem) || (id = ForgeRegistries.ITEMS.getKey((Object)item)) != null && id.m_135815_().contains("body_part") || item == ModItems.CREATIVE_BATTERY.get()) continue;
            if (highTierItems.contains(item)) {
                CACHED_HIGH_TIER_POOL.add(item);
                continue;
            }
            CACHED_COMMON_POOL.add(item);
        }
    }

    @SubscribeEvent
    public static void onExplosionStart(ExplosionEvent.Start event) {
        Entity entity = event.getExplosion().getExploder();
        if (entity instanceof CyberCreeperEntity) {
            CyberCreeperEntity creeper = (CyberCreeperEntity)entity;
            if (creeper.isCausingCustomExplosion()) {
                return;
            }
            event.setCanceled(true);
            Level level = event.getLevel();
            if (level.f_46443_) {
                return;
            }
            boolean mobGriefing = level.m_46469_().m_46207_(GameRules.f_46132_);
            Level.ExplosionInteraction interaction = mobGriefing ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE;
            creeper.setCausingCustomExplosion(true);
            float baseRadius = creeper.m_7090_() ? 6.0f : 3.0f;
            float finalRadius = baseRadius + 1.0f;
            long time = level.m_46468_() % 24000L;
            if (time >= 0L && time < 13000L) {
                finalRadius *= 1.5f;
            }
            level.m_255391_((Entity)creeper, creeper.m_20185_(), creeper.m_20186_(), creeper.m_20189_(), finalRadius, true, interaction);
            creeper.m_146870_();
        }
    }
}

