/*
 * Decompiled with CFR 0.152.
 */
package com.maxwell.cyber_ware_port.common.entity.monster.cyberwither;

import com.maxwell.cyber_ware_port.common.capability.CyberwareCapabilityProvider;
import com.maxwell.cyber_ware_port.common.entity.ICyberwareMob;
import com.maxwell.cyber_ware_port.common.entity.monster.cyberwitherskeleton.CyberWitherSkeletonEntity;
import com.maxwell.cyber_ware_port.init.ModEntities;
import com.maxwell.cyber_ware_port.init.ModItems;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CyberWitherBoss
extends Monster
implements PowerableMob,
RangedAttackMob,
ICyberwareMob {
    private static final EntityDataAccessor<Integer> DATA_TARGET_A = SynchedEntityData.m_135353_(CyberWitherBoss.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_TARGET_B = SynchedEntityData.m_135353_(CyberWitherBoss.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_TARGET_C = SynchedEntityData.m_135353_(CyberWitherBoss.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final List<EntityDataAccessor<Integer>> DATA_TARGETS = List.of(DATA_TARGET_A, DATA_TARGET_B, DATA_TARGET_C);
    private static final EntityDataAccessor<Integer> DATA_ID_INV = SynchedEntityData.m_135353_(CyberWitherBoss.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_MINION_1 = SynchedEntityData.m_135353_(CyberWitherBoss.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_MINION_2 = SynchedEntityData.m_135353_(CyberWitherBoss.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_MINION_3 = SynchedEntityData.m_135353_(CyberWitherBoss.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final Predicate<LivingEntity> LIVING_ENTITY_SELECTOR = entity -> entity.m_6336_() != MobType.f_21641_ && entity.m_5789_();
    private final float[] xRotHeads = new float[2];
    private final float[] yRotHeads = new float[2];
    private final float[] xRotOHeads = new float[2];
    private final float[] yRotOHeads = new float[2];
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true);
    private boolean hasSummonedMinions = false;
    private int shieldTimer = 0;
    private int empCooldown = 200;
    private boolean hasExplodedAtHalfHealth = false;

    public CyberWitherBoss(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, false);
        this.m_21153_(this.m_21233_());
        this.f_21364_ = 100;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 800.0).m_22268_(Attributes.f_22279_, 0.6).m_22268_(Attributes.f_22280_, 0.6).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22284_, 12.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    @Override
    public List<Item> getForbiddenDrops() {
        return Arrays.asList((Item)ModItems.CYBER_ARM_LEFT.get(), (Item)ModItems.CYBER_ARM_RIGHT.get(), (Item)ModItems.CYBER_LEG_LEFT.get(), (Item)ModItems.CYBER_LEG_RIGHT.get(), (Item)ModItems.RETRACTABLE_CLAWS.get(), (Item)ModItems.REINFORCED_FIST.get(), (Item)ModItems.FINE_MANIPULATORS.get(), (Item)ModItems.RAPID_FIRE_FLYWHEEL.get(), (Item)ModItems.LINEAR_ACTUATORS.get(), (Item)ModItems.FALL_BRACERS.get(), (Item)ModItems.AQUATIC_PROPULSION.get(), (Item)ModItems.DEPLOYABLE_WHEELS.get(), (Item)ModItems.IMPLANTED_SPURS.get());
    }

    @Override
    public boolean isHighTierMob() {
        return true;
    }

    protected PathNavigation m_6037_(Level pLevel) {
        FlyingPathNavigation nav = new FlyingPathNavigation((Mob)this, pLevel);
        nav.m_26440_(false);
        nav.m_7008_(true);
        nav.m_26443_(true);
        return nav;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new CyberWitherDoNothingGoal());
        this.f_21345_.m_25352_(2, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 40, 20.0f));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 0, false, false, LIVING_ENTITY_SELECTOR));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TARGET_A, (Object)0);
        this.f_19804_.m_135372_(DATA_TARGET_B, (Object)0);
        this.f_19804_.m_135372_(DATA_TARGET_C, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_INV, (Object)0);
        this.f_19804_.m_135372_(DATA_MINION_1, (Object)-1);
        this.f_19804_.m_135372_(DATA_MINION_2, (Object)-1);
        this.f_19804_.m_135372_(DATA_MINION_3, (Object)-1);
    }

    public void m_8107_() {
        Entity entity;
        Vec3 vec3 = this.m_20184_().m_82542_(1.0, 0.6, 1.0);
        if (!this.m_9236_().f_46443_ && this.getAlternativeTarget(0) > 0 && (entity = this.m_9236_().m_6815_(this.getAlternativeTarget(0))) != null) {
            double d0 = vec3.f_82480_;
            if (this.m_20186_() < entity.m_20186_() || !this.m_7090_() && this.m_20186_() < entity.m_20186_() + 2.0) {
                d0 = Math.max(0.0, d0);
                d0 += 0.3 - d0 * (double)0.6f;
            }
            vec3 = new Vec3(vec3.f_82479_, d0, vec3.f_82481_);
            Vec3 vec31 = new Vec3(entity.m_20185_() - this.m_20185_(), 0.0, entity.m_20189_() - this.m_20189_());
            if (vec31.m_165925_() > 9.0) {
                Vec3 vec32 = vec31.m_82541_();
                vec3 = vec3.m_82520_(vec32.f_82479_ * 0.3 - vec3.f_82479_ * 0.6, 0.0, vec32.f_82481_ * 0.3 - vec3.f_82481_ * 0.6);
            }
        }
        this.m_20256_(vec3);
        if (vec3.m_165925_() > 0.05) {
            this.m_146922_((float)Mth.m_14136_((double)vec3.f_82481_, (double)vec3.f_82479_) * 57.295776f - 90.0f);
        }
        super.m_8107_();
        for (int i = 0; i < 2; ++i) {
            this.yRotOHeads[i] = this.yRotHeads[i];
            this.xRotOHeads[i] = this.xRotHeads[i];
        }
        for (int j = 0; j < 2; ++j) {
            int k = this.getAlternativeTarget(j + 1);
            Entity entity1 = null;
            if (k > 0) {
                entity1 = this.m_9236_().m_6815_(k);
            }
            if (entity1 != null) {
                double d9 = this.getHeadX(j + 1);
                double d1 = this.getHeadY(j + 1);
                double d3 = this.getHeadZ(j + 1);
                double d4 = entity1.m_20185_() - d9;
                double d5 = entity1.m_20188_() - d1;
                double d6 = entity1.m_20189_() - d3;
                double d7 = Math.sqrt(d4 * d4 + d6 * d6);
                float f = (float)(Mth.m_14136_((double)d6, (double)d4) * 57.2957763671875) - 90.0f;
                float f1 = (float)(-(Mth.m_14136_((double)d5, (double)d7) * 57.2957763671875));
                this.xRotHeads[j] = this.m_21376_(this.xRotHeads[j], f1, 40.0f);
                this.yRotHeads[j] = this.m_21376_(this.yRotHeads[j], f, 10.0f);
                continue;
            }
            this.yRotHeads[j] = this.m_21376_(this.yRotHeads[j], this.f_20883_, 10.0f);
        }
        boolean flag = this.m_7090_();
        for (int l = 0; l < 3; ++l) {
            double d8 = this.getHeadX(l);
            double d10 = this.getHeadY(l);
            double d2 = this.getHeadZ(l);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, d8 + this.f_19796_.m_188583_() * 0.3, d10 + this.f_19796_.m_188583_() * 0.3, d2 + this.f_19796_.m_188583_() * 0.3, 0.0, 0.0, 0.0);
            if (!flag || this.m_9236_().f_46441_.m_188503_(4) != 0) continue;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, d8 + this.f_19796_.m_188583_() * 0.3, d10 + this.f_19796_.m_188583_() * 0.3, d2 + this.f_19796_.m_188583_() * 0.3, 0.7, 0.7, 0.5);
        }
        if (this.getInvulnerableTicks() > 0) {
            for (int i1 = 0; i1 < 3; ++i1) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() + this.f_19796_.m_188583_(), this.m_20186_() + (double)(this.f_19796_.m_188501_() * 3.3f), this.m_20189_() + this.f_19796_.m_188583_(), 0.7, 0.7, 0.9);
            }
        }
        if (!this.m_9236_().f_46443_) {
            this.m_8024_();
        }
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.getInvulnerableTicks() > 0) {
            int k1 = this.getInvulnerableTicks() - 1;
            this.bossEvent.m_142711_(1.0f - (float)k1 / 220.0f);
            if (k1 <= 0) {
                this.m_9236_().m_255391_((Entity)this, this.m_20185_(), this.m_20188_(), this.m_20189_(), 7.0f, false, Level.ExplosionInteraction.MOB);
                if (!this.m_20067_()) {
                    this.m_9236_().m_6798_(1023, this.m_20183_(), 0);
                }
            }
            this.setInvulnerableTicks(k1);
            if (this.f_19797_ % 10 == 0 && !this.hasExplodedAtHalfHealth) {
                this.m_5634_(10.0f);
            }
        } else {
            float maxHealth = this.m_21233_();
            float currentHealth = this.m_21223_();
            float halfHealth = maxHealth / 2.0f;
            if (!this.hasExplodedAtHalfHealth) {
                float phase1Progress = (currentHealth - halfHealth) / halfHealth;
                this.bossEvent.m_142711_(Mth.m_14036_((float)phase1Progress, (float)0.0f, (float)1.0f));
            } else {
                float phase2Progress = currentHealth / halfHealth;
                this.bossEvent.m_142711_(Mth.m_14036_((float)phase2Progress, (float)0.0f, (float)1.0f));
            }
            if (this.m_5448_() != null) {
                this.setAlternativeTarget(0, this.m_5448_().m_19879_());
            } else {
                this.setAlternativeTarget(0, 0);
            }
            if (!this.hasExplodedAtHalfHealth && currentHealth <= halfHealth) {
                this.hasExplodedAtHalfHealth = true;
                this.setInvulnerableTicks(220);
                return;
            }
            if (this.empCooldown > 0) {
                --this.empCooldown;
            } else {
                this.performEmpBlast();
                this.empCooldown = 300;
            }
            if (this.m_21223_() <= 150.0f && !this.hasSummonedMinions) {
                this.startPhaseTwo();
            }
            if (this.shieldTimer > 0) {
                --this.shieldTimer;
                if (this.shieldTimer < 1180) {
                    this.checkMinionStatus(DATA_MINION_1);
                    this.checkMinionStatus(DATA_MINION_2);
                    this.checkMinionStatus(DATA_MINION_3);
                    if (this.getMinionId(1) == -1 && this.getMinionId(2) == -1 && this.getMinionId(3) == -1) {
                        this.shieldTimer = 0;
                    }
                }
                if (this.shieldTimer == 0) {
                    this.endPhaseTwo();
                } else {
                    this.m_20334_(0.0, 0.0, 0.0);
                }
            }
        }
    }

    private void startPhaseTwo() {
        this.hasSummonedMinions = true;
        this.shieldTimer = 1200;
        this.spawnMinion(DATA_MINION_1, 3.0, 0.0);
        this.spawnMinion(DATA_MINION_2, -1.5, 2.6);
        this.spawnMinion(DATA_MINION_3, -1.5, -2.6);
        this.m_9236_().m_6798_(1023, this.m_20183_(), 0);
    }

    private void spawnMinion(EntityDataAccessor<Integer> dataAccessor, double offsetX, double offsetZ) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            CyberWitherSkeletonEntity minion = (CyberWitherSkeletonEntity)((EntityType)ModEntities.CYBER_WITHER_SKELETON.get()).m_20615_((Level)serverLevel);
            if (minion != null) {
                minion.m_7678_(this.m_20185_() + offsetX, this.m_20186_(), this.m_20189_() + offsetZ, this.m_146908_(), 0.0f);
                minion.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(this.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                if (this.m_5448_() != null) {
                    minion.m_6710_(this.m_5448_());
                }
                serverLevel.m_7967_((Entity)minion);
                this.f_19804_.m_135381_(dataAccessor, (Object)minion.m_19879_());
            }
        }
    }

    private void checkMinionStatus(EntityDataAccessor<Integer> accessor) {
        Entity entity;
        int id = (Integer)this.f_19804_.m_135370_(accessor);
        if (!(id == -1 || (entity = this.m_9236_().m_6815_(id)) != null && entity.m_6084_())) {
            this.f_19804_.m_135381_(accessor, (Object)-1);
        }
    }

    private void endPhaseTwo() {
        this.f_19804_.m_135381_(DATA_MINION_1, (Object)-1);
        this.f_19804_.m_135381_(DATA_MINION_2, (Object)-1);
        this.f_19804_.m_135381_(DATA_MINION_3, (Object)-1);
    }

    private void performEmpBlast() {
        if (!this.m_6084_()) {
            return;
        }
        List nearbyPlayers = this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82400_(20.0));
        boolean hitAny = false;
        for (Player player : nearbyPlayers) {
            if (!(player instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(data -> {
                int currentEnergy = data.getEnergyStored();
                if (currentEnergy > 0) {
                    data.extractEnergy(5000, false);
                    serverPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 0));
                    serverPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 0));
                    serverPlayer.m_213846_((Component)Component.m_237113_((String)"\u00a7cWARNING: EMP SURGE DETECTED - SYSTEMS OFFLINE"));
                }
            });
            hitAny = true;
        }
        if (hitAny) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, this.m_5720_(), 2.0f, 0.5f);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0, 0.0, 0.0);
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (pSource.m_269533_(DamageTypeTags.f_268738_)) {
            return super.m_6469_(pSource, pAmount);
        }
        if (this.getInvulnerableTicks() > 0) {
            return false;
        }
        if (this.shieldTimer > 0) {
            return false;
        }
        if (pSource.m_7639_() instanceof CyberWitherBoss) {
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    private double getHeadX(int pHead) {
        if (pHead <= 0) {
            return this.m_20185_();
        }
        float f = (this.f_20883_ + (float)(180 * (pHead - 1))) * ((float)Math.PI / 180);
        return this.m_20185_() + (double)Mth.m_14089_((float)f) * 1.3;
    }

    private double getHeadY(int pHead) {
        return pHead <= 0 ? this.m_20186_() + 3.0 : this.m_20186_() + 2.2;
    }

    private double getHeadZ(int pHead) {
        if (pHead <= 0) {
            return this.m_20189_();
        }
        float f = (this.f_20883_ + (float)(180 * (pHead - 1))) * ((float)Math.PI / 180);
        return this.m_20189_() + (double)Mth.m_14031_((float)f) * 1.3;
    }

    private float m_21376_(float pAngle, float pTarget, float pMax) {
        float f = Mth.m_14177_((float)(pTarget - pAngle));
        if (f > pMax) {
            f = pMax;
        }
        if (f < -pMax) {
            f = -pMax;
        }
        return pAngle + f;
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("Invul", this.getInvulnerableTicks());
        pCompound.m_128379_("PhaseTwoUsed", this.hasSummonedMinions);
        pCompound.m_128405_("ShieldTimer", this.shieldTimer);
        pCompound.m_128379_("HalfHealthExploded", this.hasExplodedAtHalfHealth);
    }

    public boolean m_20068_() {
        return true;
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setInvulnerableTicks(pCompound.m_128451_("Invul"));
        this.hasSummonedMinions = pCompound.m_128471_("PhaseTwoUsed");
        this.shieldTimer = pCompound.m_128451_("ShieldTimer");
        this.hasExplodedAtHalfHealth = pCompound.m_128471_("HalfHealthExploded");
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
    }

    public int getMinionId(int index) {
        return switch (index) {
            case 1 -> (Integer)this.f_19804_.m_135370_(DATA_MINION_1);
            case 2 -> (Integer)this.f_19804_.m_135370_(DATA_MINION_2);
            case 3 -> (Integer)this.f_19804_.m_135370_(DATA_MINION_3);
            default -> -1;
        };
    }

    public void m_6593_(@Nullable Component pName) {
        super.m_6593_(pName);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public void m_6457_(ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        this.bossEvent.m_6543_(pPlayer);
    }

    public void m_6452_(ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.bossEvent.m_6539_(pPlayer);
    }

    public void m_6504_(LivingEntity pTarget, float pVelocity) {
        this.performRangedAttack(0, pTarget);
    }

    private void performRangedAttack(int pHead, LivingEntity pTarget) {
        this.performRangedAttack(pHead, pTarget.m_20185_(), pTarget.m_20186_() + (double)pTarget.m_20192_() * 0.5, pTarget.m_20189_(), pHead == 0 && this.f_19796_.m_188501_() < 0.001f);
    }

    private void performRangedAttack(int pHead, double pX, double pY, double pZ, boolean pIsDangerous) {
        double headZ;
        double vecZ;
        double headY;
        double vecY;
        double headX;
        double vecX;
        double distance;
        if (!this.m_20067_()) {
            this.m_9236_().m_5898_(null, 1024, this.m_20183_(), 0);
        }
        if ((distance = Math.sqrt((vecX = pX - (headX = this.getHeadX(pHead))) * vecX + (vecY = pY - (headY = this.getHeadY(pHead))) * vecY + (vecZ = pZ - (headZ = this.getHeadZ(pHead))) * vecZ)) == 0.0) {
            distance = 1.0;
        }
        double offset = 1.5;
        double spawnX = headX + vecX / distance * offset;
        double spawnY = headY + vecY / distance * offset;
        double spawnZ = headZ + vecZ / distance * offset;
        WitherSkull witherskull = new WitherSkull(this.m_9236_(), (LivingEntity)this, vecX, vecY, vecZ);
        witherskull.m_5602_((Entity)this);
        if (pIsDangerous) {
            witherskull.m_37629_(true);
        }
        witherskull.m_20343_(spawnX, spawnY, spawnZ);
        this.m_9236_().m_7967_((Entity)witherskull);
    }

    public boolean m_7090_() {
        return this.m_21223_() <= this.m_21233_() / 2.0f;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public int getInvulnerableTicks() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_INV);
    }

    public void setInvulnerableTicks(int pInvulnerableTicks) {
        this.f_19804_.m_135381_(DATA_ID_INV, (Object)pInvulnerableTicks);
    }

    public int getAlternativeTarget(int pHead) {
        return (Integer)this.f_19804_.m_135370_(DATA_TARGETS.get(pHead));
    }

    public void setAlternativeTarget(int pTargetOffset, int pNewId) {
        this.f_19804_.m_135381_(DATA_TARGETS.get(pTargetOffset), (Object)pNewId);
    }

    public float getHeadYRot(int pHead) {
        return this.yRotHeads[pHead];
    }

    public float getHeadXRot(int pHead) {
        return this.xRotHeads[pHead];
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12554_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12557_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12556_;
    }

    public boolean m_6072_() {
        return false;
    }

    public void m_6043_() {
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL && this.m_8028_()) {
            this.m_146870_();
        } else {
            this.f_20891_ = 0;
        }
    }

    class CyberWitherDoNothingGoal
    extends Goal {
        public CyberWitherDoNothingGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return CyberWitherBoss.this.getInvulnerableTicks() > 0;
        }
    }
}

