/*
 * Decompiled with CFR 0.152.
 */
package com.maxwell.cyber_ware_port.common.item.componentbox;

import com.maxwell.cyber_ware_port.common.item.base.CyberwareItem;
import com.maxwell.cyber_ware_port.common.item.componentbox.ComponentBoxItem;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentBoxCapabilityProvider
implements ICapabilitySerializable<CompoundTag> {
    private final ItemStack stack;
    private final ItemStackHandler inventory = new ItemStackHandler(18){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return ComponentBoxCapabilityProvider.this.isComponent(stack);
        }

        protected void onContentsChanged(int slot) {
            CompoundTag tag = ComponentBoxCapabilityProvider.this.stack.m_41784_();
            tag.m_128365_("Inventory", (Tag)this.serializeNBT());
        }
    };
    private final LazyOptional<IItemHandler> optional = LazyOptional.of(() -> this.inventory);

    public ComponentBoxCapabilityProvider(ItemStack stack) {
        this.stack = stack;
        if (stack.m_41782_() && stack.m_41783_().m_128441_("Inventory")) {
            this.inventory.deserializeNBT(stack.m_41783_().m_128469_("Inventory"));
        }
    }

    private boolean isComponent(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof CyberwareItem) {
            return false;
        }
        if (item instanceof ComponentBoxItem) {
            return false;
        }
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)item);
        return id != null && id.m_135815_().contains("component_");
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.optional.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        return this.inventory.serializeNBT();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.inventory.deserializeNBT(nbt);
    }
}

