/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco.api;

import com.github.talrey.createdeco.BlockRegistry;
import com.github.talrey.createdeco.BlockStateGenerator;
import com.github.talrey.createdeco.api.CDTags;
import com.github.talrey.createdeco.blocks.CatwalkBlock;
import com.github.talrey.createdeco.blocks.CatwalkRailingBlock;
import com.github.talrey.createdeco.blocks.CatwalkStairBlock;
import com.github.talrey.createdeco.connected.CatwalkCTBehaviour;
import com.github.talrey.createdeco.connected.SpriteShifts;
import com.github.talrey.createdeco.items.CatwalkBlockItem;
import com.github.talrey.createdeco.items.CatwalkStairBlockItem;
import com.github.talrey.createdeco.items.RailingBlockItem;
import com.simibubi.create.AllTags;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class Catwalks {
    public static BlockBuilder<CatwalkBlock, ?> build(CreateRegistrate reg, String metal) {
        return (BlockBuilder)((BlockBuilder)reg.block(metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_catwalk", CatwalkBlock::new).properties(props -> props.m_60913_(5.0f, 6.0f).m_60999_().m_60955_().m_60918_(SoundType.f_56725_)).loot((table, block) -> {
            LootTable.Builder builder = LootTable.m_79147_();
            LootPool.Builder catwalksPool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f));
            LootPool.Builder supportPool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f));
            LootPoolSingletonContainer.Builder catwalks = LootItem.m_79579_((ItemLike)block);
            catwalks.m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f)));
            catwalksPool.m_79076_((LootPoolEntryContainer.Builder)catwalks);
            table.m_247577_((Block)block, builder.m_79161_(catwalksPool).m_79161_(supportPool));
        }).addLayer(() -> RenderType::m_110457_).tag(new TagKey[]{BlockTags.f_144282_}).tag(new TagKey[]{AllTags.AllBlockTags.FAN_TRANSPARENT.tag}).item(CatwalkBlockItem::new).properties(p -> metal.equals("Netherite") ? p.m_41486_() : p).model((ctx, prov) -> BlockStateGenerator.catwalkItem(metal, ctx, prov)).build()).blockstate((ctx, prov) -> BlockStateGenerator.catwalk(reg, metal, ctx, prov)).onRegister(CreateRegistrate.connectedTextures(new CatwalkCTBehaviour(SpriteShifts.CATWALK_TOPS.get(metal)).getSupplier()));
    }

    public static BlockBuilder<CatwalkStairBlock, ?> buildStair(CreateRegistrate reg, String metal) {
        String regName = metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_");
        String texture = reg.getModid() + ":block/palettes/catwalks/" + regName + "_catwalk";
        return (BlockBuilder)reg.block(metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_catwalk_stairs", p -> new CatwalkStairBlock((BlockBehaviour.Properties)p, metal)).properties(props -> props.m_60913_(5.0f, 6.0f).m_60999_().m_60955_().m_60918_(SoundType.f_56725_)).loot((table, block) -> {
            LootTable.Builder builder = LootTable.m_79147_();
            LootPool.Builder stairsPool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f));
            LootPool.Builder railingsPool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f));
            LootPoolSingletonContainer.Builder stairs = LootItem.m_79579_((ItemLike)block);
            stairs.m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f)));
            LootPoolSingletonContainer.Builder rails = LootItem.m_79579_((ItemLike)((ItemLike)BlockRegistry.CATWALK_RAILINGS.get(metal)));
            rails.m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)0.0f)));
            rails.m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165414_((NumberProvider)ConstantValue.m_165692_((float)1.0f), (boolean)true).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)CatwalkStairBlock.RAILING_LEFT, true))));
            rails.m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165414_((NumberProvider)ConstantValue.m_165692_((float)1.0f), (boolean)true).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)CatwalkStairBlock.RAILING_RIGHT, true))));
            railingsPool.m_79076_((LootPoolEntryContainer.Builder)rails);
            stairsPool.m_79076_((LootPoolEntryContainer.Builder)stairs);
            table.m_247577_((Block)block, builder.m_79161_(stairsPool).m_79161_(railingsPool));
        }).addLayer(() -> RenderType::m_110466_).tag(new TagKey[]{BlockTags.f_144282_}).tag(new TagKey[]{AllTags.AllBlockTags.FAN_TRANSPARENT.tag}).blockstate((ctx, prov) -> BlockStateGenerator.catwalkStair(texture, ctx, prov)).item(CatwalkStairBlockItem::new).build();
    }

    public static BlockBuilder<CatwalkRailingBlock, ?> buildRailing(CreateRegistrate reg, String metal) {
        String regName = metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_");
        String texture = reg.getModid() + ":block/palettes/catwalks/" + regName + "_catwalk";
        return (BlockBuilder)reg.block(metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_catwalk_railing", CatwalkRailingBlock::new).properties(props -> props.m_60913_(5.0f, 6.0f).m_60999_().m_60955_().m_60918_(SoundType.f_56725_)).addLayer(() -> RenderType::m_110466_).tag(new TagKey[]{BlockTags.f_144282_}).tag(new TagKey[]{AllTags.AllBlockTags.FAN_TRANSPARENT.tag}).blockstate((ctx, prov) -> BlockStateGenerator.catwalkRailing(reg, metal, ctx, prov)).recipe((ctx, prov) -> {}).loot((table, block) -> {
            LootTable.Builder builder = LootTable.m_79147_();
            LootPool.Builder pool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f));
            LootPoolSingletonContainer.Builder entry = LootItem.m_79579_((ItemLike)block);
            entry.m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)0.0f)));
            for (Direction dir : BlockStateProperties.f_61374_.m_6908_()) {
                entry.m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165414_((NumberProvider)ConstantValue.m_165692_((float)1.0f), (boolean)true).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)CatwalkRailingBlock.fromDirection(dir), true))));
            }
            pool.m_79076_((LootPoolEntryContainer.Builder)entry);
            table.m_247577_((Block)block, builder.m_79161_(pool));
        }).item(RailingBlockItem::new).build();
    }

    public static <T extends Block> void recipeStonecutting(Supplier<Item> ingot, DataGenContext<Block, T> ctx, RegistrateRecipeProvider prov, int count) {
        SingleItemRecipeBuilder.m_246944_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ingot.get()}), (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get()), (int)count).m_126132_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)ingot.get()}).m_45077_()})).m_176500_((Consumer)prov, ctx.getName() + "_from_stonecutting");
    }

    public static <T extends Block> void recipeStairs(String metal, ItemLike barItem, DataGenContext<Block, T> ctx, RegistrateRecipeProvider prov) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get()), (int)2).m_126130_(" c").m_126130_("cb").m_126127_(Character.valueOf('c'), (ItemLike)BlockRegistry.CATWALKS.get(metal).get()).m_126127_(Character.valueOf('b'), barItem).m_126132_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)BlockRegistry.CATWALKS.get(metal).get()})).m_176498_((Consumer)prov);
    }

    public static <T extends Block> void recipeCatwalk(String metal, ItemLike barItem, DataGenContext<Block, T> ctx, RegistrateRecipeProvider prov) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get()), (int)4).m_126130_(" p ").m_126130_("pBp").m_126130_(" p ").m_206416_(Character.valueOf('p'), CDTags.of((String)metal, (String)"plates").tag).m_126127_(Character.valueOf('B'), barItem).m_126132_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(CDTags.of((String)metal, (String)"plates").tag).m_45077_()})).m_176500_((Consumer)prov, ctx.getName() + "_forge");
    }

    public static <T extends Block> void recipeRailing(String metal, ItemLike barItem, DataGenContext<Block, T> ctx, RegistrateRecipeProvider prov) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get()), (int)8).m_126130_("ppp").m_126130_("B B").m_126130_("B B").m_206416_(Character.valueOf('p'), CDTags.of((String)metal, (String)"plates").tag).m_126127_(Character.valueOf('B'), barItem).m_126132_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(CDTags.of((String)metal, (String)"plates").tag).m_45077_()})).m_176500_((Consumer)prov, ctx.getName() + "_forge");
    }
}

