/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.text;

import com.tom.cpl.text.TextStyle;
import java.util.function.BiFunction;
import java.util.function.Function;

public class TextRemapper<C> {
    private BiFunction<String, Object[], C> translate;
    private Function<String, C> string;
    private BiFunction<C, C, C> combine;
    private Function<String, C> keyBind;
    private BiFunction<C, TextStyle, C> styling;

    public TextRemapper(BiFunction<String, Object[], C> translate, Function<String, C> string, BiFunction<C, C, C> combine, Function<String, C> keyBind, BiFunction<C, TextStyle, C> styling) {
        this.translate = translate;
        this.string = string;
        this.combine = combine;
        this.keyBind = keyBind;
        this.styling = styling;
    }

    public C translate(String t, Object[] u) {
        return this.translate.apply(t, u);
    }

    public C string(String t) {
        return this.string.apply(t);
    }

    public C combine(C t, C u) {
        return this.combine.apply(t, u);
    }

    public C keyBind(String t) {
        return this.keyBind.apply(t);
    }

    public boolean hasKeybind() {
        return this.keyBind != null;
    }

    public static TextRemapper<String> stringMapper(BiFunction<String, Object[], String> translate) {
        return new TextRemapper<String>(translate, Function.identity(), (a, b) -> a + b, null, TextRemapper::formattingCodeStyling);
    }

    private static String formattingCodeStyling(String in, TextStyle style) {
        StringBuilder sb = new StringBuilder("\u00a7r");
        if (style.bold) {
            sb.append("\u00a7l");
        }
        if (style.italic) {
            sb.append("\u00a7o");
        }
        if (style.underline) {
            sb.append("\u00a7n");
        }
        if (style.strikethrough) {
            sb.append("\u00a7m");
        }
        sb.append(in);
        return sb.toString();
    }

    public C styling(C to, TextStyle style) {
        if (this.styling != null) {
            return this.styling.apply(to, style);
        }
        return to;
    }
}

