/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.jei;

import io.redspace.ironsspellbooks.api.backwards_compat.FluidHelper;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.fluids.PotionFluid;
import io.redspace.ironsspellbooks.jei.AlchemistCauldronJeiRecipe;
import io.redspace.ironsspellbooks.jei.AlchemistCauldronRecipeCategory;
import io.redspace.ironsspellbooks.jei.AlchemistCauldronRecipeMaker;
import io.redspace.ironsspellbooks.recipe_types.alchemist_cauldron.EmptyAlchemistCauldronRecipe;
import io.redspace.ironsspellbooks.recipe_types.alchemist_cauldron.FillAlchemistCauldronRecipe;
import io.redspace.ironsspellbooks.registries.RecipeRegistry;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;

public class AlchemistCauldronAdvancedHandler
implements IRecipeManagerPlugin {
    public <V> List<RecipeType<?>> getRecipeTypes(IFocus<V> focus) {
        return List.of(AlchemistCauldronRecipeCategory.ALCHEMIST_CAULDRON_RECIPE_TYPE);
    }

    public <T, V> List<T> getRecipes(IRecipeCategory<T> recipeCategory, IFocus<V> focus) {
        if (!(recipeCategory instanceof AlchemistCauldronRecipeCategory)) {
            return List.of();
        }
        AlchemistCauldronRecipeCategory cauldronRecipeCategory = (AlchemistCauldronRecipeCategory)recipeCategory;
        ITypedIngredient ingredient = focus.getTypedValue();
        if (focus.getRole() == RecipeIngredientRole.INPUT) {
            if (this.isHandledInput(ingredient)) {
                return this.getRecipesForInput(ingredient);
            }
        } else if (focus.getRole() == RecipeIngredientRole.OUTPUT && this.isHandledOutput(ingredient)) {
            return this.getRecipesForOutput(ingredient);
        }
        return List.of();
    }

    public boolean isHandledInput(ITypedIngredient<?> input) {
        ItemStack stack = input.getIngredient((IIngredientType)VanillaTypes.ITEM_STACK).orElse(null);
        if (stack == null || Minecraft.m_91087_().f_91073_ == null) {
            return false;
        }
        if (((Boolean)ServerConfigs.ALLOW_CAULDRON_BREWING.get()).booleanValue() && FluidHelper.hasPotionContents(stack)) {
            return true;
        }
        RecipeManager m = Minecraft.m_91087_().f_91073_.m_7465_();
        return m.m_44013_((net.minecraft.world.item.crafting.RecipeType)RecipeRegistry.ALCHEMIST_CAULDRON_FILL_TYPE.get()).stream().anyMatch(empty -> empty.input().test(stack));
    }

    public boolean isHandledOutput(ITypedIngredient<?> output) {
        ItemStack stack = output.getIngredient((IIngredientType)VanillaTypes.ITEM_STACK).orElse(null);
        if (stack == null || Minecraft.m_91087_().f_91073_ == null) {
            return false;
        }
        if (((Boolean)ServerConfigs.ALLOW_CAULDRON_BREWING.get()).booleanValue() && FluidHelper.hasPotionContents(stack)) {
            return true;
        }
        RecipeManager m = Minecraft.m_91087_().f_91073_.m_7465_();
        return m.m_44013_((net.minecraft.world.item.crafting.RecipeType)RecipeRegistry.ALCHEMIST_CAULDRON_EMPTY_TYPE.get()).stream().anyMatch(empty -> ItemStack.m_150942_((ItemStack)stack, (ItemStack)empty.result()));
    }

    public List<AlchemistCauldronJeiRecipe> getRecipesForInput(ITypedIngredient<?> input) {
        Optional stackopt = input.getIngredient((IIngredientType)VanillaTypes.ITEM_STACK);
        if (stackopt.isEmpty() || Minecraft.m_91087_().f_91073_ == null) {
            return List.of();
        }
        ItemStack stack = (ItemStack)stackopt.get();
        RecipeManager manager = Minecraft.m_91087_().f_91073_.m_7465_();
        Optional<FluidStack> fluidConversion = manager.m_44015_((net.minecraft.world.item.crafting.RecipeType)RecipeRegistry.ALCHEMIST_CAULDRON_FILL_TYPE.get(), (Container)new SimpleContainer(new ItemStack[]{stack}), (Level)Minecraft.m_91087_().f_91073_).map(FillAlchemistCauldronRecipe::result);
        if (fluidConversion.isEmpty()) {
            fluidConversion = Optional.of(PotionFluid.from(stack));
        }
        return fluidConversion.map(inputFluid -> AlchemistCauldronRecipeMaker.recipes.stream().filter(recipe -> FluidHelper.isSameFluidSameComponents(recipe.fluidIn(), inputFluid)).toList()).orElse(List.of());
    }

    public List<AlchemistCauldronJeiRecipe> getRecipesForOutput(ITypedIngredient<?> output) {
        Optional stackopt = output.getIngredient((IIngredientType)VanillaTypes.ITEM_STACK);
        if (stackopt.isEmpty() || Minecraft.m_91087_().f_91073_ == null) {
            return List.of();
        }
        ItemStack stack = (ItemStack)stackopt.get();
        RecipeManager manager = Minecraft.m_91087_().f_91073_.m_7465_();
        Optional<FluidStack> fluidConversion = manager.m_44013_((net.minecraft.world.item.crafting.RecipeType)RecipeRegistry.ALCHEMIST_CAULDRON_EMPTY_TYPE.get()).stream().filter(emptyAlchemistCauldronRecipe -> ItemStack.m_150942_((ItemStack)emptyAlchemistCauldronRecipe.result(), (ItemStack)stack)).map(EmptyAlchemistCauldronRecipe::fluid).findFirst();
        if (fluidConversion.isEmpty() && ((Boolean)ServerConfigs.ALLOW_CAULDRON_BREWING.get()).booleanValue() && !PotionFluid.from(stack).isEmpty()) {
            fluidConversion = Optional.of(PotionFluid.from(stack));
        }
        return fluidConversion.map(outputFluid -> AlchemistCauldronRecipeMaker.recipes.stream().filter(recipe -> recipe.results().stream().anyMatch(result -> FluidHelper.isSameFluidSameComponents(result, outputFluid))).toList()).orElse(List.of());
    }

    public List<AlchemistCauldronJeiRecipe> getAllRecipes() {
        return AlchemistCauldronRecipeMaker.recipes;
    }

    public <T> List<T> getRecipes(IRecipeCategory<T> recipeCategory) {
        if (recipeCategory instanceof AlchemistCauldronRecipeCategory) {
            return this.getAllRecipes();
        }
        return List.of();
    }
}

