/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.network;

import io.redspace.ironsspellbooks.api.backwards_compat.CustomPacketPayload;
import io.redspace.ironsspellbooks.entity.mobs.IAnimatedAttacker;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class SyncAnimationPacket<T extends Entity>
implements CustomPacketPayload {
    int entityId;
    String animationId;

    public SyncAnimationPacket(String animationId, T entity) {
        this.entityId = entity.m_19879_();
        this.animationId = animationId;
    }

    public SyncAnimationPacket(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        this.animationId = buf.m_130277_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.m_130070_(this.animationId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level == null) {
                return;
            }
            Entity entity = level.m_6815_(this.entityId);
            if (entity instanceof IAnimatedAttacker) {
                IAnimatedAttacker animatedAttacker = (IAnimatedAttacker)entity;
                animatedAttacker.playAnimation(this.animationId);
            }
        });
        return true;
    }
}

