/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import io.redspace.ironsspellbooks.IronsSpellbooks;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class PocketDimensionEffects
extends DimensionSpecialEffects {
    public static final ResourceLocation SKY_LOCATION = IronsSpellbooks.id("textures/environment/pocket_dimension_sky.png");
    public static final ResourceLocation CLOUDS_LOCATION = IronsSpellbooks.id("textures/environment/pocket_clouds.png");
    public static final ResourceLocation WISP_LOCATION = IronsSpellbooks.id("textures/environment/single_cloud.png");
    public static final ResourceLocation NOISE = IronsSpellbooks.id("textures/environment/noise_tile.png");

    public PocketDimensionEffects() {
        super(Float.NaN, false, DimensionSpecialEffects.SkyType.NONE, false, false);
    }

    public Vec3 m_5927_(Vec3 fogColor, float brightness) {
        return fogColor;
    }

    public boolean m_5781_(int x, int y) {
        return false;
    }

    public boolean renderSky(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
        poseStack.m_85836_();
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        Tesselator tesselator = Tesselator.m_85913_();
        float skyDistance = 100.0f;
        PocketDimensionEffects.renderBox(poseStack, tesselator, skyDistance, 0.0f, 1.0f, GameRenderer::m_172820_, SKY_LOCATION, -12237499);
        float f = (float)ticks + partialTick;
        float scale = 0.8f;
        int layers = 6;
        Random random = new Random(431L);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        for (int i = 0; i < layers; ++i) {
            poseStack.m_85836_();
            int j = layers - i - 1;
            float speed = (0.01f + (float)(i * i) * 0.09f) * 0.015f;
            float x = ((float)(i * 68731) + f * speed * (random.nextFloat() - 0.5f)) % 360.0f;
            float y = ((float)(i * 74869) + f * speed * (random.nextFloat() - 0.5f)) % 360.0f;
            float z = ((float)(i * 98744) + f * speed * (random.nextFloat() - 0.5f)) % 360.0f;
            poseStack.m_252781_(Axis.f_252529_.m_252977_(x));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(y));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(z));
            Vector3f rgb = new Vector3f(random.nextFloat() * 0.5f + 0.5f, random.nextFloat() * 0.5f + 0.5f, random.nextFloat() * 0.5f + 0.5f);
            float intensity = Mth.m_14179_((float)((float)j / (float)layers), (float)0.25f, (float)0.8f);
            rgb.mul(intensity);
            rgb = new Vector3f(Math.min(rgb.x, 1.0f), Math.min(rgb.y, 1.0f), Math.min(rgb.z, 1.0f));
            RenderSystem.setShaderColor((float)rgb.x, (float)rgb.y, (float)rgb.z, (float)1.0f);
            PocketDimensionEffects.renderBox(poseStack, tesselator, skyDistance * scale, 0.0f, 4.0f + 2.0f * scale, GameRenderer::m_172820_, CLOUDS_LOCATION, -8355712);
            poseStack.m_85849_();
            scale -= 0.04f;
        }
        Vector3f color = new Vector3f(0.1f, 0.4f, 0.6f);
        color.mul(0.075f);
        float zoff = PocketDimensionEffects.renderNebula(poseStack, color, random, f, skyDistance, tesselator, scale, 0.0f);
        color = new Vector3f(0.6f, 0.1f, 0.5f);
        color.mul(0.125f);
        zoff = PocketDimensionEffects.renderNebula(poseStack, color, random, f, skyDistance, tesselator, scale, zoff);
        color = new Vector3f(0.3f, 0.3f, 0.3f);
        color.mul(0.125f);
        zoff = PocketDimensionEffects.renderNebula(poseStack, color, random, f, skyDistance, tesselator, scale, zoff);
        this.renderBorderAura(level, ticks, partialTick, poseStack, camera, projectionMatrix);
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
        return true;
    }

    public void renderBorderAura(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix) {
        poseStack.m_85836_();
        Quaternionf quaternionf = camera.m_253121_().conjugate(new Quaternionf());
        Vec3 cameraPos = camera.m_90583_();
        poseStack.m_252880_((float)(-cameraPos.f_82479_), (float)(-cameraPos.f_82480_), (float)(-cameraPos.f_82481_));
        int traversal = (int)(cameraPos.f_82481_ / 256.0) * 256;
        float HARDCODE_WIDTH = 7.0f;
        float halfWidth = HARDCODE_WIDTH / 2.0f;
        float HARDCODE_X = 4.0f + halfWidth;
        float HARDCODE_Y = 1.0f;
        float HARDCODE_Z = 4.0f + halfWidth + (float)traversal;
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        poseStack.m_252880_(HARDCODE_X, HARDCODE_Y, HARDCODE_Z);
        Tesselator tesselator = Tesselator.m_85913_();
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)NOISE);
        float uvScrollMin = ((float)ticks + partialTick) / 20.0f / 12.0f % 1.0f;
        float uvScrollMax = uvScrollMin + 0.020833334f;
        float uvTile = Mth.m_14143_((float)(HARDCODE_WIDTH / 3.0f));
        for (int i = 0; i < 4; ++i) {
            poseStack.m_85836_();
            poseStack.m_252781_(Axis.f_252436_.m_252977_((float)(i * 90)));
            Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            int baseColor = -6745686;
            bufferbuilder.m_252986_(matrix4f, -halfWidth, HARDCODE_Y - 1.0f, halfWidth).m_7421_(0.0f, uvScrollMax).m_193479_(baseColor).m_5752_();
            bufferbuilder.m_252986_(matrix4f, -halfWidth, HARDCODE_Y + 2.0f, halfWidth).m_7421_(0.0f, uvScrollMin).m_193479_(-16777216).m_5752_();
            bufferbuilder.m_252986_(matrix4f, halfWidth, HARDCODE_Y + 2.0f, halfWidth).m_7421_(uvTile, uvScrollMin).m_193479_(-16777216).m_5752_();
            bufferbuilder.m_252986_(matrix4f, halfWidth, HARDCODE_Y - 1.0f, halfWidth).m_7421_(uvTile, uvScrollMax).m_193479_(baseColor).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    private static float renderNebula(PoseStack poseStack, Vector3f color, Random random, float f, float skyDistance, Tesselator tesselator, float scale, float zoff) {
        RenderSystem.setShaderColor((float)color.x, (float)color.y, (float)color.z, (float)1.0f);
        int clouds = 15;
        for (int i = 0; i < clouds; ++i) {
            float clusterScale = 0.15f + (float)i * 0.003f;
            poseStack.m_85836_();
            int count = i + 1;
            float speed = 0.005f;
            float x = ((float)random.nextInt(360) + f * speed) % 360.0f;
            float y = ((float)random.nextInt(360) + f * speed) % 360.0f;
            float z = ((float)random.nextInt(360) + f * speed) % 360.0f;
            poseStack.m_252781_(Axis.f_252529_.m_252977_(x));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(y));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(z));
            for (int j = 0; j < count; ++j) {
                Vector3f offset = new Vector3f(random.nextFloat() - 0.5f, 0.0f, random.nextFloat() - 0.5f);
                offset.mul(skyDistance * 0.25f * (1.0f + (float)j * 0.025f));
                poseStack.m_85836_();
                poseStack.m_252880_(offset.x, zoff, offset.z);
                PocketDimensionEffects.renderPlane(poseStack, tesselator, skyDistance * scale, 0.0f, 1.0f, GameRenderer::m_172820_, WISP_LOCATION, clusterScale, -10461088);
                poseStack.m_85849_();
                zoff += 0.03f;
            }
            poseStack.m_85849_();
        }
        return zoff;
    }

    private static void renderBox(PoseStack poseStack, Tesselator tesselator, float skyDistance, float uvMin, float uvMax, Supplier<ShaderInstance> shaderSupplier, ResourceLocation texture, int color) {
        RenderSystem.setShader(shaderSupplier);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        for (int i = 0; i < 6; ++i) {
            poseStack.m_85836_();
            if (i == 1) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            }
            if (i == 2) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
            }
            if (i == 3) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            }
            if (i == 4) {
                poseStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
            }
            if (i == 5) {
                poseStack.m_252781_(Axis.f_252403_.m_252977_(-90.0f));
            }
            Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            bufferbuilder.m_252986_(matrix4f, -skyDistance, -skyDistance, -skyDistance).m_7421_(uvMin, uvMin).m_193479_(color).m_5752_();
            bufferbuilder.m_252986_(matrix4f, -skyDistance, -skyDistance, skyDistance).m_7421_(uvMin, uvMax).m_193479_(color).m_5752_();
            bufferbuilder.m_252986_(matrix4f, skyDistance, -skyDistance, skyDistance).m_7421_(uvMax, uvMax).m_193479_(color).m_5752_();
            bufferbuilder.m_252986_(matrix4f, skyDistance, -skyDistance, -skyDistance).m_7421_(uvMax, uvMin).m_193479_(color).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            poseStack.m_85849_();
        }
    }

    private static void renderPlane(PoseStack poseStack, Tesselator tesselator, float skyDistance, float uvMin, float uvMax, Supplier<ShaderInstance> shaderSupplier, ResourceLocation texture, float scale, int color) {
        RenderSystem.setShader(shaderSupplier);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        poseStack.m_85836_();
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferbuilder.m_252986_(matrix4f, -skyDistance * scale, -skyDistance, -skyDistance * scale).m_7421_(uvMin, uvMin).m_193479_(color).m_5752_();
        bufferbuilder.m_252986_(matrix4f, -skyDistance * scale, -skyDistance, skyDistance * scale).m_7421_(uvMin, uvMax).m_193479_(color).m_5752_();
        bufferbuilder.m_252986_(matrix4f, skyDistance * scale, -skyDistance, skyDistance * scale).m_7421_(uvMax, uvMax).m_193479_(color).m_5752_();
        bufferbuilder.m_252986_(matrix4f, skyDistance * scale, -skyDistance, -skyDistance * scale).m_7421_(uvMax, uvMin).m_193479_(color).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        poseStack.m_85849_();
    }
}

