/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.resource;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.Nullable;

public abstract class RegistryAwareJsonReloadListener
extends SimpleJsonResourceReloadListener {
    private static final List<RegistryAwareJsonReloadListener> INSTANCES = Collections.synchronizedList(new ArrayList());
    @Nullable
    private Map<ResourceLocation, JsonElement> resources;
    @Nullable
    private ResourceManager manager;
    @Nullable
    private ProfilerFiller profiler;

    public RegistryAwareJsonReloadListener(Gson gson, String directory) {
        super(gson, directory);
        INSTANCES.add(this);
    }

    protected void apply(Map<ResourceLocation, JsonElement> resources, ResourceManager manager, ProfilerFiller profiler) {
        this.resources = resources;
        this.manager = manager;
        this.profiler = profiler;
    }

    public abstract void parse(Map<ResourceLocation, JsonElement> var1, RegistryAccess var2, ResourceManager var3, ProfilerFiller var4);

    public static void runReloads(RegistryAccess access) {
        for (RegistryAwareJsonReloadListener listener : INSTANCES) {
            if (listener.resources == null || listener.manager == null || listener.profiler == null) continue;
            listener.parse(listener.resources, access, listener.manager, listener.profiler);
            listener.resources = null;
            listener.manager = null;
            listener.profiler = null;
        }
    }
}

