/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.model;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.supermartijn642.rechiseled.model.RechiseledBakedModel;
import com.supermartijn642.rechiseled.model.RechiseledConnectedBakedModel;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import org.joml.Matrix4f;

@Deprecated
public class RechiseledModel
implements IUnbakedGeometry<RechiseledModel> {
    private final boolean shouldConnect;
    private final ResourceLocation parent;
    private final List<BlockElement> elements;
    private final Map<String, Either<Pair<Material, Boolean>, String>> textureMap;
    private final boolean ambientOcclusion;
    private final BlockModel.GuiLight guiLight;
    private final ItemTransforms cameraTransforms;
    private final List<ItemOverride> itemOverrides;
    private final ResourceLocation renderTypeHint;

    public RechiseledModel(boolean shouldConnect, ResourceLocation parent, List<BlockElement> elements, Map<String, Either<Pair<Material, Boolean>, String>> textureMap, boolean ambientOcclusion, BlockModel.GuiLight guiLight, ItemTransforms cameraTransforms, List<ItemOverride> itemOverrides, ResourceLocation renderTypeHint) {
        this.shouldConnect = shouldConnect;
        this.parent = parent;
        this.elements = elements;
        this.textureMap = textureMap;
        this.ambientOcclusion = ambientOcclusion;
        this.guiLight = guiLight;
        this.cameraTransforms = cameraTransforms;
        this.itemOverrides = itemOverrides;
        this.renderTypeHint = renderTypeHint;
    }

    public BakedModel bake(IGeometryBakingContext owner, ModelBaker bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        Function<ResourceLocation, UnbakedModel> modelGetter = arg_0 -> ((ModelBaker)bakery).m_245361_(arg_0);
        TextureAtlasSprite particle = spriteGetter.apply((Material)this.getTexture("particle", modelGetter).getFirst());
        List<BlockElement> elements = this.getElements(modelGetter);
        ItemTransforms transforms = this.getTransforms(modelGetter);
        ResourceLocation renderTypeHint = this.getRenderTypeHint(modelGetter);
        RenderTypeGroup renderTypes = renderTypeHint == null ? RenderTypeGroup.EMPTY : owner.getRenderType(renderTypeHint);
        EnumMap quads = Maps.newEnumMap(Direction.class);
        for (BlockElement part : elements) {
            for (Direction direction : part.f_111310_.keySet()) {
                BlockElementFace face = (BlockElementFace)part.f_111310_.get(direction);
                Pair<Material, Boolean> texture = this.getTexture(face.f_111356_, modelGetter);
                TextureAtlasSprite sprite = spriteGetter.apply((Material)texture.getFirst());
                boolean connecting = (Boolean)texture.getSecond();
                BakedQuad quad = BlockModel.m_111437_((BlockElement)part, (BlockElementFace)face, (TextureAtlasSprite)sprite, (Direction)direction, (ModelState)modelTransform, (ResourceLocation)modelLocation);
                Direction cullFace = face.f_111354_ == null ? null : Direction.m_252919_((Matrix4f)modelTransform.m_6189_().m_252783_(), (Direction)face.f_111354_);
                quads.putIfAbsent(cullFace, new ArrayList());
                ((List)quads.get(cullFace)).add(new Tuple((Object)quad, (Object)connecting));
            }
        }
        return this.shouldConnect ? new RechiseledConnectedBakedModel(quads, owner.useAmbientOcclusion(), owner.isGui3d(), owner.useBlockLight(), false, particle, overrides, transforms, renderTypes) : new RechiseledBakedModel(quads, owner.useAmbientOcclusion(), owner.isGui3d(), owner.useBlockLight(), false, particle, overrides, transforms, renderTypes);
    }

    private Pair<Material, Boolean> getTexture(String texture, Function<ResourceLocation, UnbakedModel> modelGetter) {
        if (texture.charAt(0) == '#') {
            texture = texture.substring(1);
        }
        ArrayList list = Lists.newArrayList();
        Either<Pair<Material, Boolean>, String> either;
        Optional optional;
        while (!(optional = (either = this.findTextureEntry(texture, modelGetter)).left()).isPresent()) {
            texture = (String)either.right().get();
            if (list.contains(texture)) {
                System.err.printf("Unable to resolve texture due to reference chain %s->%s%n", Joiner.on((String)"->").join((Iterable)list), texture);
                return Pair.of((Object)new Material(TextureAtlas.f_118259_, MissingTextureAtlasSprite.m_118071_()), (Object)false);
            }
            list.add(texture);
        }
        return (Pair)optional.get();
    }

    private Either<Pair<Material, Boolean>, String> findTextureEntry(String texture, Function<ResourceLocation, UnbakedModel> modelGetter) {
        UnbakedModel parent;
        if (this.textureMap.containsKey(texture)) {
            return this.textureMap.get(texture);
        }
        UnbakedModel unbakedModel = parent = this.parent == null ? null : modelGetter.apply(this.parent);
        if (parent instanceof BlockModel) {
            if (((BlockModel)parent).customData.hasCustomGeometry() && ((BlockModel)parent).customData.getCustomGeometry() instanceof RechiseledModel) {
                return ((RechiseledModel)((BlockModel)parent).customData.getCustomGeometry()).findTextureEntry(texture, modelGetter);
            }
            BlockModel blockmodel = (BlockModel)parent;
            while (blockmodel != null) {
                Either either = (Either)blockmodel.f_111417_.get(texture);
                if (either != null) {
                    return either.mapLeft(material -> Pair.of((Object)material, (Object)false));
                }
                blockmodel = blockmodel.f_111418_;
            }
        }
        return Either.left((Object)Pair.of((Object)new Material(TextureAtlas.f_118259_, MissingTextureAtlasSprite.m_118071_()), (Object)false));
    }

    private List<BlockElement> getElements(Function<ResourceLocation, UnbakedModel> modelGetter) {
        List<BlockElement> elements = this.elements;
        if (this.elements.isEmpty()) {
            UnbakedModel parent;
            UnbakedModel unbakedModel = parent = this.parent == null ? null : modelGetter.apply(this.parent);
            if (parent instanceof BlockModel) {
                elements = ((BlockModel)parent).customData.hasCustomGeometry() && ((BlockModel)parent).customData.getCustomGeometry() instanceof RechiseledModel ? ((RechiseledModel)((BlockModel)parent).customData.getCustomGeometry()).getElements(modelGetter) : ((BlockModel)parent).m_111436_();
            }
        }
        return elements;
    }

    public ItemTransforms getTransforms(Function<ResourceLocation, UnbakedModel> modelGetter) {
        ItemTransform thirdPersonLeftHand = this.getTransform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND, modelGetter);
        ItemTransform thirdPersonRightHand = this.getTransform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, modelGetter);
        ItemTransform firstPersonLeftHand = this.getTransform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND, modelGetter);
        ItemTransform firstPersonRightHand = this.getTransform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND, modelGetter);
        ItemTransform head = this.getTransform(ItemDisplayContext.HEAD, modelGetter);
        ItemTransform gui = this.getTransform(ItemDisplayContext.GUI, modelGetter);
        ItemTransform ground = this.getTransform(ItemDisplayContext.GROUND, modelGetter);
        ItemTransform fixed = this.getTransform(ItemDisplayContext.FIXED, modelGetter);
        return new ItemTransforms(thirdPersonLeftHand, thirdPersonRightHand, firstPersonLeftHand, firstPersonRightHand, head, gui, ground, fixed);
    }

    private ItemTransform getTransform(ItemDisplayContext transformType, Function<ResourceLocation, UnbakedModel> modelGetter) {
        UnbakedModel parent;
        if (this.cameraTransforms.m_269504_(transformType)) {
            return this.cameraTransforms.m_269404_(transformType);
        }
        UnbakedModel unbakedModel = parent = this.parent == null ? null : modelGetter.apply(this.parent);
        if (parent instanceof BlockModel) {
            if (((BlockModel)parent).customData.hasCustomGeometry() && ((BlockModel)parent).customData.getCustomGeometry() instanceof RechiseledModel) {
                return ((RechiseledModel)((BlockModel)parent).customData.getCustomGeometry()).getTransform(transformType, modelGetter);
            }
            return ((BlockModel)parent).m_111491_().m_269404_(transformType);
        }
        return this.cameraTransforms.m_269404_(transformType);
    }

    private ResourceLocation getRenderTypeHint(Function<ResourceLocation, UnbakedModel> modelGetter) {
        ResourceLocation renderTypeHint = this.renderTypeHint;
        if (this.renderTypeHint == null) {
            UnbakedModel parent;
            UnbakedModel unbakedModel = parent = this.parent == null ? null : modelGetter.apply(this.parent);
            if (parent instanceof BlockModel) {
                renderTypeHint = ((BlockModel)parent).customData.hasCustomGeometry() && ((BlockModel)parent).customData.getCustomGeometry() instanceof RechiseledModel ? ((RechiseledModel)((BlockModel)parent).customData.getCustomGeometry()).getRenderTypeHint(modelGetter) : ((BlockModel)parent).customData.getRenderTypeHint();
            }
        }
        return renderTypeHint;
    }
}

