/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.entity.projectile;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import ttv.migami.jeg.Config;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.common.network.ServerPlayHandler;
import ttv.migami.jeg.entity.projectile.ProjectileEntity;
import ttv.migami.jeg.event.GunProjectileHitEvent;
import ttv.migami.jeg.init.ModEnchantments;
import ttv.migami.jeg.item.GunItem;

public class ArrowProjectileEntity
extends ProjectileEntity {
    private static final Predicate<BlockState> IGNORE_LEAVES = input -> input != null && (Boolean)Config.COMMON.gameplay.ignoreLeaves.get() != false && input.m_60734_() instanceof LeavesBlock;
    private boolean flaming = false;
    private boolean charged = false;

    public ArrowProjectileEntity(EntityType<? extends ProjectileEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public ArrowProjectileEntity(EntityType<? extends ProjectileEntity> entityType, Level worldIn, LivingEntity shooter, ItemStack stack, GunItem item, Gun modifiedGun) {
        super(entityType, worldIn, shooter, stack, item, modifiedGun);
        if (stack.getEnchantmentLevel(Enchantments.f_44990_) != 0 || stack.getEnchantmentLevel((Enchantment)ModEnchantments.FIRE_STARTER.get()) != 0) {
            this.flaming = true;
        }
        if (this.chargeProgress == 1.0f) {
            this.charged = true;
        }
    }

    @Override
    protected void onProjectileTick() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.f_19797_ > 1 && this.f_19797_ < this.life) {
                SimpleParticleType lava = ParticleTypes.f_123756_;
                if (this.flaming) {
                    for (int i = 0; i < 3; ++i) {
                        ServerPlayHandler.sendParticlesToAll(serverLevel, lava, true, this.m_20185_() - this.m_20184_().m_7096_(), this.m_20186_() - this.m_20184_().m_7098_(), this.m_20189_() - this.m_20184_().m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                    ServerPlayHandler.sendParticlesToAll(serverLevel, ParticleTypes.f_123783_, true, this.m_20185_() - this.m_20184_().m_7096_(), this.m_20186_() - this.m_20184_().m_7098_(), this.m_20189_() - this.m_20184_().m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
                    ServerPlayHandler.sendParticlesToAll(serverLevel, ParticleTypes.f_123790_, true, this.m_20185_() - this.m_20184_().m_7096_(), this.m_20186_() - this.m_20184_().m_7098_(), this.m_20189_() - this.m_20184_().m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
                }
                if (this.charged) {
                    ServerPlayHandler.sendParticlesToAll(serverLevel, ParticleTypes.f_123797_, true, this.m_20185_() - this.m_20184_().m_7096_(), this.m_20186_() - this.m_20184_().m_7098_(), this.m_20189_() - this.m_20184_().m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
                }
                if (this.m_5842_()) {
                    ServerPlayHandler.sendParticlesToAll(serverLevel, ParticleTypes.f_123795_, true, this.m_20185_() - this.m_20184_().m_7096_(), this.m_20186_() - this.m_20184_().m_7098_(), this.m_20189_() - this.m_20184_().m_7094_(), 2, 0.1, 0.1, 0.1, 0.0);
                }
            }
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            Vec3 startVec = this.m_20182_();
            Vec3 endVec = startVec.m_82549_(this.m_20184_());
            BlockHitResult result = ArrowProjectileEntity.rayTraceBlocks(this.m_9236_(), new ClipContext(startVec, endVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this), IGNORE_LEAVES);
            this.onHit((HitResult)result, startVec, endVec);
        }
    }

    @Override
    protected void onHitEntity(Entity entity, Vec3 hitVec, Vec3 startVec, Vec3 endVec, boolean headshot) {
        super.onHitEntity(entity, hitVec, startVec, endVec, headshot);
        if (this.flaming) {
            entity.m_20254_(5);
        }
    }

    private void onHit(HitResult result, Vec3 startVec, Vec3 endVec) {
        if (MinecraftForge.EVENT_BUS.post((Event)new GunProjectileHitEvent(result, this))) {
            return;
        }
        if (result instanceof BlockHitResult && this.flaming) {
            BlockHitResult blockRayTraceResult = (BlockHitResult)result;
            if (blockRayTraceResult.m_6662_() == HitResult.Type.MISS) {
                return;
            }
            Vec3 hitVec = result.m_82450_();
            BlockPos pos = blockRayTraceResult.m_82425_();
            if (((Boolean)Config.COMMON.gameplay.griefing.setFireToBlocks.get()).booleanValue()) {
                BlockPos offsetPos = pos.m_121945_(blockRayTraceResult.m_82434_());
                if (BaseFireBlock.m_49255_((Level)this.m_9236_(), (BlockPos)offsetPos, (Direction)blockRayTraceResult.m_82434_())) {
                    BlockState fireState = BaseFireBlock.m_49245_((BlockGetter)this.m_9236_(), (BlockPos)offsetPos);
                    this.m_9236_().m_7731_(offsetPos, fireState, 11);
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123756_, hitVec.f_82479_ - 1.0 + this.f_19796_.m_188500_() * 2.0, hitVec.f_82480_, hitVec.f_82481_ - 1.0 + this.f_19796_.m_188500_() * 2.0, 4, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

