/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.resourceproduction.tile;

import com.buuz135.industrial.block.tile.IndustrialProcessingTile;
import com.buuz135.industrial.config.machine.resourceproduction.MaterialStoneWorkFactoryConfig;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.buuz135.industrial.recipe.StoneWorkGenerateRecipe;
import com.buuz135.industrial.utils.CraftingUtils;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.BasicButtonAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.recipe.serializer.SerializableRecipe;
import com.hrznstudio.titanium.util.AssetUtil;
import com.hrznstudio.titanium.util.LangUtil;
import com.hrznstudio.titanium.util.RecipeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class MaterialStoneWorkFactoryTile
extends IndustrialProcessingTile<MaterialStoneWorkFactoryTile> {
    public static ResourceLocation DEFAULT = new ResourceLocation("industrialforegoing", "stonework_generate/cobblestone");
    private int maxProgress;
    private int powerPerOperation;
    public static StoneWorkAction[] ACTION_RECIPES = new StoneWorkAction[]{new StoneWorkAction(new ItemStack((ItemLike)Blocks.f_50094_), (world1, itemStack) -> {
        SmeltingRecipe recipe = RecipeUtil.getSmelingRecipeFor((Level)world1, (ItemStack)itemStack);
        if (recipe != null) {
            return recipe.m_8043_(world1.m_9598_());
        }
        return ItemStack.f_41583_;
    }, 1, "smelt"), new StoneWorkAction(new ItemStack((ItemLike)Items.f_42390_), CraftingUtils::getCrushOutput, 1, "crush"), new StoneWorkAction(new ItemStack((ItemLike)Blocks.f_50705_), (world1, stack) -> CraftingUtils.findOutput(2, stack, world1), 4, "small_craft"), new StoneWorkAction(new ItemStack((ItemLike)Blocks.f_50091_), (world1, stack) -> CraftingUtils.findOutput(3, stack, world1), 9, "big_craft"), new StoneWorkAction(new ItemStack((ItemLike)Blocks.f_50375_), (world1, stack) -> ItemStack.f_41583_, 0, "none")};
    @Save
    private SidedFluidTankComponent<MaterialStoneWorkFactoryTile> water = (SidedFluidTankComponent)new SidedFluidTankComponent("water", MaterialStoneWorkFactoryConfig.maxWaterTankSize, 30, 23, 0).setColor(DyeColor.BLUE).setTankType(FluidTankComponent.Type.SMALL).setTankAction(FluidTankComponent.Action.FILL).setComponentHarness((IComponentHarness)this).setValidator(fluidStack -> fluidStack.getFluid().m_6212_((Fluid)Fluids.f_76193_));
    @Save
    private SidedFluidTankComponent<MaterialStoneWorkFactoryTile> lava;
    @Save
    private SidedInventoryComponent<MaterialStoneWorkFactoryTile> inventoryGenerator;
    @Save
    private String generatorRecipe;
    @Save
    private SidedInventoryComponent<MaterialStoneWorkFactoryTile> inventoryFirst;
    @Save
    private int firstRecipeId;
    @Save
    private SidedInventoryComponent<MaterialStoneWorkFactoryTile> inventorySecond;
    @Save
    private int secondRecipeId;
    @Save
    private SidedInventoryComponent<MaterialStoneWorkFactoryTile> inventoryThird;
    @Save
    private int thirdRecipeId;
    @Save
    private SidedInventoryComponent<MaterialStoneWorkFactoryTile> inventoryFourth;
    @Save
    private int fourthRecipeId;

    public MaterialStoneWorkFactoryTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleResourceProduction.MATERIAL_STONEWORK_FACTORY, 48, 40, blockPos, blockState);
        this.addTank(this.water);
        this.lava = (SidedFluidTankComponent)new SidedFluidTankComponent("lava", MaterialStoneWorkFactoryConfig.maxLavaTankSize, 30, 55, 1).setColor(DyeColor.ORANGE).setTankType(FluidTankComponent.Type.SMALL).setTankAction(FluidTankComponent.Action.FILL).setComponentHarness((IComponentHarness)this).setValidator(fluidStack -> fluidStack.getFluid().m_6212_((Fluid)Fluids.f_76195_));
        this.addTank(this.lava);
        this.generatorRecipe = DEFAULT.toString();
        this.addButton(new ButtonComponent(54, 64, 18, 18){

            @OnlyIn(value=Dist.CLIENT)
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new BasicButtonAddon(this){

                    public void drawBackgroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
                        MaterialStoneWorkFactoryTile.this.getRecipe().ifPresent(recipe -> {
                            AssetUtil.drawAsset((GuiGraphics)guiGraphics, (Screen)screen, (IAsset)provider.getAsset(AssetTypes.ITEM_BACKGROUND), (int)(guiX + this.getPosX()), (int)(guiY + this.getPosY()));
                            guiGraphics.m_280480_(recipe.output, guiX + this.getPosX() + 1, guiY + this.getPosY() + 1);
                        });
                    }

                    public List<Component> getTooltipLines() {
                        ArrayList<Component> lines = new ArrayList<Component>();
                        MaterialStoneWorkFactoryTile.this.getRecipe().ifPresent(recipe -> {
                            lines.add((Component)Component.m_237113_((String)(ChatFormatting.GOLD + LangUtil.getString((String)"tooltip.industrialforegoing.generating", (Object[])new Object[0]) + ChatFormatting.WHITE + recipe.output.m_41786_().getString())));
                            lines.add((Component)Component.m_237113_((String)(ChatFormatting.GOLD + LangUtil.getString((String)"tooltip.industrialforegoing.needs", (Object[])new Object[0]))));
                            lines.add((Component)Component.m_237113_((String)(ChatFormatting.YELLOW + " - " + ChatFormatting.WHITE + recipe.waterNeed + ChatFormatting.DARK_AQUA + LangUtil.getString((String)"tooltip.industrialforegoing.mb_of", (Object[])new Object[]{LangUtil.getString((String)"block.minecraft.water", (Object[])new Object[0])}))));
                            lines.add((Component)Component.m_237113_((String)(ChatFormatting.YELLOW + " - " + ChatFormatting.WHITE + recipe.lavaNeed + ChatFormatting.DARK_AQUA + LangUtil.getString((String)"tooltip.industrialforegoing.mb_of", (Object[])new Object[]{LangUtil.getString((String)"block.minecraft.lava", (Object[])new Object[0])}))));
                            lines.add((Component)Component.m_237113_((String)(ChatFormatting.GOLD + LangUtil.getString((String)"tooltip.industrialforegoing.consumes", (Object[])new Object[0]))));
                            lines.add((Component)Component.m_237113_((String)(ChatFormatting.YELLOW + " - " + ChatFormatting.WHITE + recipe.waterConsume + ChatFormatting.DARK_AQUA + LangUtil.getString((String)"tooltip.industrialforegoing.mb_of", (Object[])new Object[]{LangUtil.getString((String)"block.minecraft.water", (Object[])new Object[0])}))));
                            lines.add((Component)Component.m_237113_((String)(ChatFormatting.YELLOW + " - " + ChatFormatting.WHITE + recipe.lavaConsume + ChatFormatting.DARK_AQUA + LangUtil.getString((String)"tooltip.industrialforegoing.mb_of", (Object[])new Object[]{LangUtil.getString((String)"block.minecraft.lava", (Object[])new Object[0])}))));
                        });
                        return lines;
                    }
                });
            }
        }.setPredicate((playerEntity, compoundNBT) -> {
            int button = 0;
            if (compoundNBT.m_128441_("Button")) {
                button = compoundNBT.m_128451_("Button");
            }
            this.getNextRecipe(button == 0);
            this.markForUpdate();
        }));
        this.inventoryGenerator = (SidedInventoryComponent)new SidedInventoryComponent("inventoryGenerator", 74, 23, 2, 2).setColor(DyeColor.LIME).setSlotPosition(integer -> integer == 0 ? Pair.of((Object)0, (Object)0) : Pair.of((Object)0, (Object)18)).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.inventoryGenerator);
        this.inventoryFirst = (SidedInventoryComponent)new SidedInventoryComponent("inventoryFirst", 94, 23, 2, 3).setColor(DyeColor.CYAN).setSlotPosition(integer -> integer == 0 ? Pair.of((Object)0, (Object)0) : Pair.of((Object)0, (Object)18)).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.inventoryFirst);
        this.inventorySecond = (SidedInventoryComponent)new SidedInventoryComponent("inventorySecond", 114, 23, 2, 4).setColor(DyeColor.YELLOW).setSlotPosition(integer -> integer == 0 ? Pair.of((Object)0, (Object)0) : Pair.of((Object)0, (Object)18)).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.inventorySecond);
        this.inventoryThird = (SidedInventoryComponent)new SidedInventoryComponent("inventoryThird", 134, 23, 2, 5).setColor(DyeColor.RED).setSlotPosition(integer -> integer == 0 ? Pair.of((Object)0, (Object)0) : Pair.of((Object)0, (Object)18)).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.inventoryThird);
        this.inventoryFourth = (SidedInventoryComponent)new SidedInventoryComponent("inventoryFour", 154, 23, 2, 6).setColor(DyeColor.GREEN).setSlotPosition(integer -> integer == 0 ? Pair.of((Object)0, (Object)0) : Pair.of((Object)0, (Object)18)).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.inventoryFourth);
        this.firstRecipeId = 0;
        this.secondRecipeId = 0;
        this.thirdRecipeId = 0;
        this.fourthRecipeId = 0;
        this.addButton(new ButtonComponent(82, 64, 18, 18){

            @OnlyIn(value=Dist.CLIENT)
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new BasicButtonAddon(this){

                    public void drawBackgroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
                        AssetUtil.drawAsset((GuiGraphics)guiGraphics, (Screen)screen, (IAsset)provider.getAsset(AssetTypes.ITEM_BACKGROUND), (int)(guiX + this.getPosX()), (int)(guiY + this.getPosY()));
                        guiGraphics.m_280480_(MaterialStoneWorkFactoryTile.ACTION_RECIPES[MaterialStoneWorkFactoryTile.this.firstRecipeId].icon, guiX + this.getPosX() + 1, guiY + this.getPosY() + 1);
                    }

                    public List<Component> getTooltipLines() {
                        ArrayList<Component> lines = new ArrayList<Component>();
                        lines.add((Component)Component.m_237113_((String)(ChatFormatting.GOLD + LangUtil.getString((String)"tooltip.industrialforegoing.action", (Object[])new Object[0]) + ChatFormatting.WHITE + LangUtil.getString((String)("tooltip.industrialforegoing.stonework." + ACTION_RECIPES[MaterialStoneWorkFactoryTile.this.firstRecipeId].getAction()), (Object[])new Object[0]))));
                        return lines;
                    }
                });
            }
        }.setPredicate((playerEntity, compoundNBT) -> {
            this.firstRecipeId = (this.firstRecipeId + 1) % ACTION_RECIPES.length;
            this.markForUpdate();
        }));
        this.addButton(new ButtonComponent(102, 64, 18, 18){

            @OnlyIn(value=Dist.CLIENT)
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new BasicButtonAddon(this){

                    public void drawBackgroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
                        AssetUtil.drawAsset((GuiGraphics)guiGraphics, (Screen)screen, (IAsset)provider.getAsset(AssetTypes.ITEM_BACKGROUND), (int)(guiX + this.getPosX()), (int)(guiY + this.getPosY()));
                        guiGraphics.m_280480_(MaterialStoneWorkFactoryTile.ACTION_RECIPES[MaterialStoneWorkFactoryTile.this.secondRecipeId].icon, guiX + this.getPosX() + 1, guiY + this.getPosY() + 1);
                    }

                    public List<Component> getTooltipLines() {
                        ArrayList<Component> lines = new ArrayList<Component>();
                        lines.add((Component)Component.m_237113_((String)(ChatFormatting.GOLD + LangUtil.getString((String)"tooltip.industrialforegoing.action", (Object[])new Object[0]) + ChatFormatting.WHITE + LangUtil.getString((String)("tooltip.industrialforegoing.stonework." + ACTION_RECIPES[MaterialStoneWorkFactoryTile.this.secondRecipeId].getAction()), (Object[])new Object[0]))));
                        return lines;
                    }
                });
            }
        }.setPredicate((playerEntity, compoundNBT) -> {
            this.secondRecipeId = (this.secondRecipeId + 1) % ACTION_RECIPES.length;
            this.markForUpdate();
        }));
        this.addButton(new ButtonComponent(122, 64, 18, 18){

            @OnlyIn(value=Dist.CLIENT)
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new BasicButtonAddon(this){

                    public void drawBackgroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
                        AssetUtil.drawAsset((GuiGraphics)guiGraphics, (Screen)screen, (IAsset)provider.getAsset(AssetTypes.ITEM_BACKGROUND), (int)(guiX + this.getPosX()), (int)(guiY + this.getPosY()));
                        guiGraphics.m_280480_(MaterialStoneWorkFactoryTile.ACTION_RECIPES[MaterialStoneWorkFactoryTile.this.thirdRecipeId].icon, guiX + this.getPosX() + 1, guiY + this.getPosY() + 1);
                    }

                    public List<Component> getTooltipLines() {
                        ArrayList<Component> lines = new ArrayList<Component>();
                        lines.add((Component)Component.m_237113_((String)(ChatFormatting.GOLD + LangUtil.getString((String)"tooltip.industrialforegoing.action", (Object[])new Object[0]) + ChatFormatting.WHITE + LangUtil.getString((String)("tooltip.industrialforegoing.stonework." + ACTION_RECIPES[MaterialStoneWorkFactoryTile.this.thirdRecipeId].getAction()), (Object[])new Object[0]))));
                        return lines;
                    }
                });
            }
        }.setPredicate((playerEntity, compoundNBT) -> {
            this.thirdRecipeId = (this.thirdRecipeId + 1) % ACTION_RECIPES.length;
            this.markForUpdate();
        }));
        this.addButton(new ButtonComponent(142, 64, 18, 18){

            @OnlyIn(value=Dist.CLIENT)
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new BasicButtonAddon(this){

                    public void drawBackgroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
                        AssetUtil.drawAsset((GuiGraphics)guiGraphics, (Screen)screen, (IAsset)provider.getAsset(AssetTypes.ITEM_BACKGROUND), (int)(guiX + this.getPosX()), (int)(guiY + this.getPosY()));
                        guiGraphics.m_280480_(MaterialStoneWorkFactoryTile.ACTION_RECIPES[MaterialStoneWorkFactoryTile.this.fourthRecipeId].icon, guiX + this.getPosX() + 1, guiY + this.getPosY() + 1);
                    }

                    public List<Component> getTooltipLines() {
                        ArrayList<Component> lines = new ArrayList<Component>();
                        lines.add((Component)Component.m_237113_((String)(ChatFormatting.GOLD + LangUtil.getString((String)"tooltip.industrialforegoing.action", (Object[])new Object[0]) + ChatFormatting.WHITE + LangUtil.getString((String)("tooltip.industrialforegoing.stonework." + ACTION_RECIPES[MaterialStoneWorkFactoryTile.this.fourthRecipeId].getAction()), (Object[])new Object[0]))));
                        return lines;
                    }
                });
            }
        }.setPredicate((playerEntity, compoundNBT) -> {
            this.fourthRecipeId = (this.fourthRecipeId + 1) % ACTION_RECIPES.length;
            this.markForUpdate();
        }));
        this.maxProgress = MaterialStoneWorkFactoryConfig.maxProgress;
        this.powerPerOperation = MaterialStoneWorkFactoryConfig.powerPerTick;
    }

    protected EnergyStorageComponent<MaterialStoneWorkFactoryTile> createEnergyStorage() {
        return new EnergyStorageComponent(MaterialStoneWorkFactoryConfig.maxStoredPower, 10, 20);
    }

    @Override
    public boolean canIncrease() {
        return this.getRecipe().map(recipe -> recipe.canIncrease((FluidTank)this.water, (FluidTank)this.lava) && ItemHandlerHelper.insertItem(this.inventoryGenerator, (ItemStack)recipe.output.m_41777_(), (boolean)true).m_41619_()).orElse(false) != false || this.process(this.inventoryThird, this.inventoryFourth, ACTION_RECIPES[this.fourthRecipeId], true) || this.process(this.inventorySecond, this.inventoryThird, ACTION_RECIPES[this.thirdRecipeId], true) || this.process(this.inventoryFirst, this.inventorySecond, ACTION_RECIPES[this.secondRecipeId], true) || this.process(this.inventoryGenerator, this.inventoryFirst, ACTION_RECIPES[this.firstRecipeId], true);
    }

    public Optional<StoneWorkGenerateRecipe> getRecipe() {
        List recipes = RecipeUtil.getRecipes((Level)this.f_58857_, (RecipeType)((RecipeType)ModuleCore.STONEWORK_GENERATE_TYPE.get()));
        for (StoneWorkGenerateRecipe recipe : recipes) {
            if (!recipe.m_6423_().equals((Object)new ResourceLocation(this.generatorRecipe))) continue;
            return Optional.of(recipe);
        }
        return recipes.stream().filter(stoneWorkGenerateRecipe -> stoneWorkGenerateRecipe.m_6423_().equals((Object)DEFAULT)).findFirst();
    }

    public ResourceLocation getNextRecipe(boolean next) {
        if (this.generatorRecipe != null) {
            List rls = RecipeUtil.getRecipes((Level)this.f_58857_, (RecipeType)((RecipeType)ModuleCore.STONEWORK_GENERATE_TYPE.get())).stream().map(SerializableRecipe::m_6423_).collect(Collectors.toList());
            int currentIndex = rls.indexOf(new ResourceLocation(this.generatorRecipe));
            if (next) {
                this.generatorRecipe = ((ResourceLocation)rls.get((currentIndex + 1) % rls.size())).toString();
            } else {
                if (--currentIndex < 0) {
                    currentIndex = rls.size() - 1;
                }
                this.generatorRecipe = ((ResourceLocation)rls.get(currentIndex)).toString();
            }
        }
        return DEFAULT;
    }

    @Override
    public Runnable onFinish() {
        return () -> {
            if (!(this.process(this.inventoryThird, this.inventoryFourth, ACTION_RECIPES[this.fourthRecipeId], false) || this.process(this.inventorySecond, this.inventoryThird, ACTION_RECIPES[this.thirdRecipeId], false) || this.process(this.inventoryFirst, this.inventorySecond, ACTION_RECIPES[this.secondRecipeId], false) || this.process(this.inventoryGenerator, this.inventoryFirst, ACTION_RECIPES[this.firstRecipeId], false))) {
                this.getRecipe().ifPresent(recipe -> {
                    ItemStack output = recipe.output.m_41777_();
                    if (ItemHandlerHelper.insertItem(this.inventoryGenerator, (ItemStack)output, (boolean)false).m_41619_()) {
                        recipe.consume((FluidTankComponent)this.water, (FluidTankComponent)this.lava);
                    }
                });
            }
        };
    }

    @Override
    protected int getTickPower() {
        return this.powerPerOperation;
    }

    private boolean process(SidedInventoryComponent input, SidedInventoryComponent output, StoneWorkAction action, boolean simulate) {
        boolean full = true;
        for (int i = 0; i < output.getSlots(); ++i) {
            ItemStack stack = output.getStackInSlot(i);
            if (!stack.m_41619_() && stack.m_41613_() >= stack.m_41741_()) continue;
            full = false;
        }
        if (full) {
            return false;
        }
        for (int slot = 0; slot < input.getSlots(); ++slot) {
            ItemStack outputStack;
            ItemStack inputStack = input.getStackInSlot(slot);
            if (inputStack.m_41619_() || (outputStack = action.work.apply(this.f_58857_, inputStack.m_41777_()).m_41777_()).m_41619_() || !ItemHandlerHelper.insertItem((IItemHandler)output, (ItemStack)outputStack, (boolean)true).m_41619_()) continue;
            if (!simulate) {
                ItemHandlerHelper.insertItem((IItemHandler)output, (ItemStack)outputStack, (boolean)false);
                inputStack.m_41774_(action.getShrinkAmount());
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public MaterialStoneWorkFactoryTile getSelf() {
        return this;
    }

    @Override
    public int getMaxProgress() {
        return this.maxProgress;
    }

    @Override
    public void saveSettings(Player player, CompoundTag tag) {
        tag.m_128359_("MSWF_generatorRecipe", this.generatorRecipe);
        tag.m_128405_("MSWF_firstRecipeId", this.firstRecipeId);
        tag.m_128405_("MSWF_secondRecipeId", this.secondRecipeId);
        tag.m_128405_("MSWF_thirdRecipeId", this.thirdRecipeId);
        tag.m_128405_("MSWF_fourthRecipeId", this.fourthRecipeId);
        super.saveSettings(player, tag);
    }

    @Override
    public void loadSettings(Player player, CompoundTag tag) {
        if (tag.m_128441_("MSWF_generatorRecipe")) {
            this.generatorRecipe = tag.m_128461_("MSWF_generatorRecipe");
        }
        if (tag.m_128441_("MSWF_firstRecipeId")) {
            this.firstRecipeId = tag.m_128451_("MSWF_firstRecipeId");
        }
        if (tag.m_128441_("MSWF_secondRecipeId")) {
            this.secondRecipeId = tag.m_128451_("MSWF_secondRecipeId");
        }
        if (tag.m_128441_("MSWF_thirdRecipeId")) {
            this.thirdRecipeId = tag.m_128451_("MSWF_thirdRecipeId");
        }
        if (tag.m_128441_("MSWF_fourthRecipeId")) {
            this.fourthRecipeId = tag.m_128451_("MSWF_fourthRecipeId");
        }
        super.loadSettings(player, tag);
    }

    public static class StoneWorkAction {
        private final ItemStack icon;
        private final BiFunction<Level, ItemStack, ItemStack> work;
        private final int shrinkAmount;
        private final String action;

        private StoneWorkAction(ItemStack icon, BiFunction<Level, ItemStack, ItemStack> work, int shrinkAmount, String action) {
            this.icon = icon;
            this.work = work;
            this.shrinkAmount = shrinkAmount;
            this.action = action;
        }

        public ItemStack getIcon() {
            return this.icon;
        }

        public BiFunction<Level, ItemStack, ItemStack> getWork() {
            return this.work;
        }

        public int getShrinkAmount() {
            return this.shrinkAmount;
        }

        public String getAction() {
            return this.action;
        }
    }
}

