/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.ponders;

import com.simibubi.create.content.kinetics.gauge.StressGaugeBlockEntity;
import com.simibubi.create.foundation.ponder.CreateSceneBuilder;
import net.createmod.catnip.math.Pointing;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;
import org.antarcticgardens.cna.content.electricity.connector.ElectricalConnectorBlockEntity;
import org.antarcticgardens.cna.content.electricity.wire.WireType;

public class MotorExtensionPonder {
    public static void motorExtension(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("motor_extension", "Motor Extensions");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.addKeyframe();
        BlockPos stressometer = util.grid().at(1, 1, 2);
        scene.world().modifyBlockEntityNBT(util.select().position(stressometer), StressGaugeBlockEntity.class, nbt -> nbt.m_128350_("Value", 1.0f));
        scene.world().modifyBlockEntity(util.grid().at(2, 2, 2), ElectricalConnectorBlockEntity.class, be -> be.connect((ElectricalConnectorBlockEntity)be.m_58904_().m_7702_(util.grid().at(4, 2, 2)), WireType.OVERCHARGED_GOLD));
        scene.idle(10);
        scene.world().showSection(util.select().position(2, 1, 2), Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(util.select().position(stressometer), Direction.DOWN);
        MotorExtensionPonder.redstoneIdle((SceneBuilder)scene, stressometer, 1);
        scene.world().showSection(util.select().position(2, 2, 2), Direction.DOWN);
        scene.world().showSection(util.select().position(4, 2, 2), Direction.DOWN);
        MotorExtensionPonder.redstoneIdle((SceneBuilder)scene, stressometer, 1);
        MotorExtensionPonder.redstoneIdle((SceneBuilder)scene, stressometer, 4);
        scene.overlay().showText(60).pointAt(stressometer.m_252807_()).placeNearTarget().text("Tired of your motors being overstressed? Use a motor extension!");
        MotorExtensionPonder.redstoneIdle((SceneBuilder)scene, stressometer, 14);
        scene.world().showSection(util.select().position(3, 1, 2), Direction.SOUTH);
        scene.overlay().showText(60).pointAt(util.grid().at(3, 1, 2).m_252807_()).placeNearTarget().text("Extensions allow you to configure motor stress capacity multiplier");
        MotorExtensionPonder.redstoneIdle((SceneBuilder)scene, stressometer, 14);
        Vec3 blockSurface = util.vector().blockSurface(util.grid().at(3, 1, 2), Direction.NORTH).m_82520_(-0.0625, 0.0, 0.1875);
        scene.overlay().showFilterSlotInput(blockSurface, Direction.NORTH, 80);
        scene.overlay().showControls(blockSurface, Pointing.DOWN, 60).rightClick();
        MotorExtensionPonder.redstoneIdle((SceneBuilder)scene, stressometer, 14);
        scene.world().modifyBlockEntityNBT(util.select().position(stressometer), StressGaugeBlockEntity.class, nbt -> nbt.m_128350_("Value", 0.5f));
        scene.world().setKineticSpeed(util.select().fromTo(1, 1, 2, 3, 1, 2), 64.0f);
        scene.idle(30);
        scene.overlay().showText(60).pointAt(util.grid().at(3, 1, 2).m_252807_()).placeNearTarget().text("Note that energy consumption is proportional to stress capacity");
        scene.idle(60);
    }

    private static void redstoneIdle(SceneBuilder scene, BlockPos pos, int iterations) {
        for (int i = 0; i < iterations; ++i) {
            scene.effects().indicateRedstone(pos);
            scene.idle(5);
        }
    }
}

