/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.event;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import dev.schmarrn.lighty.ModeLoader;
import dev.schmarrn.lighty.api.LightyMode;
import dev.schmarrn.lighty.config.Config;
import dev.schmarrn.lighty.event.BufferHolder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class Compute {
    private static final int INITIAL_HASHSET_CAPACITY = 550;
    private static HashSet<SectionPos> toBeUpdated = new HashSet(550);
    private static HashSet<SectionPos> toBeRemoved = new HashSet(550);
    private static final Map<SectionPos, BufferHolder> cachedBuffers = new HashMap<SectionPos, BufferHolder>();
    private static ChunkPos playerPos = null;
    private static int computationDistance = Math.min(Config.getOverlayDistance(), (Integer)Minecraft.m_91087_().f_91066_.m_231984_().m_231551_());

    private static boolean outOfRange(SectionPos pos) {
        int computationDistanceSquared = computationDistance * computationDistance;
        if (playerPos == null) {
            return true;
        }
        int sqX = (pos.m_123170_() - Compute.playerPos.f_45578_) * (pos.m_123170_() - Compute.playerPos.f_45578_);
        int sqZ = (pos.m_123222_() - Compute.playerPos.f_45579_) * (pos.m_123222_() - Compute.playerPos.f_45579_);
        return sqX > computationDistanceSquared || sqZ > computationDistanceSquared;
    }

    public static void clear() {
        toBeUpdated = new HashSet(550);
        cachedBuffers.forEach((sectionPos, vertexBuffer) -> vertexBuffer.close());
        cachedBuffers.clear();
        computationDistance = Math.min(Config.getOverlayDistance(), (Integer)Minecraft.m_91087_().f_91066_.m_231984_().m_231551_());
    }

    public static void updateSubChunk(SectionPos pos) {
        if (Compute.outOfRange(pos)) {
            return;
        }
        toBeUpdated.add(pos);
    }

    private static BufferHolder buildChunk(LightyMode mode, SectionPos chunkPos, BufferBuilder builder, ClientLevel world) {
        mode.beforeCompute(builder);
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    BlockPos pos = chunkPos.m_123249_().m_7918_(x, y, z);
                    mode.compute(world, pos, builder);
                }
            }
        }
        BufferHolder buffer = cachedBuffers.get(chunkPos);
        if (buffer == null) {
            buffer = new BufferHolder();
        }
        buffer.upload(builder.m_231175_());
        mode.afterCompute();
        return buffer;
    }

    public static void computeCache(Minecraft client) {
        LightyMode mode = ModeLoader.getCurrentMode();
        if (mode == null) {
            return;
        }
        ClientLevel world = client.f_91073_;
        if (client.f_91074_ == null || world == null) {
            return;
        }
        playerPos = new ChunkPos(client.f_91074_.m_20183_());
        cachedBuffers.forEach((sectionPos, bufferHolder) -> {
            if (Compute.outOfRange(sectionPos)) {
                toBeRemoved.add((SectionPos)sectionPos);
            }
        });
        HashSet<SectionPos> removeFromToBeUpdated = new HashSet<SectionPos>(550);
        for (SectionPos sectionPos2 : toBeUpdated) {
            if (Compute.outOfRange(sectionPos2)) {
                toBeRemoved.add(sectionPos2);
                continue;
            }
            removeFromToBeUpdated.add(sectionPos2);
            cachedBuffers.compute(sectionPos2, (pos, vertexBuffer) -> {
                if (vertexBuffer != null) {
                    vertexBuffer.close();
                }
                return Compute.buildChunk(mode, pos, Tesselator.m_85913_().m_85915_(), world);
            });
        }
        for (SectionPos pos2 : removeFromToBeUpdated) {
            toBeUpdated.remove(pos2);
        }
        for (SectionPos sectionPos2 : toBeRemoved) {
            toBeUpdated.remove(sectionPos2);
            BufferHolder buf = cachedBuffers.remove(sectionPos2);
            if (buf == null) continue;
            buf.close();
        }
        toBeRemoved = new HashSet(550);
    }

    public static void render(@Nullable Frustum frustum, PoseStack matrixStack, Matrix4f projectionMatrix) {
        LightyMode mode = ModeLoader.getCurrentMode();
        if (mode == null) {
            return;
        }
        if (frustum == null) {
            return;
        }
        if (playerPos == null) {
            return;
        }
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            return;
        }
        mode.beforeRendering();
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(-camera.m_90583_().f_82479_, -camera.m_90583_().f_82480_, -camera.m_90583_().f_82481_);
        Matrix4f positionMatrix = matrixStack.m_85850_().m_252922_();
        ShaderInstance shader = RenderSystem.getShader();
        float renderDistance = Minecraft.m_91087_().f_91063_.m_109152_() * 16.0f * 4012.0f;
        float fogStart = renderDistance - Mth.m_14036_((float)(renderDistance / 10.0f), (float)4.0f, (float)64.0f);
        float oldFogStart = RenderSystem.getShaderFogStart();
        float oldFogEnd = RenderSystem.getShaderFogEnd();
        FogShape oldFogShape = RenderSystem.getShaderFogShape();
        RenderSystem.setShaderFogStart((float)fogStart);
        RenderSystem.setShaderFogEnd((float)renderDistance);
        RenderSystem.setShaderFogShape((FogShape)FogShape.CYLINDER);
        for (int x = -computationDistance + 1; x < computationDistance; ++x) {
            for (int z = -computationDistance + 1; z < computationDistance; ++z) {
                ChunkPos chunkPos = new ChunkPos(Compute.playerPos.f_45578_ + x, Compute.playerPos.f_45579_ + z);
                for (int i = 0; i < world.m_151559_(); ++i) {
                    SectionPos chunkSection = SectionPos.m_123196_((ChunkPos)chunkPos, (int)(world.m_151560_() + i));
                    if (!frustum.m_113029_(new AABB(chunkSection.m_123249_().m_7918_(-1, -1, -1), chunkSection.m_123249_().m_7918_(16, 16, 16)))) continue;
                    if (cachedBuffers.containsKey(chunkSection)) {
                        BufferHolder cachedBuffer = cachedBuffers.get(chunkSection);
                        if (!cachedBuffer.isValid()) {
                            toBeUpdated.add(chunkSection);
                            continue;
                        }
                        cachedBuffer.draw(positionMatrix, projectionMatrix, shader);
                        continue;
                    }
                    toBeUpdated.add(chunkSection);
                }
            }
        }
        RenderSystem.setShaderFogStart((float)oldFogStart);
        RenderSystem.setShaderFogEnd((float)oldFogEnd);
        RenderSystem.setShaderFogShape((FogShape)oldFogShape);
        matrixStack.m_85849_();
        mode.afterRendering();
    }

    private Compute() {
    }
}

