/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg;

import com.drmangotea.tfmg.TFMGClient;
import com.drmangotea.tfmg.base.TFMGBoilerHeaters;
import com.drmangotea.tfmg.base.TFMGContraptions;
import com.drmangotea.tfmg.base.TFMGCreativeTabs;
import com.drmangotea.tfmg.base.TFMGRegistrate;
import com.drmangotea.tfmg.base.TFMGRegistries;
import com.drmangotea.tfmg.base.fluid.TFMGFluidInteractions;
import com.drmangotea.tfmg.config.TFMGConfigs;
import com.drmangotea.tfmg.content.decoration.pipes.TFMGPipes;
import com.drmangotea.tfmg.content.electricity.base.ElectricNetworkManager;
import com.drmangotea.tfmg.content.engines.fuels.BaseFuelTypes;
import com.drmangotea.tfmg.content.items.weapons.explosives.thermite_grenades.fire.TFMGColoredFires;
import com.drmangotea.tfmg.content.machinery.oil_processing.pumpjack.pumpjack.base.TestSavedDataManager;
import com.drmangotea.tfmg.datagen.TFMGDatagen;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.drmangotea.tfmg.registry.TFMGCableTypes;
import com.drmangotea.tfmg.registry.TFMGElectrodes;
import com.drmangotea.tfmg.registry.TFMGEncasedBlocks;
import com.drmangotea.tfmg.registry.TFMGEntityTypes;
import com.drmangotea.tfmg.registry.TFMGFluids;
import com.drmangotea.tfmg.registry.TFMGItems;
import com.drmangotea.tfmg.registry.TFMGMenuTypes;
import com.drmangotea.tfmg.registry.TFMGMobEffects;
import com.drmangotea.tfmg.registry.TFMGMountedStorageTypes;
import com.drmangotea.tfmg.registry.TFMGPackets;
import com.drmangotea.tfmg.registry.TFMGPaletteBlocks;
import com.drmangotea.tfmg.registry.TFMGPartialModels;
import com.drmangotea.tfmg.registry.TFMGParticleTypes;
import com.drmangotea.tfmg.registry.TFMGRecipeTypes;
import com.drmangotea.tfmg.registry.TFMGSoundEvents;
import com.drmangotea.tfmg.worldgen.TFMGFeatures;
import com.mojang.logging.LogUtils;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipModifier;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegisterEvent;
import org.slf4j.Logger;

@Mod(value="tfmg")
public class TFMG {
    public static final String MOD_ID = "tfmg";
    public static final ElectricNetworkManager NETWORK_MANAGER = new ElectricNetworkManager();
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final TestSavedDataManager DEPOSITS = new TestSavedDataManager();
    public static final TFMGRegistrate REGISTRATE = TFMGRegistrate.create();
    public static final FontHelper.Palette TFMG_PALETTE = new FontHelper.Palette(FontHelper.styleFromColor((int)5001557), FontHelper.styleFromColor((int)8621194));

    public TFMG() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        LOGGER.info("[TFMG] Initializing core systems...");
        REGISTRATE.registerEventListeners(modEventBus);
        TFMGRegistries.register();
        modEventBus.addListener(this::onRegister);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(EventPriority.LOWEST, TFMGDatagen::gatherData);
        modEventBus.addListener(TFMGSoundEvents::register);
        LOGGER.info("[TFMG] Registering content...");
        TFMGSoundEvents.prepare();
        TFMGParticleTypes.register(modEventBus);
        TFMGRecipeTypes.register(modEventBus);
        TFMGMobEffects.register(modEventBus);
        TFMGColoredFires.register(modEventBus);
        TFMGBlocks.init();
        TFMGItems.init();
        TFMGEncasedBlocks.init();
        TFMGPaletteBlocks.init();
        TFMGBlockEntities.init();
        TFMGEntityTypes.init();
        TFMGMenuTypes.init();
        TFMGFluids.init();
        LOGGER.info("[TFMG] Initializing systems...");
        TFMGPipes.init();
        TFMGElectrodes.register();
        TFMGCableTypes.register();
        TFMGMountedStorageTypes.register();
        TFMGFeatures.register(modEventBus);
        TFMGPackets.registerPackets();
        TFMGConfigs.register(ModLoadingContext.get());
        LOGGER.info("[TFMG] Setting up client...");
        TFMGPartialModels.init();
        TFMGCreativeTabs.register(modEventBus);
        modEventBus.addListener(TFMGCreativeTabs::addCreative);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> TFMGClient::new);
        MinecraftForge.EVENT_BUS.register((Object)this);
        LOGGER.info("[TFMG] Initialization complete!");
    }

    private void clientSetup(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFMGColoredFires.GREEN_FIRE.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFMGColoredFires.BLUE_FIRE.get()), (RenderType)RenderType.m_110463_());
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        TFMGFluidInteractions.registerFluidInteractions();
        event.enqueueWork(() -> {
            BaseFuelTypes.register();
            TFMGBoilerHeaters.registerDefaults();
        });
    }

    public void onRegister(RegisterEvent event) {
        TFMGContraptions.prepare();
    }

    public static ResourceLocation asResource(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    static {
        REGISTRATE.setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, TFMG_PALETTE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item))));
    }
}

