/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.engines.types;

import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.content.engines.base.AbstractEngineBlockEntity;
import com.drmangotea.tfmg.content.engines.base.EngineBlock;
import com.drmangotea.tfmg.content.engines.base.EngineComponentsInventory;
import com.drmangotea.tfmg.content.engines.base.EngineProperties;
import com.drmangotea.tfmg.content.engines.engine_controller.EngineControllerBlockEntity;
import com.drmangotea.tfmg.content.engines.upgrades.EnginePipingUpgrade;
import com.drmangotea.tfmg.content.engines.upgrades.EngineUpgrade;
import com.drmangotea.tfmg.content.engines.upgrades.TransmissionUpgrade;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.drmangotea.tfmg.registry.TFMGFluids;
import com.drmangotea.tfmg.registry.TFMGItems;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public abstract class AbstractSmallEngineBlockEntity
extends AbstractEngineBlockEntity {
    public Optional<? extends EngineUpgrade> upgrade = Optional.empty();
    public TransmissionUpgrade.TransmissionState shift = TransmissionUpgrade.TransmissionState.NEUTRAL;
    public boolean clutchPressed = false;
    public int oil = 0;
    public int coolingFluid = 0;
    public EngineComponentsInventory componentsInventory;
    public BlockPos controller = this.m_58899_();
    public boolean connectNextTick = true;
    public boolean delayedConnect = false;
    public List<Long> engines = new ArrayList<Long>();
    public int engineNumber = 0;

    public AbstractSmallEngineBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.componentsInventory = new EngineComponentsInventory((SyncedBlockEntity)this, EngineProperties.commonRegularComponents());
    }

    @Override
    public int getFuelConsumption() {
        if (this.rpm == 0.0f) {
            return 0;
        }
        float oilModifier = this.oil > 0 ? 0.7f : 1.0f;
        float coolingFluidModifier = this.coolingFluid > 0 ? 0.7f : 1.0f;
        return (int)(12.5f * (1.0f / this.efficiencyModifier()) * this.getSpeedEfficiency() * this.fuelInjectionRate * oilModifier * coolingFluidModifier) * (this.engineLength() + 1);
    }

    public void detashEngines() {
    }

    public void setBlockStates(AbstractSmallEngineBlockEntity be, BlockPos last) {
        if (!be.isController()) {
            this.f_58857_.m_7731_(be.m_58899_(), (BlockState)this.f_58857_.m_8055_(be.m_58899_()).m_61124_(EngineBlock.SHAFT_FACING, (Comparable)((Direction)this.m_58900_().m_61143_(EngineBlock.SHAFT_FACING)).m_122424_()), 2);
        }
    }

    public boolean hasAllComponents() {
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.controller);
        if (blockEntity instanceof AbstractSmallEngineBlockEntity) {
            AbstractSmallEngineBlockEntity be = (AbstractSmallEngineBlockEntity)blockEntity;
            return be.nextComponent() == Ingredient.f_43901_;
        }
        return false;
    }

    public boolean hasUpgrade() {
        return this.upgrade.isPresent();
    }

    @Override
    public int voltageGeneration() {
        if (this.upgrade.isPresent() && this.upgrade.get().getItem() == TFMGBlocks.GENERATOR.m_5456_()) {
            return (int)(20.0f * (this.rpm / 500.0f));
        }
        return 0;
    }

    @Override
    public int powerGeneration() {
        if (this.upgrade.isPresent() && this.upgrade.get().getItem() == TFMGBlocks.GENERATOR.m_5456_()) {
            return (int)this.rpm;
        }
        return 0;
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.f_58857_.f_46441_.m_188503_(45) == 0 && this.oil > 0) {
            --this.oil;
        }
        if (this.f_58857_.f_46441_.m_188503_(45) == 0 && this.coolingFluid > 0) {
            --this.coolingFluid;
        }
        this.upgrade.ifPresent(engineUpgrade -> engineUpgrade.lazyTickUpgrade(this));
    }

    public float calculateAddedStressCapacity() {
        float stress = super.calculateAddedStressCapacity() + this.torque;
        return this.hasTwoShafts() ? stress / 2.0f : stress;
    }

    public boolean hasTwoShafts() {
        BlockState state;
        if (!this.isController()) {
            return this.getControllerBE().hasTwoShafts();
        }
        return this.m_58900_().m_61143_(EngineBlock.ENGINE_STATE) == EngineBlock.EngineState.SHAFT && (state = this.f_58857_.m_8055_(this.controller.m_122020_(this.engineLength()))).m_60734_() instanceof EngineBlock && this.engineLength() > 1 && state.m_61143_(EngineBlock.ENGINE_STATE) == EngineBlock.EngineState.SHAFT;
    }

    @Override
    public void neighbourChanged() {
        if (this.controller == null) {
            return;
        }
        super.neighbourChanged();
    }

    public void onLoad() {
        super.onLoad();
        if (this.hasUpgrade() && this.upgrade.get().getItem() == TFMGBlocks.INDUSTRIAL_PIPE.m_5456_()) {
            ((EnginePipingUpgrade)this.upgrade.get()).findTank(this);
        }
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        if (EngineUpgrade.getUpgrades().get(ItemStack.m_41712_((CompoundTag)compound.m_128469_("UpgradeItem")).m_41720_()) != null) {
            this.upgrade = Optional.of(EngineUpgrade.getUpgrades().get(ItemStack.m_41712_((CompoundTag)compound.m_128469_("UpgradeItem")).m_41720_()));
        }
        if (!compound.m_128461_("Shift").isEmpty()) {
            this.shift = TransmissionUpgrade.TransmissionState.valueOf(compound.m_128461_("Shift"));
        }
        this.oil = compound.m_128451_("Oil");
        this.coolingFluid = compound.m_128451_("CoolingFluid");
        this.componentsInventory.deserializeNBT(compound.m_128469_("Components"));
        super.read(compound, clientPacket);
        this.controller = BlockPos.m_122022_((long)compound.m_128454_("Controller"));
    }

    public int engineLength() {
        return this.engines.size();
    }

    @Override
    public boolean canWork() {
        if (!this.nextComponent().m_43947_()) {
            return false;
        }
        return super.canWork();
    }

    public Ingredient nextComponent() {
        if (!this.isController()) {
            return Ingredient.f_43901_;
        }
        for (int i = 0; i < this.componentsInventory.getSlots(); ++i) {
            if (!this.componentsInventory.getStackInSlot(i).m_41619_()) continue;
            return this.componentsInventory.components.get(i);
        }
        return Ingredient.f_43901_;
    }

    @Override
    protected void analogSignalChanged() {
        BlockEntity blockEntity;
        int newSignal;
        if (this.controller == null) {
            return;
        }
        if (this.hasEngineController()) {
            this.fuelInjectionRate = (float)this.highestSignal / 15.0f;
            return;
        }
        this.getControllerBE().updateRotation();
        this.getControllerBE().updateGeneratedRotation();
        this.signal = newSignal = this.f_58857_.m_277086_(this.m_58899_());
        if (!this.isController() && (blockEntity = this.f_58857_.m_7702_(this.controller)) instanceof AbstractSmallEngineBlockEntity) {
            AbstractSmallEngineBlockEntity be = (AbstractSmallEngineBlockEntity)blockEntity;
            be.analogSignalChanged();
            return;
        }
        for (long posLong : this.engines) {
            BlockPos pos = BlockPos.m_122022_((long)posLong);
            newSignal = Math.max(this.f_58857_.m_277086_(pos), newSignal);
        }
        this.highestSignal = newSignal = Math.max(this.f_58857_.m_277086_(this.controller), newSignal);
        this.fuelInjectionRate = (float)this.highestSignal / 15.0f;
        this.updateRotation();
    }

    @Override
    public IFluidHandler handlerForCapability() {
        return this.isController() || this.getControllerBE() == this ? new CombinedTankWrapper(new IFluidHandler[]{this.fuelTank, this.exhaustTank}) : this.getControllerBE().handlerForCapability();
    }

    @Override
    protected void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128356_("Controller", this.controller.m_121878_());
        compound.m_128359_("Shift", this.shift.name());
        if (this.controller != null) {
            compound.m_128356_("ControllerPos", this.controller.m_121878_());
        } else {
            compound.m_128473_("ControllerPos");
        }
        if (this.upgrade.isPresent()) {
            compound.m_128365_("UpgradeItem", (Tag)this.upgrade.get().getItem().m_7968_().serializeNBT());
        }
        compound.m_128365_("Components", (Tag)this.componentsInventory.serializeNBT());
        compound.m_128405_("Oil", this.oil);
        compound.m_128405_("CoolingFluid", this.coolingFluid);
        super.write(compound, clientPacket);
    }

    @Override
    public void updateRotation() {
        if (!this.isController()) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.controller);
            if (blockEntity instanceof AbstractSmallEngineBlockEntity) {
                AbstractSmallEngineBlockEntity be = (AbstractSmallEngineBlockEntity)blockEntity;
                be.updateRotation();
            }
            return;
        }
        ArrayList<Long> allEngines = new ArrayList<Long>(this.engines);
        allEngines.add(this.controller.m_121878_());
        for (TagKey<Fluid> fluidTag : this.getSupportedFuels()) {
            if (!this.fuelTank.getFluid().getFluid().m_205067_(fluidTag)) continue;
            if (!this.canWork()) {
                allEngines.forEach(l -> {
                    BlockPos pos = BlockPos.m_122022_((long)l);
                    BlockEntity patt10851$temp = this.f_58857_.m_7702_(pos);
                    if (patt10851$temp instanceof AbstractEngineBlockEntity) {
                        AbstractEngineBlockEntity be = (AbstractEngineBlockEntity)patt10851$temp;
                        be.rpm = 0.0f;
                        be.torque = 0.0f;
                        be.updateGeneratedRotation();
                    }
                });
                return;
            }
            allEngines.forEach(l -> {
                BlockPos pos = BlockPos.m_122022_((long)l);
                BlockEntity patt11286$temp = this.f_58857_.m_7702_(pos);
                if (patt11286$temp instanceof AbstractEngineBlockEntity) {
                    AbstractEngineBlockEntity be = (AbstractEngineBlockEntity)patt11286$temp;
                    be.rpm = 4000.0f * this.speedModifier() * this.fuelInjectionRate;
                    be.torque = 15.0f * this.torqueModifier() * this.fuelInjectionRate * (float)this.engineLength();
                    be.updateGeneratedRotation();
                }
            });
            return;
        }
        this.updateGeneratedRotation();
        this.getAllEngines().forEach(l -> {
            BlockEntity patt11817$temp;
            if (this.m_58898_() && (patt11817$temp = this.f_58857_.m_7702_(BlockPos.m_122022_((long)l))) instanceof AbstractEngineBlockEntity) {
                AbstractEngineBlockEntity be = (AbstractEngineBlockEntity)patt11817$temp;
                be.updateGeneratedRotation();
            }
        });
    }

    public boolean canGenerateSpeed() {
        return this.m_58900_().m_61143_(EngineBlock.ENGINE_STATE) == EngineBlock.EngineState.SHAFT;
    }

    public float getGeneratedSpeed() {
        if (!this.canGenerateSpeed()) {
            return 0.0f;
        }
        if (this.m_58898_()) {
            if (this.getControllerBE().fuelTank.isEmpty()) {
                return 0.0f;
            }
            if (!this.getControllerBE().canWork()) {
                return 0.0f;
            }
            float speed = this.rpm / 40.0f;
            if (this.reverse) {
                speed *= -1.0f;
            }
            if (this.getControllerBE().hasEngineController() && this.getControllerBE().hasTwoShafts()) {
                speed = switch (this.getControllerBE().shift) {
                    default -> throw new IncompatibleClassChangeError();
                    case TransmissionUpgrade.TransmissionState.REVERSE -> speed * -0.3f;
                    case TransmissionUpgrade.TransmissionState.NEUTRAL -> 0.0f;
                    case TransmissionUpgrade.TransmissionState.SHIFT_1 -> speed * 0.2f;
                    case TransmissionUpgrade.TransmissionState.SHIFT_2 -> speed * 0.4f;
                    case TransmissionUpgrade.TransmissionState.SHIFT_3 -> speed * 0.6f;
                    case TransmissionUpgrade.TransmissionState.SHIFT_4 -> speed * 0.8f;
                    case TransmissionUpgrade.TransmissionState.SHIFT_5 -> speed;
                    case TransmissionUpgrade.TransmissionState.SHIFT_6 -> speed * 1.2f;
                };
            }
            return AbstractSmallEngineBlockEntity.convertToDirection((float)Math.min((int)speed, 256), (Direction)((Direction)this.m_58900_().m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING)));
        }
        return 0.0f;
    }

    @Override
    public void tankUpdated(FluidStack stack, boolean fuel) {
        if (stack.getFluid().m_6212_((Fluid)TFMGFluids.CARBON_DIOXIDE.get()) && stack.getAmount() >= this.exhaustTank.getSpace()) {
            this.updateRotation();
        }
        super.tankUpdated(stack, fuel);
    }

    public boolean insertItem(ItemStack itemStack, boolean shifting, Player player, InteractionHand hand) {
        Optional<? extends EngineUpgrade> itemUpgrade;
        BlockEntity toDrain2;
        BlockEntity blockEntity;
        Direction shaft_facing = (Direction)this.m_58900_().m_61143_(EngineBlock.SHAFT_FACING);
        if (itemStack.m_150930_(AllBlocks.SHAFT.m_5456_()) && this.m_58900_().m_61143_(EngineBlock.ENGINE_STATE) == EngineBlock.EngineState.NORMAL && !(this.f_58857_.m_7702_(this.m_58899_().m_121945_(shaft_facing)) instanceof AbstractEngineBlockEntity)) {
            this.playInsertionSound();
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(EngineBlock.ENGINE_STATE, (Comparable)((Object)EngineBlock.EngineState.SHAFT)), 2);
            itemStack.m_41774_(1);
            this.updateRotation();
            this.m_6596_();
            this.sendData();
            return true;
        }
        if (itemStack.m_150930_((Item)TFMGItems.SCREWDRIVER.get())) {
            for (int i = this.componentsInventory.components.size() - 1; i >= 0; --i) {
                if (this.componentsInventory.m_8020_(i).m_41619_()) continue;
                this.dropItem(this.componentsInventory.m_8020_(i));
                this.componentsInventory.setStackInSlot(i, ItemStack.f_41583_);
                this.playRemovalSound();
                this.updateRotation();
                this.m_6596_();
                this.sendData();
                return true;
            }
        }
        if (itemStack.m_150930_((Item)TFMGItems.COOLING_FLUID_BOTTLE.get()) && (blockEntity = this.f_58857_.m_7702_(this.controller)) instanceof AbstractSmallEngineBlockEntity) {
            AbstractSmallEngineBlockEntity be = (AbstractSmallEngineBlockEntity)blockEntity;
            int toDrain2 = Math.min(2000 - this.coolingFluid, itemStack.m_41784_().m_128451_("amount"));
            itemStack.m_41784_().m_128405_("amount", itemStack.m_41784_().m_128451_("amount") - toDrain2);
            be.coolingFluid += toDrain2;
            this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        if (itemStack.m_150930_((Item)TFMGItems.OIL_CAN.get()) && (toDrain2 = this.f_58857_.m_7702_(this.controller)) instanceof AbstractSmallEngineBlockEntity) {
            AbstractSmallEngineBlockEntity be = (AbstractSmallEngineBlockEntity)toDrain2;
            int toDrain3 = Math.min(2000 - this.oil, itemStack.m_41784_().m_128451_("amount"));
            itemStack.m_41784_().m_128405_("amount", itemStack.m_41784_().m_128451_("amount") - toDrain3);
            be.oil += toDrain3;
            this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.updateRotation();
            return true;
        }
        if (itemStack.m_150930_((Item)TFMGFluids.COOLING_FLUID.getBucket().get()) && this.coolingFluid <= 1000) {
            this.coolingFluid += 1000;
            player.m_21008_(hand, Items.f_42446_.m_7968_());
            this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.updateRotation();
            return true;
        }
        if (itemStack.m_150930_((Item)TFMGFluids.LUBRICATION_OIL.getBucket().get()) && this.oil <= 1000) {
            this.oil += 1000;
            player.m_21008_(hand, Items.f_42446_.m_7968_());
            this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.updateRotation();
            return true;
        }
        if (this.upgrade.isEmpty() && EngineUpgrade.getUpgrades().containsKey(itemStack.m_41720_()) && (itemUpgrade = EngineUpgrade.getUpgrades().get(itemStack.m_41720_()).createUpgrade()).isPresent() && this.isUpgradeFirst(itemUpgrade.get())) {
            EngineUpgrade engineUpgrade;
            this.upgrade = itemUpgrade;
            this.playInsertionSound();
            this.updateRotation();
            this.upgrade.ifPresent(u -> u.updateUpgrade(this));
            itemStack.m_41774_(1);
            if (this.upgrade.isPresent() && (engineUpgrade = this.upgrade.get()) instanceof TransmissionUpgrade) {
                BlockPos pos;
                BlockEntity blockEntity2;
                TransmissionUpgrade transmissionUpgrade = (TransmissionUpgrade)engineUpgrade;
                if (itemStack.m_41784_().m_128441_("Position") && itemStack.m_41784_().m_128423_("Position") != null && (blockEntity2 = this.f_58857_.m_7702_(pos = BlockPos.m_122022_((long)itemStack.m_41784_().m_128454_("Position")))) instanceof EngineControllerBlockEntity) {
                    EngineControllerBlockEntity engineControllerBE = (EngineControllerBlockEntity)blockEntity2;
                    this.getControllerBE().updateGeneratedRotation();
                    this.getControllerBE().controller = pos;
                    engineControllerBE.enginePos = this.m_58899_();
                    this.getControllerBE().highestSignal = 0;
                }
            }
            this.m_6596_();
            this.sendData();
            return true;
        }
        if (!this.isController()) {
            return false;
        }
        if (this.nextComponent().test(itemStack) && this.componentsInventory.insertItem(itemStack)) {
            if (!itemStack.m_150930_((Item)TFMGItems.SCREWDRIVER.get())) {
                itemStack.m_41774_(1);
            }
            this.playInsertionSound();
            this.updateRotation();
            this.m_6596_();
            this.sendData();
            return true;
        }
        return false;
    }

    public List<AbstractSmallEngineBlockEntity> getEngines() {
        ArrayList<AbstractSmallEngineBlockEntity> values = new ArrayList<AbstractSmallEngineBlockEntity>();
        for (Long position : this.getAllEngines()) {
            BlockPos pos = BlockPos.m_122022_((long)position);
            BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
            if (!(blockEntity instanceof AbstractSmallEngineBlockEntity)) continue;
            AbstractSmallEngineBlockEntity be = (AbstractSmallEngineBlockEntity)blockEntity;
            values.add(be);
        }
        return values;
    }

    public boolean isController() {
        if (this.controller == null) {
            this.controller = this.m_58899_();
        }
        if (this.engineNumber == 0) {
            this.controller = this.m_58899_();
        }
        return this.controller.equals((Object)this.m_58899_());
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (this.controller.m_121878_() == this.m_58899_().m_121878_()) {
            CreateLang.text((String)"CONTROLLER").forGoggles(tooltip);
        }
        CreateLang.text((String)("Shift " + this.shift.toString())).forGoggles(tooltip);
        CreateLang.text((String)("Speed Efficiency " + this.getSpeedEfficiency())).forGoggles(tooltip);
        CreateLang.text((String)("Efficiency " + this.efficiencyModifier())).forGoggles(tooltip);
        CreateLang.text((String)("Fuel Consumption " + this.getFuelConsumption())).forGoggles(tooltip);
        CreateLang.text((String)("Rpm " + this.rpm)).forGoggles(tooltip);
        CreateLang.text((String)("length " + this.engineLength())).forGoggles(tooltip);
        CreateLang.text((String)("Torque " + this.torque)).forGoggles(tooltip);
        CreateLang.text((String)("Injection Rate " + this.fuelInjectionRate)).forGoggles(tooltip);
        CreateLang.text((String)("Signal " + this.highestSignal)).forGoggles(tooltip);
        CreateLang.number((double)this.engineNumber).style(ChatFormatting.DARK_GREEN).forGoggles(tooltip);
        if (this.isController() && !this.nextComponent().m_43947_()) {
            CreateLang.text((String)this.nextComponent().m_43908_()[0].m_41611_().getString()).forGoggles(tooltip);
        }
        TFMGUtils.createFluidTooltip((BlockEntity)this, tooltip);
        return true;
    }

    public boolean isUpgradeFirst(EngineUpgrade itemUpgrade) {
        for (AbstractSmallEngineBlockEntity be : this.getEngines()) {
            if (!be.upgrade.isPresent() || be.upgrade.get().getItem() != itemUpgrade.getItem()) continue;
            return false;
        }
        return true;
    }

    public List<Long> getAllEngines() {
        ArrayList<Long> list = new ArrayList<Long>(this.engines);
        list.add(this.controller.m_121878_());
        return list;
    }

    public AbstractSmallEngineBlockEntity getControllerBE() {
        if (this.isController()) {
            return this;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.controller);
        if (blockEntity instanceof AbstractSmallEngineBlockEntity) {
            return (AbstractSmallEngineBlockEntity)blockEntity;
        }
        return this;
    }

    @Override
    public void tick() {
        this.upgrade.ifPresent(engineUpgrade -> engineUpgrade.tickUpgrade(this));
        if (this.connectNextTick && this.isController()) {
            this.connect();
            this.connectNextTick = false;
        }
        super.tick();
    }

    public void connect() {
        AbstractSmallEngineBlockEntity be;
        Direction facing = (Direction)this.m_58900_().m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING);
        Direction updateDirection = facing.m_122424_();
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(facing));
        if (blockEntity instanceof AbstractSmallEngineBlockEntity && (be = (AbstractSmallEngineBlockEntity)blockEntity).m_58900_().m_60734_() == this.m_58900_().m_60734_() && be.m_58900_().m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING) == this.m_58900_().m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING)) {
            be.connect();
            return;
        }
        this.engines = new ArrayList<Long>();
        for (int i = 0; i < this.getMaxLength(); ++i) {
            BlockPos pos = this.m_58899_().m_5484_(updateDirection, i);
            BlockEntity blockEntity2 = this.f_58857_.m_7702_(pos);
            if (blockEntity2 instanceof AbstractSmallEngineBlockEntity) {
                AbstractSmallEngineBlockEntity be2 = (AbstractSmallEngineBlockEntity)blockEntity2;
                if (be2.m_58900_().m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING) != facing) {
                    return;
                }
                this.f_58857_.m_7731_(be2.m_58899_(), (BlockState)be2.m_58900_().m_61124_(EngineBlock.SHAFT_FACING, (Comparable)(be2.m_58899_() == this.m_58899_() ? facing : updateDirection)), 2);
                be2.detashEngines();
                this.engines.add(pos.m_121878_());
                be2.engineNumber = i;
                be2.engines = new ArrayList<Long>();
                be2.controller = this.m_58899_();
                be2.refreshCapability();
                this.setBlockStates(be2, null);
                this.updateGeneratedRotation();
                this.onUpdated();
                be2.sendData();
                be2.m_6596_();
                if (be2.m_58900_().m_61143_(EngineBlock.ENGINE_STATE) != EngineBlock.EngineState.NORMAL && i != 0) {
                    this.setBlockStates(this, this.m_58899_().m_5484_(updateDirection, i - 1));
                    break;
                }
                if (i != this.getMaxLength() - 1) continue;
                this.setBlockStates(this, this.m_58899_().m_5484_(updateDirection, i));
                continue;
            }
            this.setBlockStates(this, this.m_58899_().m_5484_(updateDirection, i - 1));
            return;
        }
        this.updateGeneratedRotation();
        this.updateRotation();
        this.m_6596_();
        this.sendData();
    }

    @Override
    public void remove() {
        super.remove();
        this.updateOthers();
        for (int i = 0; i < this.componentsInventory.getSlots(); ++i) {
            ItemStack stack = this.componentsInventory.m_8020_(i);
            this.dropItem(stack);
        }
    }

    public void updateOthers() {
        if (!this.isController()) {
            this.getControllerBE().connectNextTick = true;
        }
        Direction facing = (Direction)this.m_58900_().m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING);
        for (Direction direction : Direction.values()) {
            BlockEntity blockEntity;
            if (direction.m_122434_() != facing.m_122434_() || !((blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(direction))) instanceof AbstractSmallEngineBlockEntity)) continue;
            AbstractSmallEngineBlockEntity be = (AbstractSmallEngineBlockEntity)blockEntity;
            this.f_58857_.m_46597_(be.m_58899_(), (BlockState)be.m_58900_().m_61124_(EngineBlock.SHAFT_FACING, (Comparable)direction.m_122424_()));
            be.delayedConnect = true;
            be.connectNextTick = true;
            be.connect();
        }
    }

    public float getUpgradeSpeedModifier() {
        float modifier = 1.0f;
        for (AbstractSmallEngineBlockEntity be : this.getEngines()) {
            if (!be.upgrade.isPresent()) continue;
            modifier *= be.upgrade.get().getSpeedModifier(this);
        }
        return modifier;
    }

    public float getUpgradeTorqueModifier() {
        float modifier = 1.0f;
        for (AbstractSmallEngineBlockEntity be : this.getEngines()) {
            if (!be.upgrade.isPresent()) continue;
            modifier *= be.upgrade.get().getTorqueModifier(this);
        }
        return modifier;
    }

    public float getUpgradeEfficiencyModifier() {
        float modifier = 1.0f;
        for (AbstractSmallEngineBlockEntity be : this.getEngines()) {
            if (!be.upgrade.isPresent()) continue;
            modifier *= be.upgrade.get().getEfficiencyModifier(this);
        }
        return modifier;
    }
}

