/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.oil_processing.pumpjack.pumpjack.base;

import com.drmangotea.tfmg.TFMG;
import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.config.TFMGConfigs;
import com.drmangotea.tfmg.content.machinery.oil_processing.pumpjack.pumpjack.base.TestSavedDataManager;
import com.drmangotea.tfmg.content.machinery.oil_processing.pumpjack.pumpjack.crank.PumpjackCrankBlockEntity;
import com.drmangotea.tfmg.content.machinery.oil_processing.pumpjack.pumpjack.hammer.PumpjackBlockEntity;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.drmangotea.tfmg.registry.TFMGFluids;
import com.drmangotea.tfmg.registry.TFMGTags;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class PumpjackBaseBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    public PumpjackBlockEntity controllerHammer;
    public boolean isRunning = false;
    int depositCheckTimer = 0;
    public int miningRate = 0;
    protected LazyOptional<IFluidHandler> fluidCapability;
    public FluidTank tank = this.createInventory();
    public BlockPos deposit;

    public PumpjackBaseBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.fluidCapability = LazyOptional.of(() -> this.tank);
    }

    public void tick() {
        super.tick();
        if (this.controllerHammer != null && !(this.f_58857_.m_7702_(this.controllerHammer.m_58899_()) instanceof PumpjackBlockEntity)) {
            this.controllerHammer = null;
        }
        if (this.controllerHammer != null && this.controllerHammer.base == null) {
            this.controllerHammer = null;
        }
        if (this.controllerHammer != null && !this.controllerHammer.isRunning()) {
            this.controllerHammer = null;
        }
        if (this.controllerHammer == null) {
            return;
        }
        this.isRunning = this.controllerHammer.isRunning();
        if (!this.isRunning) {
            this.deposit = null;
            this.controllerHammer = null;
            this.miningRate = 0;
            return;
        }
        ++this.depositCheckTimer;
        if (this.depositCheckTimer > 50) {
            this.depositCheckTimer = 0;
            this.findDeposit();
        }
        PumpjackCrankBlockEntity crank = null;
        if (this.controllerHammer.crank != null) {
            crank = this.controllerHammer.crank;
        }
        if (crank == null) {
            return;
        }
        this.miningRate = (int)Math.abs(crank.getMachineInputSpeed() * crank.heightModifier);
        this.process();
    }

    public void lazyTick() {
        super.lazyTick();
    }

    public void findDeposit() {
        for (int i = 0; i < this.m_58899_().m_123342_() + 64; ++i) {
            BlockPos checkedPos = new BlockPos(this.m_58899_().m_123341_(), this.m_58899_().m_123342_() - 1 - i, this.m_58899_().m_123343_());
            if (this.f_58857_.m_8055_(new BlockPos((Vec3i)checkedPos)).m_60713_((Block)TFMGBlocks.OIL_DEPOSIT.get())) {
                this.deposit = checkedPos;
                return;
            }
            if (this.f_58857_.m_8055_(new BlockPos((Vec3i)checkedPos)).m_204336_(TFMGTags.TFMGBlockTags.INDUSTRIAL_PIPE.tag)) continue;
            this.deposit = null;
            return;
        }
        this.deposit = null;
    }

    public void process() {
        if (this.deposit == null) {
            return;
        }
        if (!this.f_58857_.f_46443_) {
            if (!TestSavedDataManager.containsDeposit(this.deposit.m_121878_())) {
                TFMG.DEPOSITS.addDeposit(this.f_58857_, this.deposit.m_121878_());
                TFMG.DEPOSITS.markDirty();
                this.sendData();
            }
        }
        if (this.tank.getFluidAmount() + this.miningRate > this.tank.getCapacity()) {
            return;
        }
        int amountPumped = this.tank.fill(new FluidStack((Fluid)TFMGFluids.CRUDE_OIL.getSource(), this.miningRate), IFluidHandler.FluidAction.EXECUTE);
        this.sendData();
        if (amountPumped == 0) {
            return;
        }
        if (((Boolean)TFMGConfigs.common().worldgen.infiniteDeposits.get()).booleanValue()) {
            return;
        }
        RandomSource randomSource = this.f_58857_.m_213780_();
    }

    public void setControllerHammer(PumpjackBlockEntity controllerHammer) {
        this.controllerHammer = controllerHammer;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    protected SmartFluidTank createInventory() {
        return new SmartFluidTank(8000, this::onFluidStackChanged){

            public boolean isFluidValid(FluidStack stack) {
                return stack.getFluid().m_6212_((Fluid)TFMGFluids.CRUDE_OIL.getSource());
            }
        };
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        this.sendData();
        this.m_6596_();
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        CreateLang.translate((String)"goggles.pumpjack_info", (Object[])new Object[0]).forGoggles(tooltip);
        if (this.deposit == null) {
            CreateLang.translate((String)"goggles.zero", (Object[])new Object[0]).style(ChatFormatting.DARK_RED).forGoggles(tooltip, 1);
        }
        TFMGUtils.createFluidTooltip((BlockEntity)this, tooltip);
        return true;
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.tank.readFromNBT(compound.m_128469_("TankContent"));
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128365_("TankContent", (Tag)this.tank.writeToNBT(new CompoundTag()));
        super.write(compound, clientPacket);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }
}

