/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.reg;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.mehvahdjukaar.moonlight.api.client.CoreShaderContainer;
import net.mehvahdjukaar.moonlight.api.client.model.CustomModelLoader;
import net.mehvahdjukaar.moonlight.api.client.model.NestedModelLoader;
import net.mehvahdjukaar.moonlight.api.client.renderer.FallingBlockRendererGeneric;
import net.mehvahdjukaar.moonlight.api.item.IItemDecoratorRenderer;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.BlackboardManager;
import net.mehvahdjukaar.supplementaries.client.GlobeManager;
import net.mehvahdjukaar.supplementaries.client.MobHeadShadersManager;
import net.mehvahdjukaar.supplementaries.client.block_models.AwningModelLoader;
import net.mehvahdjukaar.supplementaries.client.block_models.BlackboardBakedModel;
import net.mehvahdjukaar.supplementaries.client.block_models.BookPileModel;
import net.mehvahdjukaar.supplementaries.client.block_models.BuntingsBakedModel;
import net.mehvahdjukaar.supplementaries.client.block_models.FaucetModelLoader;
import net.mehvahdjukaar.supplementaries.client.block_models.FlowerBoxBakedModel;
import net.mehvahdjukaar.supplementaries.client.block_models.FrameBlockBakedModel;
import net.mehvahdjukaar.supplementaries.client.block_models.GobletModelLoader;
import net.mehvahdjukaar.supplementaries.client.block_models.JarModelLoader;
import net.mehvahdjukaar.supplementaries.client.block_models.RopeKnotBlockBakedModel;
import net.mehvahdjukaar.supplementaries.client.block_models.SignPostBlockBakedModel;
import net.mehvahdjukaar.supplementaries.client.particles.BombExplosionEmitterParticle;
import net.mehvahdjukaar.supplementaries.client.particles.BombExplosionParticle;
import net.mehvahdjukaar.supplementaries.client.particles.BombSmokeParticle;
import net.mehvahdjukaar.supplementaries.client.particles.BottlingXpParticle;
import net.mehvahdjukaar.supplementaries.client.particles.BubbleBlockParticle;
import net.mehvahdjukaar.supplementaries.client.particles.CannonFireParticle;
import net.mehvahdjukaar.supplementaries.client.particles.ConfettiParticle;
import net.mehvahdjukaar.supplementaries.client.particles.DrippingLiquidParticle;
import net.mehvahdjukaar.supplementaries.client.particles.FallingLiquidParticle;
import net.mehvahdjukaar.supplementaries.client.particles.FeatherParticle;
import net.mehvahdjukaar.supplementaries.client.particles.RotationTrailEmitter;
import net.mehvahdjukaar.supplementaries.client.particles.RotationTrailParticle;
import net.mehvahdjukaar.supplementaries.client.particles.SlingshotParticle;
import net.mehvahdjukaar.supplementaries.client.particles.SparkleParticle;
import net.mehvahdjukaar.supplementaries.client.particles.SpeakerSoundParticle;
import net.mehvahdjukaar.supplementaries.client.particles.StasisParticle;
import net.mehvahdjukaar.supplementaries.client.particles.StreamerParticle;
import net.mehvahdjukaar.supplementaries.client.particles.SudsParticle;
import net.mehvahdjukaar.supplementaries.client.particles.SugarParticle;
import net.mehvahdjukaar.supplementaries.client.particles.WindTrailParticle;
import net.mehvahdjukaar.supplementaries.client.renderers.color.CogBlockColor;
import net.mehvahdjukaar.supplementaries.client.renderers.color.DefaultWaterColor;
import net.mehvahdjukaar.supplementaries.client.renderers.color.FlowerBoxColor;
import net.mehvahdjukaar.supplementaries.client.renderers.color.FluidColor;
import net.mehvahdjukaar.supplementaries.client.renderers.color.GunpowderBlockColor;
import net.mehvahdjukaar.supplementaries.client.renderers.color.MimicBlockColor;
import net.mehvahdjukaar.supplementaries.client.renderers.color.TippedSpikesColor;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.CannonballRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.HatStandRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.ImprovedThrownItemRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.RedMerchantRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.RopeArrowRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.SlingshotProjectileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.funny.JarredHeadLayer;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.funny.JarredModel;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.funny.PickleModel;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.layers.PartyHatLayer;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.models.EndermanSkullModel;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.models.HatStandModel;
import net.mehvahdjukaar.supplementaries.client.renderers.items.ProjectileWeaponOverlayRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.items.SelectableItemOverlayRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.items.SlingshotItemOverlayRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.BellowsBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.BlackboardBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.BookPileBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.BubbleBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.BuntingBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.CageBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.CannonBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.ClockBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.DoormatBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.EndermanSkullBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.FlagBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.GlobeBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.HourGlassBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.ItemShelfBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.JarBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.JarBoatTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.NoticeBoardBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.PedestalBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.SignPostBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.SlidyBlockRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.SpringLauncherArmBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.StatueBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.WindVaneBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.screens.CannonScreen;
import net.mehvahdjukaar.supplementaries.client.screens.NoticeBoardScreen;
import net.mehvahdjukaar.supplementaries.client.screens.PresentScreen;
import net.mehvahdjukaar.supplementaries.client.screens.PulleyScreen;
import net.mehvahdjukaar.supplementaries.client.screens.RedMerchantScreen;
import net.mehvahdjukaar.supplementaries.client.screens.TrappedPresentScreen;
import net.mehvahdjukaar.supplementaries.client.screens.VariableSizeContainerScreen;
import net.mehvahdjukaar.supplementaries.client.tooltip.BannerPatternTooltipComponent;
import net.mehvahdjukaar.supplementaries.client.tooltip.BlackboardTooltipComponent;
import net.mehvahdjukaar.supplementaries.client.tooltip.PaintingTooltipComponent;
import net.mehvahdjukaar.supplementaries.client.tooltip.QuiverTooltipComponent;
import net.mehvahdjukaar.supplementaries.client.tooltip.SherdTooltipComponent;
import net.mehvahdjukaar.supplementaries.common.block.placeable_book.PlaceableBookManager;
import net.mehvahdjukaar.supplementaries.common.block.tiles.TrappedPresentBlockTile;
import net.mehvahdjukaar.supplementaries.common.items.AntiqueInkItem;
import net.mehvahdjukaar.supplementaries.common.items.BuntingItem;
import net.mehvahdjukaar.supplementaries.common.items.SlingshotItem;
import net.mehvahdjukaar.supplementaries.common.items.tooltip_components.BannerPatternTooltip;
import net.mehvahdjukaar.supplementaries.common.items.tooltip_components.PaintingTooltip;
import net.mehvahdjukaar.supplementaries.common.items.tooltip_components.SelectableContainerTooltip;
import net.mehvahdjukaar.supplementaries.common.items.tooltip_components.SherdTooltip;
import net.mehvahdjukaar.supplementaries.common.misc.map_markers.client.ModMapMarkersClient;
import net.mehvahdjukaar.supplementaries.common.utils.FlowerPotHandler;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.integration.AmendmentsCompat;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.CompatHandlerClient;
import net.mehvahdjukaar.supplementaries.reg.ModEntities;
import net.mehvahdjukaar.supplementaries.reg.ModFluids;
import net.mehvahdjukaar.supplementaries.reg.ModMenuTypes;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.inventory.ShulkerBoxScreen;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.FlameParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SnowflakeParticle;
import net.minecraft.client.particle.SplashParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.FallingBlockRenderer;
import net.minecraft.client.renderer.entity.MinecartRenderer;
import net.minecraft.client.renderer.entity.NoopRenderer;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class ClientRegistry {
    public static final ResourceLocation RAGE_SHADER = Supplementaries.res("shaders/post/rage.json");
    public static final String BARBARIC_RAGE_SHADER = Supplementaries.res("shaders/post/barbaric_rage.json").toString();
    public static final ResourceLocation FLARE_SHADER = Supplementaries.res("shaders/post/flare.json");
    public static final ResourceLocation GLITTER_SHADER = Supplementaries.res("shaders/post/glitter.json");
    public static final ResourceLocation BLACK_AND_WHITE_SHADER = Supplementaries.res("shaders/post/black_and_white.json");
    public static final ResourceLocation VANILLA_DESATURATE_SHADER = new ResourceLocation("shaders/post/desaturate.json");
    public static final CoreShaderContainer ENTITY_OFFSET_SHADER = new CoreShaderContainer(GameRenderer::m_172664_);
    public static final CoreShaderContainer NOISE_SHADER = new CoreShaderContainer(GameRenderer::m_172661_);
    public static final CoreShaderContainer SPHERE_SHADER = new CoreShaderContainer(GameRenderer::m_172661_);
    public static final ModelLayerLocation BELLOWS_MODEL = ClientRegistry.loc("bellows");
    public static final ModelLayerLocation CLOCK_HANDS_MODEL = ClientRegistry.loc("clock_hands");
    public static final ModelLayerLocation GLOBE_BASE_MODEL = ClientRegistry.loc("globe");
    public static final ModelLayerLocation GLOBE_SPECIAL_MODEL = ClientRegistry.loc("globe_special");
    public static final ModelLayerLocation RED_MERCHANT_MODEL = ClientRegistry.loc("red_merchant");
    public static final ModelLayerLocation HAT_STAND_MODEL = ClientRegistry.loc("hat_stand");
    public static final ModelLayerLocation CANNONBALL_MODEL = ClientRegistry.loc("cannonball");
    public static final ModelLayerLocation HAT_STAND_MODEL_ARMOR = ClientRegistry.loc("hat_stand_armor");
    public static final ModelLayerLocation JARVIS_MODEL = ClientRegistry.loc("jarvis");
    public static final ModelLayerLocation JAR_MODEL = ClientRegistry.loc("jar");
    public static final ModelLayerLocation PICKLE_MODEL = ClientRegistry.loc("pickle");
    public static final ModelLayerLocation ENDERMAN_HEAD_MODEL = ClientRegistry.loc("enderman_head");
    public static final ModelLayerLocation PARTY_CREEPER_MODEL = ClientRegistry.loc("party_creeper");
    public static final ModelLayerLocation CANNON_MODEL = ClientRegistry.loc("cannon");
    public static final ModelLayerLocation WIND_VANE_MODEL = ClientRegistry.loc("wind_vane");
    public static final ModelLayerLocation BUNTING_MODEL = ClientRegistry.loc("bunting");
    public static final ResourceLocation FLUTE_3D_MODEL = Supplementaries.res("item/flute_in_hand");
    public static final ResourceLocation FLUTE_2D_MODEL = Supplementaries.res("item/flute_gui");
    public static final ResourceLocation QUIVER_3D_MODEL = Supplementaries.res("item/quiver_in_hand_dyed");
    public static final ResourceLocation QUIVER_2D_MODEL = Supplementaries.res("item/quiver_gui_dyed");
    public static final ResourceLocation ALTIMETER_TEMPLATE = Supplementaries.res("item/altimeter_template");
    public static final ResourceLocation ALTIMETER_OVERLAY = Supplementaries.res("item/altimeter_overlay");
    public static final ResourceLocation LUNCH_BOX_ITEM_MODEL = Supplementaries.res("item/lunch_basket_gui");
    public static final ResourceLocation LUNCH_BOX_OPEN_ITEM_MODEL = Supplementaries.res("item/lunch_basket_gui_open");
    public static final ResourceLocation BOAT_MODEL = Supplementaries.res("block/jar_boat_ship");
    public static final ResourceLocation BLACKBOARD_FRAME = Supplementaries.res("block/blackboard_frame");
    public static final Supplier<Map<WoodType, ResourceLocation>> SIGN_POST_MODELS = Suppliers.memoize(() -> WoodTypeRegistry.getTypes().stream().collect(Collectors.toMap(Function.identity(), w -> Supplementaries.res("block/sign_posts/" + w.getVariantId("sign_post")))));
    public static final KeyMapping QUIVER_KEYBIND = new KeyMapping("supplementaries.keybind.quiver", InputConstants.Type.KEYSYM, InputConstants.m_84851_((String)"key.keyboard.v").m_84873_(), "supplementaries.gui.controls");

    private static ModelLayerLocation loc(String name) {
        return new ModelLayerLocation(Supplementaries.res(name), name);
    }

    public static void init() {
        CompatHandlerClient.init();
        ClientHelper.addClientSetup(ClientRegistry::setup);
        ClientHelper.addClientReloadListener(() -> MobHeadShadersManager.INSTANCE, (ResourceLocation)Supplementaries.res("mob_head_effects"));
        ClientHelper.addEntityRenderersRegistration(ClientRegistry::registerEntityRenderers);
        ClientHelper.addBlockEntityRenderersRegistration(ClientRegistry::registerBlockEntityRenderers);
        ClientHelper.addBlockColorsRegistration(ClientRegistry::registerBlockColors);
        ClientHelper.addItemColorsRegistration(ClientRegistry::registerItemColors);
        ClientHelper.addParticleRegistration(ClientRegistry::registerParticles);
        ClientHelper.addModelLayerRegistration(ClientRegistry::registerModelLayers);
        ClientHelper.addSpecialModelRegistration(ClientRegistry::registerSpecialModels);
        ClientHelper.addTooltipComponentRegistration(ClientRegistry::registerTooltipComponent);
        ClientHelper.addModelLoaderRegistration(ClientRegistry::registerModelLoaders);
        ClientHelper.addItemDecoratorsRegistration(ClientRegistry::registerItemDecorators);
        ClientHelper.addKeyBindRegistration(ClientRegistry::registerKeyBinds);
        ClientHelper.addShaderRegistration(ClientRegistry::registerShaders);
    }

    public static void setup() {
        CompatHandlerClient.setup();
        ModMapMarkersClient.init();
        MenuScreens.m_96206_(ModMenuTypes.PULLEY_BLOCK.get(), PulleyScreen::new);
        MenuScreens.m_96206_(ModMenuTypes.VARIABLE_SIZE.get(), VariableSizeContainerScreen::new);
        MenuScreens.m_96206_(ModMenuTypes.SAFE.get(), ShulkerBoxScreen::new);
        MenuScreens.m_96206_(ModMenuTypes.PRESENT_BLOCK.get(), PresentScreen::new);
        MenuScreens.m_96206_(ModMenuTypes.TRAPPED_PRESENT_BLOCK.get(), TrappedPresentScreen::new);
        MenuScreens.m_96206_(ModMenuTypes.NOTICE_BOARD.get(), NoticeBoardScreen::new);
        MenuScreens.m_96206_(ModMenuTypes.CANNON.get(), CannonScreen::new);
        MenuScreens.m_96206_(ModMenuTypes.RED_MERCHANT.get(), RedMerchantScreen::new);
        ClientHelper.registerRenderType((Block)ModRegistry.WIND_VANE.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModRegistry.FIRE_PIT.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)((Block)ModRegistry.BUNTING_BLOCK.get()), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModRegistry.BOOK_PILE.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModRegistry.BOOK_PILE_H.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModRegistry.GLOBE.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModRegistry.GLOBE_SEPIA.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModRegistry.CRANK.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModRegistry.SIGN_POST.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModRegistry.BELLOWS.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModRegistry.SCONCE_WALL.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModRegistry.SCONCE.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModRegistry.SCONCE_WALL_SOUL.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModRegistry.SCONCE_SOUL.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModRegistry.SCONCE_WALL_GREEN.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModRegistry.SCONCE_GREEN.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModRegistry.ITEM_SHELF.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModRegistry.CAGE.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModRegistry.SCONCE_LEVER.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModRegistry.HOURGLASS.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModRegistry.BLACKBOARD.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModRegistry.GOLD_DOOR.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModRegistry.GOLD_TRAPDOOR.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModRegistry.BAMBOO_SPIKES.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModRegistry.NETHERITE_DOOR.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModRegistry.NETHERITE_TRAPDOOR.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)((Block)ModRegistry.ROPE.get()), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModRegistry.FLAX.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModRegistry.FLAX_WILD.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModRegistry.FLAX_POT.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModRegistry.JAR_BOAT.get(), (RenderType)RenderType.m_110466_());
        ClientHelper.registerRenderType((Block)ModRegistry.GOBLET.get(), (RenderType[])new RenderType[]{RenderType.m_110466_(), RenderType.m_110463_()});
        ClientHelper.registerRenderType((Block)ModRegistry.FAUCET.get(), (RenderType[])new RenderType[]{RenderType.m_110466_(), RenderType.m_110463_()});
        ClientHelper.registerRenderType((Block)ModRegistry.JAR.get(), (RenderType[])new RenderType[]{RenderType.m_110466_(), RenderType.m_110463_()});
        ClientHelper.registerRenderType((Block)ModRegistry.FLOWER_BOX.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)((Block)ModRegistry.TIMBER_FRAME.get()), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)((Block)ModRegistry.TIMBER_BRACE.get()), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)((Block)ModRegistry.TIMBER_CROSS_BRACE.get()), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModRegistry.COG_BLOCK.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModRegistry.IRON_GATE.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModRegistry.GOLD_GATE.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModRegistry.GUNPOWDER_BLOCK.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModRegistry.CANNON.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModRegistry.ROPE_KNOT.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModRegistry.LUNCH_BASKET.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModRegistry.CRYSTAL_DISPLAY.get(), (RenderType)RenderType.m_110463_());
        ModRegistry.CANDLE_HOLDERS.values().forEach(c -> ClientHelper.registerRenderType((Block)((Block)c.get()), (RenderType)RenderType.m_110463_()));
        ModRegistry.AWNINGS.values().forEach(c -> ClientHelper.registerRenderType((Block)((Block)c.get()), (RenderType)RenderType.m_110463_()));
        ClientHelper.registerRenderType((Block)((Block)ModFluids.LUMISENE_BLOCK.get()), (RenderType)RenderType.m_110463_());
        ClientHelper.registerFluidRenderType((Fluid)ModFluids.LUMISENE_FLUID.get(), (RenderType)RenderType.m_110466_());
        ItemProperties.m_174570_((Item)Items.f_42717_, (ResourceLocation)Supplementaries.res("rope_arrow"), (ClampedItemPropertyFunction)new CrossbowProperty(ModRegistry.ROPE_ARROW_ITEM.get()));
        ClampedItemPropertyFunction antiqueProp = (itemStack, clientLevel, livingEntity, i) -> AntiqueInkItem.hasAntiqueInk(itemStack) ? 1.0f : 0.0f;
        ItemProperties.m_174570_((Item)Items.f_42615_, (ResourceLocation)Supplementaries.res("antique_ink"), (ClampedItemPropertyFunction)antiqueProp);
        ItemProperties.m_174570_((Item)Items.f_42573_, (ResourceLocation)Supplementaries.res("antique_ink"), (ClampedItemPropertyFunction)antiqueProp);
        ItemProperties.m_174570_((Item)ModRegistry.SLINGSHOT_ITEM.get(), (ResourceLocation)Supplementaries.res("pull"), (stack, world, entity, s) -> {
            if (entity == null || entity.m_21211_() != stack) {
                return 0.0f;
            }
            return (float)(stack.m_41779_() - entity.m_21212_()) / (float)SlingshotItem.getChargeDuration(stack);
        });
        ItemProperties.m_174570_((Item)ModRegistry.SLINGSHOT_ITEM.get(), (ResourceLocation)Supplementaries.res("pulling"), (stack, world, entity, s) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f);
        ItemProperties.m_174570_((Item)ModRegistry.BUBBLE_BLOWER.get(), (ResourceLocation)Supplementaries.res("using"), (stack, world, entity, s) -> entity != null && entity.m_6117_() && ForgeHelper.areStacksEqual((ItemStack)stack, (ItemStack)entity.m_21211_(), (boolean)true) ? 1.0f : 0.0f);
        ModRegistry.PRESENTS.values().forEach(i -> ItemProperties.m_174570_((Item)((Block)i.get()).m_5456_(), (ResourceLocation)Supplementaries.res("packed"), (stack, world, entity, s) -> 1.0f));
        ModRegistry.TRAPPED_PRESENTS.values().forEach(i -> ItemProperties.m_174570_((Item)((Block)i.get()).m_5456_(), (ResourceLocation)Supplementaries.res("primed"), (stack, world, entity, s) -> TrappedPresentBlockTile.isPrimed(stack) ? 1.0f : 0.0f));
        ItemProperties.m_174570_((Item)ModRegistry.CANDY_ITEM.get(), (ResourceLocation)Supplementaries.res("wrapping"), (stack, world, entity, s) -> MiscUtils.FESTIVITY.getCandyWrappingIndex());
        ItemProperties.m_174570_((Item)ModRegistry.QUIVER_ITEM.get(), (ResourceLocation)Supplementaries.res("dyed"), (stack, world, entity, s) -> ((DyeableLeatherItem)stack.m_41720_()).m_41113_(stack) ? 1.0f : 0.0f);
        ItemProperties.m_174570_((Item)ModRegistry.GLOBE_ITEM.get(), (ResourceLocation)Supplementaries.res("type"), (ClampedItemPropertyFunction)new GlobeProperty());
        ItemProperties.m_174570_((Item)ModRegistry.BUNTING.get(), (ResourceLocation)Supplementaries.res("dye"), (stack, world, entity, s) -> (float)BuntingItem.getColor(stack).m_41060_() / 100.0f);
    }

    private static void registerKeyBinds(ClientHelper.KeyBindEvent event) {
        event.register(QUIVER_KEYBIND);
    }

    private static void registerParticles(ClientHelper.ParticleEvent event) {
        event.register((ParticleType)ModParticles.SPEAKER_SOUND.get(), SpeakerSoundParticle.Factory::new);
        event.register((ParticleType)ModParticles.GREEN_FLAME.get(), FlameParticle.Provider::new);
        event.register((ParticleType)ModParticles.DRIPPING_LIQUID.get(), DrippingLiquidParticle.Factory::new);
        event.register((ParticleType)ModParticles.FALLING_LIQUID.get(), FallingLiquidParticle.Factory::new);
        event.register((ParticleType)ModParticles.SPLASHING_LIQUID.get(), ColoredSplashingParticle::new);
        event.register((ParticleType)ModParticles.BOMB_EXPLOSION_PARTICLE.get(), BombExplosionParticle.Factory::new);
        event.register((ParticleType)ModParticles.BOMB_EXPLOSION_PARTICLE_EMITTER.get(), BombExplosionEmitterParticle.Factory::new);
        event.register((ParticleType)ModParticles.BOMB_SMOKE_PARTICLE.get(), BombSmokeParticle.Factory::new);
        event.register((ParticleType)ModParticles.BOTTLING_XP_PARTICLE.get(), BottlingXpParticle.Factory::new);
        event.register((ParticleType)ModParticles.SPARKLE_PARTICLE.get(), SparkleParticle.Factory::new);
        event.register((ParticleType)ModParticles.FEATHER_PARTICLE.get(), FeatherParticle.Factory::new);
        event.register((ParticleType)ModParticles.SLINGSHOT_PARTICLE.get(), SlingshotParticle.Factory::new);
        event.register((ParticleType)ModParticles.STASIS_PARTICLE.get(), StasisParticle.Factory::new);
        event.register((ParticleType)ModParticles.CONFETTI_PARTICLE.get(), ConfettiParticle.Factory::new);
        event.register((ParticleType)ModParticles.STREAMER_PARTICLE.get(), StreamerParticle.Factory::new);
        event.register((ParticleType)ModParticles.WIND_STREAM.get(), WindTrailParticle.Factory::new);
        event.register((ParticleType)ModParticles.ROTATION_TRAIL.get(), RotationTrailParticle.Factory::new);
        event.register((ParticleType)ModParticles.ROTATION_TRAIL_EMITTER.get(), RotationTrailEmitter.Factory::new);
        event.register((ParticleType)ModParticles.SUDS_PARTICLE.get(), SudsParticle.Factory::new);
        event.register((ParticleType)ModParticles.ASH_PARTICLE.get(), AshParticleFactory::new);
        event.register((ParticleType)ModParticles.BUBBLE_BLOCK_PARTICLE.get(), BubbleBlockParticle.Factory::new);
        event.register((ParticleType)ModParticles.SUGAR_PARTICLE.get(), SugarParticle.Factory::new);
        event.register((ParticleType)ModParticles.CANNON_FIRE_PARTICLE.get(), CannonFireParticle.Factory::new);
    }

    private static void registerEntityRenderers(ClientHelper.EntityRendererEvent event) {
        event.register(ModEntities.BOMB.get(), context -> new ImprovedThrownItemRenderer(context, 1.0f));
        event.register(ModEntities.THROWABLE_BRICK.get(), context -> new ImprovedThrownItemRenderer(context, 1.0f));
        if (!CompatHandler.AMENDMENTS || !AmendmentsCompat.has3DSlimeballRenderer()) {
            event.register(ModEntities.THROWABLE_SLIMEBALL.get(), context -> new ImprovedThrownItemRenderer(context, 1.0f));
        }
        if (ClientConfigs.Items.CANNONBALL_3D.get().booleanValue()) {
            event.register(ModEntities.CANNONBALL.get(), context -> new CannonballRenderer(context, 1.615f));
        } else {
            event.register(ModEntities.CANNONBALL.get(), context -> new ImprovedThrownItemRenderer(context, 1.615f));
        }
        event.register(ModEntities.SLINGSHOT_PROJECTILE.get(), SlingshotProjectileRenderer::new);
        event.register(ModEntities.DISPENSER_MINECART.get(), c -> new MinecartRenderer(c, ModelLayers.f_171185_));
        event.register(ModEntities.RED_MERCHANT.get(), RedMerchantRenderer::new);
        event.register(ModEntities.HAT_STAND.get(), HatStandRenderer::new);
        event.register(ModEntities.ROPE_ARROW.get(), RopeArrowRenderer::new);
        event.register(ModEntities.FALLING_URN.get(), FallingBlockRenderer::new);
        event.register(ModEntities.FALLING_ASH.get(), FallingBlockRendererGeneric::new);
        event.register(ModEntities.FALLING_SACK.get(), FallingBlockRenderer::new);
        event.register(ModEntities.PEARL_MARKER.get(), NoopRenderer::new);
    }

    private static void registerBlockEntityRenderers(ClientHelper.BlockEntityRendererEvent event) {
        event.register(ModRegistry.DOORMAT_TILE.get(), DoormatBlockTileRenderer::new);
        event.register(ModRegistry.CLOCK_BLOCK_TILE.get(), ClockBlockTileRenderer::new);
        event.register(ModRegistry.PEDESTAL_TILE.get(), PedestalBlockTileRenderer::new);
        event.register(ModRegistry.WIND_VANE_TILE.get(), WindVaneBlockTileRenderer::new);
        event.register(ModRegistry.NOTICE_BOARD_TILE.get(), NoticeBoardBlockTileRenderer::new);
        event.register(ModRegistry.JAR_TILE.get(), JarBlockTileRenderer::new);
        event.register(ModRegistry.SPRING_LAUNCHER_ARM_TILE.get(), SpringLauncherArmBlockTileRenderer::new);
        event.register(ModRegistry.SIGN_POST_TILE.get(), SignPostBlockTileRenderer::new);
        event.register(ModRegistry.BELLOWS_TILE.get(), BellowsBlockTileRenderer::new);
        event.register(ModRegistry.FLAG_TILE.get(), FlagBlockTileRenderer::new);
        event.register(ModRegistry.ITEM_SHELF_TILE.get(), ItemShelfBlockTileRenderer::new);
        event.register(ModRegistry.CAGE_TILE.get(), CageBlockTileRenderer::new);
        event.register(ModRegistry.GLOBE_TILE.get(), GlobeBlockTileRenderer::new);
        event.register(ModRegistry.HOURGLASS_TILE.get(), HourGlassBlockTileRenderer::new);
        event.register(ModRegistry.BLACKBOARD_TILE.get(), BlackboardBlockTileRenderer::new);
        event.register(ModRegistry.STATUE_TILE.get(), StatueBlockTileRenderer::new);
        event.register(ModRegistry.BOOK_PILE_TILE.get(), BookPileBlockTileRenderer::new);
        event.register(ModRegistry.JAR_BOAT_TILE.get(), JarBoatTileRenderer::new);
        event.register(ModRegistry.BUBBLE_BLOCK_TILE.get(), BubbleBlockTileRenderer::new);
        event.register(ModRegistry.ENDERMAN_SKULL_TILE.get(), EndermanSkullBlockTileRenderer::new);
        event.register(ModRegistry.CANNON_TILE.get(), CannonBlockTileRenderer::new);
        event.register(ModRegistry.BUNTING_TILE.get(), BuntingBlockTileRenderer::new);
        event.register(ModRegistry.MOVING_SLIDY_BLOCK_TILE.get(), SlidyBlockRenderer::new);
    }

    private static void registerShaders(ClientHelper.ShaderEvent event) {
        event.register(Supplementaries.res("static_noise"), DefaultVertexFormat.f_85812_, arg_0 -> ((CoreShaderContainer)NOISE_SHADER).assign(arg_0));
        event.register(Supplementaries.res("spherify"), DefaultVertexFormat.f_85812_, arg_0 -> ((CoreShaderContainer)SPHERE_SHADER).assign(arg_0));
        event.register(Supplementaries.res("entity_cutout_texture_offset"), DefaultVertexFormat.f_85812_, arg_0 -> ((CoreShaderContainer)ENTITY_OFFSET_SHADER).assign(arg_0));
    }

    private static void registerSpecialModels(ClientHelper.SpecialModelEvent event) {
        FlowerPotHandler.CUSTOM_MODELS.forEach(arg_0 -> ((ClientHelper.SpecialModelEvent)event).register(arg_0));
        SIGN_POST_MODELS.get().values().forEach(arg_0 -> ((ClientHelper.SpecialModelEvent)event).register(arg_0));
        PlaceableBookManager.getAll().forEach(b -> event.register(b.modelPath()));
        event.register(BLACKBOARD_FRAME);
        event.register(BOAT_MODEL);
        event.register(LUNCH_BOX_ITEM_MODEL);
        event.register(LUNCH_BOX_OPEN_ITEM_MODEL);
        event.register(ALTIMETER_TEMPLATE);
        event.register(ALTIMETER_OVERLAY);
        if (PlatHelper.getPlatform().isFabric()) {
            event.register(FLUTE_3D_MODEL);
            event.register(FLUTE_2D_MODEL);
            event.register(QUIVER_2D_MODEL);
            event.register(QUIVER_3D_MODEL);
        }
    }

    private static void registerModelLoaders(ClientHelper.ModelLoaderEvent event) {
        event.register(Supplementaries.res("frame_block"), (CustomModelLoader)new NestedModelLoader("overlay", FrameBlockBakedModel::new));
        event.register(Supplementaries.res("flower_box"), (CustomModelLoader)new NestedModelLoader("box", FlowerBoxBakedModel::new));
        event.register(Supplementaries.res("rope_knot"), (CustomModelLoader)new NestedModelLoader("knot", RopeKnotBlockBakedModel::new));
        event.register(Supplementaries.res("blackboard"), (CustomModelLoader)new NestedModelLoader("frame", BlackboardBakedModel::new));
        event.register(Supplementaries.res("sign_post"), SignPostBlockBakedModel::new);
        event.register(Supplementaries.res("goblet"), (CustomModelLoader)new GobletModelLoader());
        event.register(Supplementaries.res("extra_rotation"), (CustomModelLoader)new AwningModelLoader());
        event.register(Supplementaries.res("faucet"), (CustomModelLoader)new FaucetModelLoader());
        event.register(Supplementaries.res("book_pile"), BookPileModel::new);
        event.register(Supplementaries.res("bunting"), BuntingsBakedModel::new);
        event.register(Supplementaries.res("jar"), (CustomModelLoader)new JarModelLoader());
    }

    private static void registerItemDecorators(ClientHelper.ItemDecoratorEvent event) {
        event.register((ItemLike)ModRegistry.SLINGSHOT_ITEM.get(), (IItemDecoratorRenderer)new SlingshotItemOverlayRenderer());
        if (ClientConfigs.Items.QUIVER_OVERLAY.get().booleanValue()) {
            event.register((ItemLike)ModRegistry.QUIVER_ITEM.get(), (IItemDecoratorRenderer)new SelectableItemOverlayRenderer());
        }
        if (ClientConfigs.Items.LUNCH_BOX_OVERLAY.get().booleanValue()) {
            event.register((ItemLike)ModRegistry.LUNCH_BASKET_ITEM.get(), (IItemDecoratorRenderer)new SelectableItemOverlayRenderer());
        }
        if (ClientConfigs.Tweaks.PROJECTILE_WEAPON_OVERLAY.get().booleanValue()) {
            for (Item i : BuiltInRegistries.f_257033_) {
                if (!(i instanceof ProjectileWeaponItem) || i == ModRegistry.QUIVER_ITEM.get()) continue;
                event.register((ItemLike)i, (IItemDecoratorRenderer)new ProjectileWeaponOverlayRenderer());
            }
        }
    }

    private static void registerTooltipComponent(ClientHelper.TooltipComponentEvent event) {
        event.register(BlackboardManager.Key.class, BlackboardTooltipComponent::new);
        event.register(SelectableContainerTooltip.class, QuiverTooltipComponent::new);
        event.register(BannerPatternTooltip.class, BannerPatternTooltipComponent::new);
        event.register(PaintingTooltip.class, PaintingTooltipComponent::new);
        event.register(SherdTooltip.class, SherdTooltipComponent::new);
    }

    private static void registerBlockColors(ClientHelper.BlockColorEvent event) {
        event.register((BlockColor)new TippedSpikesColor(), new Block[]{ModRegistry.BAMBOO_SPIKES.get()});
        event.register((BlockColor)new DefaultWaterColor(), new Block[]{ModRegistry.JAR_BOAT.get()});
        event.register((BlockColor)new MimicBlockColor(), new Block[]{ModRegistry.SIGN_POST.get(), (Block)ModRegistry.TIMBER_BRACE.get(), (Block)ModRegistry.TIMBER_FRAME.get(), (Block)ModRegistry.TIMBER_CROSS_BRACE.get(), ModRegistry.ROPE_KNOT.get()});
        event.register((BlockColor)new CogBlockColor(), new Block[]{ModRegistry.COG_BLOCK.get()});
        event.register((BlockColor)new GunpowderBlockColor(), new Block[]{ModRegistry.GUNPOWDER_BLOCK.get()});
        event.register((BlockColor)new FlowerBoxColor(), new Block[]{ModRegistry.FLOWER_BOX.get()});
        event.register((BlockColor)new FluidColor(false), new Block[]{ModRegistry.GOBLET.get(), ModRegistry.JAR.get()});
    }

    private static void registerItemColors(ClientHelper.ItemColorEvent event) {
        event.register((ItemColor)new TippedSpikesColor(), new ItemLike[]{(ItemLike)ModRegistry.BAMBOO_SPIKES_TIPPED_ITEM.get()});
        event.register((ItemColor)new DefaultWaterColor(), new ItemLike[]{(ItemLike)ModRegistry.JAR_BOAT.get()});
        event.register((itemStack, i) -> i != 1 ? -1 : ((DyeableLeatherItem)itemStack.m_41720_()).m_41121_(itemStack), new ItemLike[]{(ItemLike)ModRegistry.QUIVER_ITEM.get()});
    }

    private static void registerModelLayers(ClientHelper.ModelLayerEvent event) {
        event.register(BELLOWS_MODEL, BellowsBlockTileRenderer::createMesh);
        event.register(CLOCK_HANDS_MODEL, ClockBlockTileRenderer::createMesh);
        event.register(GLOBE_BASE_MODEL, GlobeBlockTileRenderer::createBaseMesh);
        event.register(GLOBE_SPECIAL_MODEL, GlobeBlockTileRenderer::createSpecialMesh);
        event.register(RED_MERCHANT_MODEL, RedMerchantRenderer::createMesh);
        event.register(HAT_STAND_MODEL, HatStandModel::createMesh);
        event.register(CANNONBALL_MODEL, CannonballRenderer::createMesh);
        event.register(HAT_STAND_MODEL_ARMOR, HatStandModel::createArmorMesh);
        event.register(JARVIS_MODEL, JarredModel::createMesh);
        event.register(JAR_MODEL, JarredHeadLayer::createMesh);
        event.register(PICKLE_MODEL, PickleModel::createMesh);
        event.register(ENDERMAN_HEAD_MODEL, EndermanSkullModel::createMesh);
        event.register(PARTY_CREEPER_MODEL, PartyHatLayer::createMesh);
        event.register(CANNON_MODEL, CannonBlockTileRenderer::createMesh);
        event.register(WIND_VANE_MODEL, WindVaneBlockTileRenderer::createMesh);
        event.register(BUNTING_MODEL, BuntingBlockTileRenderer::createMesh);
    }

    public static LevelLightEngine getLightEngine() {
        return Minecraft.m_91087_().f_91073_.m_5518_();
    }

    private record CrossbowProperty(Item projectile) implements ClampedItemPropertyFunction
    {
        public float m_141951_(ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
            return entity != null && CrossbowItem.m_40932_((ItemStack)stack) && CrossbowItem.m_40871_((ItemStack)stack, (Item)this.projectile) ? 1.0f : 0.0f;
        }

        public float m_142187_(ItemStack itemStack, @Nullable ClientLevel clientLevel, @Nullable LivingEntity livingEntity, int i) {
            return 0.0f;
        }
    }

    private static class GlobeProperty
    implements ClampedItemPropertyFunction {
        private GlobeProperty() {
        }

        public float m_141951_(ItemStack itemStack, @Nullable ClientLevel clientLevel, @Nullable LivingEntity livingEntity, int i) {
            Integer v;
            String n;
            MutableComponent mutableComponent;
            CompoundTag compoundTag = itemStack.m_41737_("display");
            if (compoundTag != null && (mutableComponent = Component.Serializer.m_130701_((String)(n = compoundTag.m_128461_("Name")))) != null && (v = GlobeManager.Type.getTextureID(mutableComponent.getString())) != null) {
                return Float.valueOf(v.intValue()).floatValue();
            }
            return Float.NEGATIVE_INFINITY;
        }

        public float m_142187_(ItemStack itemStack, @Nullable ClientLevel clientLevel, @Nullable LivingEntity livingEntity, int i) {
            return this.m_141951_(itemStack, clientLevel, livingEntity, i);
        }
    }

    private static class AshParticleFactory
    extends SnowflakeParticle.Provider {
        public AshParticleFactory(SpriteSet pSprites) {
            super(pSprites);
        }

        public Particle m_6966_(SimpleParticleType pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            Particle p = super.m_6966_(pType, pLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed);
            if (p != null) {
                float yellow = pLevel.f_46441_.m_188501_() * 0.05f;
                p.m_107253_(0.42352942f + yellow, 0.40392157f + yellow, 0.40392157f);
            }
            return p;
        }
    }

    public static class ColoredSplashingParticle
    extends SplashParticle.Provider {
        public ColoredSplashingParticle(SpriteSet sprites) {
            super(sprites);
        }

        public Particle m_6966_(SimpleParticleType type, ClientLevel level, double x, double y, double z, double r, double g, double b) {
            Particle p = super.m_6966_(type, level, x, y, z, 0.0, 0.0, 0.0);
            p.m_107253_((float)r, (float)g, (float)b);
            return p;
        }
    }
}

