/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.block.entity;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import umpaz.brewinandchewin.common.BnCConfiguration;
import umpaz.brewinandchewin.common.block.KegBlock;
import umpaz.brewinandchewin.common.block.entity.container.KegItemHandler;
import umpaz.brewinandchewin.common.block.entity.container.KegMenu;
import umpaz.brewinandchewin.common.crafting.KegFermentingRecipe;
import umpaz.brewinandchewin.common.crafting.KegPouringRecipe;
import umpaz.brewinandchewin.common.registry.BnCBlockEntityTypes;
import umpaz.brewinandchewin.common.registry.BnCItems;
import umpaz.brewinandchewin.common.registry.BnCRecipeTypes;
import umpaz.brewinandchewin.common.tag.BnCTags;
import umpaz.brewinandchewin.common.utility.BnCTextUtils;
import umpaz.brewinandchewin.common.utility.KegRecipeWrapper;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;
import vectorwing.farmersdelight.common.mixin.accessor.RecipeManagerAccessor;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public class KegBlockEntity
extends SyncedBlockEntity
implements MenuProvider,
Nameable,
RecipeHolder {
    public static final int CONTAINER_SLOT = 4;
    public static final int OUTPUT_SLOT = 5;
    public static final int INVENTORY_SIZE = 6;
    public static final int RANGE = 2;
    private final ItemStackHandler inventory = this.createHandler();
    private final LazyOptional<IItemHandler> inputHandler = LazyOptional.of(() -> new KegItemHandler((IItemHandler)this.inventory, Direction.UP));
    private final LazyOptional<IItemHandler> outputHandler = LazyOptional.of(() -> new KegItemHandler((IItemHandler)this.inventory, Direction.DOWN));
    private final FluidTank fluidTank = this.createFluidTank();
    private final LazyOptional<FluidTank> fluidTankHandler = LazyOptional.of(() -> this.fluidTank);
    private final KegRecipeWrapper recipeWrapper;
    private int fermentTime;
    private int fermentTimeTotal;
    private Component customName;
    public int kegTemperature;
    protected final ContainerData kegData = this.createIntArray();
    private final Object2IntOpenHashMap<ResourceLocation> usedRecipeTracker = new Object2IntOpenHashMap();
    private ResourceLocation lastRecipeID;
    private boolean checkNewRecipe = true;

    public KegBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BnCBlockEntityTypes.KEG.get(), pos, state);
        this.recipeWrapper = new KegRecipeWrapper((IItemHandlerModifiable)this.inventory, (IFluidHandler)this.fluidTank);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        this.fluidTank.readFromNBT(compound.m_128469_("FluidTank"));
        this.fermentTime = compound.m_128451_("FermentTime");
        this.fermentTimeTotal = compound.m_128451_("FermentTimeTotal");
        if (compound.m_128425_("CustomName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)compound.m_128461_("CustomName"));
        }
        CompoundTag compoundRecipes = compound.m_128469_("RecipesUsed");
        for (String key : compoundRecipes.m_128431_()) {
            this.usedRecipeTracker.put((Object)new ResourceLocation(key), compoundRecipes.m_128451_(key));
        }
        this.checkNewRecipe = true;
    }

    public static FluidStack getMealFromItem(ItemStack kegStack) {
        if (!kegStack.m_150930_((Item)BnCItems.KEG.get())) {
            return FluidStack.EMPTY;
        }
        CompoundTag compound = kegStack.m_41737_("BlockEntityTag");
        if (compound != null && compound.m_128441_("FluidTank")) {
            return FluidStack.loadFluidStackFromNBT((CompoundTag)compound.m_128469_("FluidTank"));
        }
        return FluidStack.EMPTY;
    }

    public FluidStack getOutput() {
        return this.fluidTank.getFluid();
    }

    public CompoundTag writeMeal(CompoundTag compound) {
        if (this.getOutput().isEmpty()) {
            return compound;
        }
        ItemStackHandler drops = new ItemStackHandler(6);
        for (int i = 0; i < 6; ++i) {
            drops.setStackInSlot(i, i == 4 ? this.inventory.getStackInSlot(i) : ItemStack.f_41583_);
        }
        if (this.customName != null) {
            compound.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        compound.m_128365_("Inventory", (Tag)drops.serializeNBT());
        if (!this.fluidTank.isEmpty()) {
            compound.m_128365_("FluidTank", (Tag)this.fluidTank.writeToNBT(new CompoundTag()));
        }
        return compound;
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        compound.m_128365_("FluidTank", (Tag)this.fluidTank.writeToNBT(new CompoundTag()));
        compound.m_128405_("FermentTime", this.fermentTime);
        compound.m_128405_("FermentTimeTotal", this.fermentTimeTotal);
        if (this.customName != null) {
            compound.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        CompoundTag compoundRecipes = new CompoundTag();
        this.usedRecipeTracker.forEach((recipeId, craftedAmount) -> compoundRecipes.m_128405_(recipeId.toString(), craftedAmount.intValue()));
        compound.m_128365_("RecipesUsed", (Tag)compoundRecipes);
    }

    private CompoundTag writeUpdateTag(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        compound.m_128365_("FluidTank", (Tag)this.fluidTank.writeToNBT(new CompoundTag()));
        compound.m_128405_("FermentTime", this.fermentTime);
        compound.m_128405_("FermentTimeTotal", this.fermentTimeTotal);
        return compound;
    }

    public CompoundTag writeDrink(CompoundTag compound) {
        if (this.customName != null) {
            compound.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        if (!this.fluidTank.isEmpty()) {
            compound.m_128365_("FluidTank", (Tag)this.fluidTank.writeToNBT(new CompoundTag()));
        }
        return compound;
    }

    public static boolean isValidTemp(int kegTemp, int want) {
        return switch (want) {
            case 1 -> {
                if (kegTemp <= 1) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (kegTemp <= 2) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (kegTemp < 5 && kegTemp > 1) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (kegTemp >= 4) {
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                if (kegTemp >= 5) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    protected boolean canFerment(KegFermentingRecipe recipe, KegBlockEntity keg) {
        if (!this.hasInput()) {
            return false;
        }
        if (this.f_58857_ == null) {
            return false;
        }
        if (!KegBlockEntity.isValidTemp(keg.getTemperature(), recipe.getTemperature())) {
            return false;
        }
        if (recipe.getFluidIngredient() == null) {
            return keg.fluidTank.isEmpty();
        }
        if (!keg.fluidTank.getFluid().getFluid().m_6212_(recipe.getFluidIngredient().getFluid())) {
            return false;
        }
        return keg.fluidTank.getFluidAmount() % recipe.getFluidIngredient().getAmount() == 0;
    }

    public static void fermentingTick(Level level, BlockPos pos, BlockState state, KegBlockEntity keg) {
        boolean didInventoryChange = false;
        keg.updateTemperature();
        if (keg.hasInput()) {
            Optional<KegFermentingRecipe> recipe = keg.getMatchingRecipe(keg.recipeWrapper);
            if (recipe.isPresent()) {
                if (keg.canFerment(recipe.get(), keg)) {
                    didInventoryChange = keg.processFermenting(recipe.get(), keg);
                } else {
                    keg.fermentTime = Math.max(0, keg.fermentTime - 20);
                }
            } else {
                keg.fermentTime = Math.max(0, keg.fermentTime - 20);
            }
        } else if (keg.fermentTime > 0) {
            keg.fermentTime = Math.max(0, keg.fermentTime - 20);
        }
        if (didInventoryChange) {
            keg.inventoryChanged();
        }
    }

    public Optional<KegFermentingRecipe> getRecipeWithoutTemperature() {
        if (!this.hasInput()) {
            return Optional.empty();
        }
        Optional<KegFermentingRecipe> recipe = this.getMatchingRecipe(this.recipeWrapper);
        if (recipe.isEmpty()) {
            return Optional.empty();
        }
        if (recipe.get().getFluidIngredient() == null) {
            if (!this.fluidTank.isEmpty()) {
                return Optional.empty();
            }
        } else {
            if (!this.fluidTank.getFluid().getFluid().m_6212_(recipe.get().getFluidIngredient().getFluid())) {
                return Optional.empty();
            }
            if (this.fluidTank.getFluidAmount() % recipe.get().getFluidIngredient().getAmount() != 0) {
                return Optional.empty();
            }
        }
        return recipe;
    }

    private Optional<KegFermentingRecipe> getMatchingRecipe(KegRecipeWrapper inventoryWrapper) {
        Object recipe;
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        if (this.lastRecipeID != null && (recipe = (Recipe)((RecipeManagerAccessor)this.f_58857_.m_7465_()).getRecipeMap((RecipeType)BnCRecipeTypes.FERMENTING.get()).get(this.lastRecipeID)) instanceof KegFermentingRecipe && recipe.m_5818_((Container)inventoryWrapper, this.f_58857_)) {
            return Optional.of((KegFermentingRecipe)recipe);
        }
        if (this.checkNewRecipe && ((Optional)(recipe = this.f_58857_.m_7465_().m_44013_((RecipeType)BnCRecipeTypes.FERMENTING.get()).stream().filter(a -> a.matches(inventoryWrapper, this.f_58857_) && (a.getFluidIngredient() == null || a.getFluidIngredient().isFluidEqual(this.fluidTank.getFluid()))).findFirst())).isPresent()) {
            ResourceLocation newRecipeID = ((KegFermentingRecipe)((Optional)recipe).get()).m_6423_();
            if (this.lastRecipeID != null && !this.lastRecipeID.equals((Object)newRecipeID)) {
                this.fermentTime = 0;
            }
            this.lastRecipeID = newRecipeID;
            return recipe;
        }
        this.checkNewRecipe = false;
        return Optional.empty();
    }

    private boolean hasInput() {
        for (int i = 0; i < 5; ++i) {
            if (this.inventory.getStackInSlot(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    private boolean processFermenting(KegFermentingRecipe recipe, KegBlockEntity keg) {
        if (this.f_58857_ == null) {
            return false;
        }
        ++this.fermentTime;
        this.fermentTimeTotal = recipe.getFermentTime();
        if (this.fermentTime < this.fermentTimeTotal) {
            this.m_6596_();
            return false;
        }
        this.fermentTime = 0;
        if (recipe.getResultFluid() != null) {
            keg.fluidTank.setFluid(new FluidStack(recipe.getResultFluid(), keg.fluidTank.getFluidAmount()));
            if (keg.f_58857_.m_5776_()) {
                keg.f_58857_.m_245747_(keg.m_58899_(), SoundEvents.f_11772_, SoundSource.BLOCKS, 1.0f, 0.8f, true);
            }
        }
        if (recipe.getResultItem() != null) {
            if (recipe.getFluidIngredient() != null) {
                keg.fluidTank.drain(recipe.getFluidIngredient().getAmount(), IFluidHandler.FluidAction.EXECUTE);
            }
            keg.inventory.insertItem(5, new ItemStack((ItemLike)recipe.getResultItem(), recipe.getAmount()), false);
        }
        for (int i = 0; i < 5; ++i) {
            ItemStack slotStack = this.inventory.getStackInSlot(i);
            if (slotStack.hasCraftingRemainingItem()) {
                this.ejectIngredientRemainder(slotStack.getCraftingRemainingItem());
            }
            if (slotStack.m_41619_()) continue;
            slotStack.m_41774_(1);
        }
        return true;
    }

    @Deprecated(forRemoval=true)
    public List<ItemStack> extractInGui(KegBlockEntity keg, ItemStack slotIn, int maxTakeAmount) {
        return this.extractInGui(slotIn, maxTakeAmount);
    }

    @Deprecated(forRemoval=true)
    public List<ItemStack> extractInWorld(KegBlockEntity keg, ItemStack slotIn, int maxTakeAmount, boolean isCreative) {
        return this.extractInWorld(slotIn, maxTakeAmount, isCreative);
    }

    public List<ItemStack> extractInGui(ItemStack slotIn, int maxTakeAmount) {
        return this.fluidExtract(slotIn, maxTakeAmount, true, false);
    }

    public List<ItemStack> extractInWorld(ItemStack slotIn, int maxTakeAmount, boolean isCreative) {
        return this.fluidExtract(slotIn, maxTakeAmount, false, isCreative);
    }

    private List<ItemStack> fluidExtract(ItemStack slotIn, int maxTakeAmount, boolean inGui, boolean isCreative) {
        IFluidHandlerItem iFluidItemHandler;
        if (slotIn.m_41619_()) {
            return List.of();
        }
        Optional<KegPouringRecipe> recipe = this.getPouringRecipe(slotIn);
        boolean changed = false;
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        if (recipe.isPresent() && (this.fluidTank.isEmpty() || this.fluidTank.getFluid().getFluid() == recipe.get().getRawFluid())) {
            ItemStack resultItem = recipe.get().assemble(this.recipeWrapper, this.f_58857_.m_9598_());
            if (ItemStack.m_41656_((ItemStack)slotIn, (ItemStack)recipe.get().getContainer()) && recipe.get().getAmount() <= this.fluidTank.getFluidAmount() && (!inGui || this.inventory.getStackInSlot(5).m_41619_() || ItemStack.m_150942_((ItemStack)resultItem, (ItemStack)this.inventory.getStackInSlot(5)))) {
                containerAmount = Mth.m_14045_((int)Math.min(slotIn.m_41613_(), maxTakeAmount), (int)1, (int)(this.fluidTank.getCapacity() / recipe.get().getAmount()));
                this.fluidTank.drain(new FluidStack(this.fluidTank.getFluid(), recipe.get().getAmount() * containerAmount), IFluidHandler.FluidAction.EXECUTE);
                if (!isCreative) {
                    ItemStack newResult;
                    for (int overflow = containerAmount; overflow > 0 && !slotIn.m_41619_(); overflow -= newResult.m_41613_()) {
                        newResult = resultItem.m_255036_(Math.min(resultItem.m_41741_(), overflow));
                        outputs.add(newResult);
                        slotIn.m_41774_(newResult.m_41613_());
                    }
                    if (!slotIn.m_41619_()) {
                        outputs.add(slotIn);
                    }
                } else {
                    outputs.add(slotIn);
                }
                changed = true;
            } else if (recipe.filter(KegPouringRecipe::canFill).isPresent() && (recipe.get().isStrict() && ItemStack.m_150942_((ItemStack)resultItem, (ItemStack)slotIn) || !recipe.get().isStrict() && ItemStack.m_41656_((ItemStack)slotIn, (ItemStack)resultItem)) && (this.fluidTank.isEmpty() || this.fluidTank.getFluidAmount() < this.fluidTank.getCapacity()) && (!inGui || this.inventory.getStackInSlot(5).m_41619_() || ItemStack.m_150942_((ItemStack)recipe.get().getContainer(), (ItemStack)this.inventory.getStackInSlot(5)))) {
                containerAmount = Mth.m_14045_((int)Math.min(slotIn.m_41613_(), this.fluidTank.getCapacity() / recipe.get().getAmount()), (int)1, (int)maxTakeAmount);
                this.fluidTank.fill(new FluidStack(recipe.get().getFluid(slotIn), recipe.get().getAmount() * containerAmount), IFluidHandler.FluidAction.EXECUTE);
                if (!isCreative) {
                    ItemStack newResult;
                    ItemStack recipeItem = recipe.get().getContainer(slotIn);
                    for (int overflow = containerAmount; overflow > 0 && !slotIn.m_41619_(); overflow -= newResult.m_41613_()) {
                        newResult = recipeItem.m_255036_(Math.min(recipeItem.m_41741_(), overflow));
                        outputs.add(newResult);
                        slotIn.m_41774_(newResult.m_41613_());
                    }
                    if (!slotIn.m_41619_()) {
                        outputs.add(slotIn);
                    }
                } else {
                    outputs.add(slotIn);
                }
                changed = true;
            }
            if (changed) {
                this.m_6596_();
            }
        }
        if (!outputs.isEmpty() || recipe.isPresent()) {
            return outputs;
        }
        LazyOptional fluidHandler = isCreative ? slotIn.m_41777_().getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM) : slotIn.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
        IFluidHandlerItem finalIFluidItemHandler = iFluidItemHandler = (IFluidHandlerItem)fluidHandler.orElse(null);
        if (fluidHandler.isPresent() && !slotIn.m_41619_()) {
            int amountToDrain;
            int amount;
            if (this.fluidTank.getFluid().isFluidEqual(iFluidItemHandler.getFluidInTank(0)) || this.fluidTank.getFluid().isEmpty() && (!inGui || this.inventory.getStackInSlot(5).m_41619_() || this.inventory.getStackInSlot(5).m_150930_(iFluidItemHandler.getContainer().m_41720_())) && this.f_58857_.m_7465_().m_44013_((RecipeType)BnCRecipeTypes.KEG_POURING.get()).stream().anyMatch(pouringRecipe -> pouringRecipe.getFluid(slotIn).isFluidEqual(finalIFluidItemHandler.getFluidInTank(0)))) {
                int amountToDrain2 = this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount();
                int amount2 = this.fluidTank.fill(iFluidItemHandler.drain(amountToDrain2, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE);
                if (amount2 <= amountToDrain2 && amount2 > 0) {
                    this.fluidTank.fill(iFluidItemHandler.drain(amountToDrain2, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                    if (!isCreative) {
                        ItemStack newResult;
                        ItemStack recipeItem = slotIn.getCraftingRemainingItem().m_41619_() ? iFluidItemHandler.getContainer() : slotIn.getCraftingRemainingItem();
                        for (int overflow = amount2 / this.fluidTank.getCapacity(); overflow > 0 && !slotIn.m_41619_(); overflow -= newResult.m_41613_()) {
                            newResult = recipeItem.m_255036_(Math.min(recipeItem.m_41741_(), overflow));
                            outputs.add(newResult);
                            slotIn.m_41774_(newResult.m_41613_());
                        }
                    } else {
                        outputs.add(slotIn);
                    }
                    this.m_6596_();
                }
            } else if (!this.fluidTank.getFluid().isEmpty() && iFluidItemHandler.isFluidValid(0, this.fluidTank.getFluid()) && (!inGui || this.inventory.getStackInSlot(5).m_41619_() || this.inventory.getStackInSlot(5).m_150930_(iFluidItemHandler.getContainer().m_41720_())) && (amount = (iFluidItemHandler = (IFluidHandlerItem)slotIn.m_255036_((amountToDrain = iFluidItemHandler.getTankCapacity(0)) / iFluidItemHandler.getTankCapacity(0)).getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse(null)).fill(this.fluidTank.drain(amountToDrain, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE)) > 0) {
                iFluidItemHandler.fill(this.fluidTank.drain(amountToDrain, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                if (amount <= amountToDrain) {
                    outputs.add(slotIn);
                    this.m_6596_();
                }
            }
        }
        return outputs;
    }

    public Optional<KegPouringRecipe> getPouringRecipe(ItemStack slot) {
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        return this.f_58857_.m_7465_().m_44013_((RecipeType)BnCRecipeTypes.KEG_POURING.get()).stream().sorted(Comparator.comparingInt(value -> value.isStrict() ? 0 : 1)).filter(r -> {
            boolean containerCheck = false;
            boolean resultCheck = false;
            boolean fluidCheck = false;
            if (r.isStrict() && ItemStack.m_150942_((ItemStack)r.getContainer(), (ItemStack)slot) || !r.isStrict() && r.getContainer().m_41720_() == slot.m_41720_()) {
                containerCheck = true;
            }
            if (!containerCheck && r.canFill() && (r.isStrict() && ItemStack.m_150942_((ItemStack)r.assemble(this.recipeWrapper, this.f_58857_.m_9598_()), (ItemStack)slot) || !r.isStrict() && r.assemble(this.recipeWrapper, this.f_58857_.m_9598_()).m_41720_() == slot.m_41720_())) {
                resultCheck = true;
            }
            if (this.recipeWrapper.getFluid(0).isEmpty() || containerCheck && r.getRawFluid() == this.recipeWrapper.getFluid(0).getFluid() || r.getFluid(slot).isFluidEqual(this.recipeWrapper.getFluid(0))) {
                fluidCheck = true;
            }
            return (containerCheck || resultCheck) && fluidCheck;
        }).findFirst();
    }

    public void updateTemperature() {
        Holder biome;
        ArrayList<BlockState> states = new ArrayList<BlockState>();
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    states.add(this.f_58857_.m_8055_(this.f_58858_.m_7918_(x, y, z)));
                }
            }
        }
        int heat = states.stream().filter(s -> s.m_204336_(ModTags.HEAT_SOURCES) && s.m_61138_((Property)BlockStateProperties.f_61443_)).filter(s -> (Boolean)s.m_61143_((Property)BlockStateProperties.f_61443_)).mapToInt(s -> 1).sum();
        heat += states.stream().filter(s -> s.m_204336_(ModTags.HEAT_SOURCES) && !s.m_61138_((Property)BlockStateProperties.f_61443_)).mapToInt(s -> 1).sum();
        int cold = states.stream().filter(s -> s.m_204336_(BnCTags.FREEZE_SOURCES) && s.m_61138_((Property)BlockStateProperties.f_61443_)).filter(s -> s.m_61138_((Property)BlockStateProperties.f_61443_)).filter(s -> (Boolean)s.m_61143_((Property)BlockStateProperties.f_61443_)).mapToInt(s -> 1).sum();
        cold += states.stream().filter(s -> s.m_204336_(BnCTags.FREEZE_SOURCES) && !s.m_61138_((Property)BlockStateProperties.f_61443_)).mapToInt(s -> 1).sum();
        if (((Boolean)BnCConfiguration.KEG_BIOME_TEMP.get()).booleanValue() && (biome = this.f_58857_.m_204166_(this.f_58858_)).m_203633_()) {
            float biomeTemperature = ((Biome)biome.m_203334_()).m_47554_();
            if (biomeTemperature <= 0.0f) {
                ++cold;
            } else if (biomeTemperature == 2.0f) {
                ++heat;
            }
        }
        this.kegTemperature = heat - cold;
        if (((Boolean)BnCConfiguration.KEG_DIM_TEMP.get()).booleanValue() && this.f_58857_.m_6042_().f_63857_()) {
            this.kegTemperature += 2;
        }
    }

    public int getTemperature() {
        if (this.kegTemperature <= -((Integer)BnCConfiguration.KEG_COLD.get()).intValue()) {
            return 1;
        }
        if (this.kegTemperature <= -((Integer)BnCConfiguration.KEG_CHILLY.get()).intValue()) {
            return 2;
        }
        if (this.kegTemperature < (Integer)BnCConfiguration.KEG_WARM.get()) {
            return 3;
        }
        if (this.kegTemperature < (Integer)BnCConfiguration.KEG_HOT.get()) {
            return 4;
        }
        return 5;
    }

    protected void ejectIngredientRemainder(ItemStack remainderStack) {
        Direction direction = ((Direction)this.m_58900_().m_61143_((Property)KegBlock.FACING)).m_122428_();
        double x = (double)this.f_58858_.m_123341_() + 0.5 + (double)direction.m_122429_() * 0.25;
        double y = (double)this.f_58858_.m_123342_() + 0.7;
        double z = (double)this.f_58858_.m_123343_() + 0.5 + (double)direction.m_122431_() * 0.25;
        ItemUtils.spawnItemEntity((Level)this.f_58857_, (ItemStack)remainderStack, (double)x, (double)y, (double)z, (double)((float)direction.m_122429_() * 0.08f), (double)0.25, (double)((float)direction.m_122431_() * 0.08f));
    }

    public void m_6029_(@Nullable Recipe<?> recipe) {
        if (recipe != null) {
            ResourceLocation recipeID = recipe.m_6423_();
            this.usedRecipeTracker.addTo((Object)recipeID, 1);
        }
    }

    @Nullable
    public Recipe<?> m_7928_() {
        return null;
    }

    public void m_58395_(Player player, List<ItemStack> items) {
        List<Recipe<?>> usedRecipes = this.getUsedRecipesAndPopExperience(player.m_9236_(), player.m_20182_());
        player.m_7281_(usedRecipes);
        this.usedRecipeTracker.clear();
    }

    public List<Recipe<?>> getUsedRecipesAndPopExperience(Level level, Vec3 pos) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.usedRecipeTracker.object2IntEntrySet()) {
            level.m_7465_().m_44043_((ResourceLocation)entry.getKey()).ifPresent(recipe -> {
                list.add(recipe);
                KegBlockEntity.splitAndSpawnExperience((ServerLevel)level, pos, entry.getIntValue(), ((KegFermentingRecipe)recipe).getExperience());
            });
        }
        return list;
    }

    private static void splitAndSpawnExperience(ServerLevel level, Vec3 pos, int craftedAmount, float experience) {
        int expTotal = Mth.m_14143_((float)((float)craftedAmount * experience));
        float expFraction = Mth.m_14187_((float)((float)craftedAmount * experience));
        if (expFraction > 0.0f && Math.random() < (double)expFraction) {
            ++expTotal;
        }
        ExperienceOrb.m_147082_((ServerLevel)level, (Vec3)pos, (int)expTotal);
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    public NonNullList<ItemStack> getDroppableInventory() {
        NonNullList drops = NonNullList.m_122779_();
        for (int i = 0; i < 6; ++i) {
            drops.add((Object)this.inventory.getStackInSlot(i));
        }
        return drops;
    }

    public Component m_7755_() {
        return this.customName != null ? this.customName : BnCTextUtils.getTranslation("container.keg", new Object[0]);
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    @Nullable
    public Component m_7770_() {
        return this.customName;
    }

    public void setCustomName(Component name) {
        this.customName = name;
    }

    public AbstractContainerMenu m_7208_(int id, Inventory player, Player entity) {
        return new KegMenu(id, player, this, this.kegData);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap.equals((Object)ForgeCapabilities.ITEM_HANDLER)) {
            if (side == null || side.equals((Object)Direction.UP)) {
                return this.inputHandler.cast();
            }
            return this.outputHandler.cast();
        }
        if (cap.equals((Object)ForgeCapabilities.FLUID_HANDLER)) {
            return this.fluidTankHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_7651_() {
        super.m_7651_();
        this.inputHandler.invalidate();
        this.outputHandler.invalidate();
        this.fluidTankHandler.invalidate();
    }

    public CompoundTag m_5995_() {
        return this.writeUpdateTag(new CompoundTag());
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(6){

            protected void onContentsChanged(int slot) {
                List<ItemStack> out;
                if (slot == 4 && !(out = KegBlockEntity.this.extractInGui(this.getStackInSlot(4), this.getSlotLimit(5))).isEmpty()) {
                    this.insertItem(5, out.get(0), false);
                }
                if (slot >= 0 && slot < 5) {
                    KegBlockEntity.this.checkNewRecipe = true;
                }
                KegBlockEntity.this.inventoryChanged();
            }
        };
    }

    private FluidTank createFluidTank() {
        return new FluidTank((Integer)BnCConfiguration.KEG_CAPACITY.get()){

            protected void onContentsChanged() {
                super.onContentsChanged();
                KegBlockEntity.this.m_6596_();
                KegBlockEntity.this.inventoryChanged();
                KegBlockEntity.this.checkNewRecipe = true;
            }
        };
    }

    private ContainerData createIntArray() {
        return new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> KegBlockEntity.this.fermentTime;
                    case 1 -> KegBlockEntity.this.fermentTimeTotal;
                    case 2 -> KegBlockEntity.this.getTemperature();
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        KegBlockEntity.this.fermentTime = value;
                        break;
                    }
                    case 1: {
                        KegBlockEntity.this.fermentTimeTotal = value;
                        break;
                    }
                    case 2: {
                        KegBlockEntity.this.getTemperature();
                    }
                }
            }

            public int m_6499_() {
                return 3;
            }
        };
    }
}

