/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.registration.impl;

import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.providers.IItemProvider;
import mekanism.api.text.ILangEntry;
import mekanism.client.SpecialColors;
import mekanism.common.block.BlockBounding;
import mekanism.common.registration.WrappedDeferredRegister;
import mekanism.common.registration.impl.BlockDeferredRegister;
import mekanism.common.registration.impl.CreativeTabRegistryObject;
import mekanism.common.registration.impl.FluidDeferredRegister;
import mekanism.common.registration.impl.FluidRegistryObject;
import mekanism.common.registration.impl.ItemDeferredRegister;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public class CreativeTabDeferredRegister
extends WrappedDeferredRegister<CreativeModeTab> {
    private final Consumer<BuildCreativeModeTabContentsEvent> addToExistingTabs;
    private final String modid;

    public CreativeTabDeferredRegister(String modid) {
        this(modid, (BuildCreativeModeTabContentsEvent event) -> {});
    }

    public CreativeTabDeferredRegister(String modid, Consumer<BuildCreativeModeTabContentsEvent> addToExistingTabs) {
        super(modid, Registries.f_279569_);
        this.modid = modid;
        this.addToExistingTabs = addToExistingTabs;
    }

    @Override
    public void register(IEventBus bus) {
        super.register(bus);
        bus.addListener(this.addToExistingTabs);
    }

    public CreativeTabRegistryObject registerMain(ILangEntry title, IItemProvider icon, UnaryOperator<CreativeModeTab.Builder> operator) {
        return this.register(this.modid, title, icon, operator);
    }

    public CreativeTabRegistryObject register(String name, ILangEntry title, IItemProvider icon, UnaryOperator<CreativeModeTab.Builder> operator) {
        return this.register(name, () -> {
            CreativeModeTab.Builder builder = CreativeModeTab.builder().m_257941_((Component)title.translate(new Object[0])).m_257737_(icon::getItemStack).withTabFactory(MekanismCreativeTab::new);
            return ((CreativeModeTab.Builder)operator.apply(builder)).m_257652_();
        }, CreativeTabRegistryObject::new);
    }

    public static void addToDisplay(CreativeModeTab.Output output, ItemLike ... items) {
        for (ItemLike item : items) {
            CreativeTabDeferredRegister.addToDisplay(output, item);
        }
    }

    public static void addToDisplay(CreativeModeTab.Output output, ItemLike itemLike) {
        Item item = itemLike.m_5456_();
        if (item instanceof ICustomCreativeTabContents) {
            ICustomCreativeTabContents contents = (ICustomCreativeTabContents)item;
            if (contents.addDefault()) {
                output.m_246326_(itemLike);
            }
            contents.addItems(output);
        } else {
            output.m_246326_(itemLike);
        }
    }

    public static void addToDisplay(ItemDeferredRegister register, CreativeModeTab.Output output) {
        for (IItemProvider itemProvider : register.getAllItems()) {
            CreativeTabDeferredRegister.addToDisplay(output, (ItemLike)itemProvider);
        }
    }

    public static void addToDisplay(BlockDeferredRegister register, CreativeModeTab.Output output) {
        for (IBlockProvider itemProvider : register.getAllBlocks()) {
            if (itemProvider.getBlock() instanceof BlockBounding) continue;
            CreativeTabDeferredRegister.addToDisplay(output, (ItemLike)itemProvider);
        }
    }

    public static void addToDisplay(FluidDeferredRegister register, CreativeModeTab.Output output) {
        for (FluidRegistryObject<FluidDeferredRegister.MekanismFluidType, ?, ?, ?, ?> fluidRO : register.getAllFluids()) {
            CreativeTabDeferredRegister.addToDisplay(output, fluidRO.getBucket());
        }
    }

    public static interface ICustomCreativeTabContents {
        public void addItems(CreativeModeTab.Output var1);

        default public boolean addDefault() {
            return true;
        }
    }

    public static class MekanismCreativeTab
    extends CreativeModeTab {
        protected MekanismCreativeTab(CreativeModeTab.Builder builder) {
            super(builder);
        }

        public int getLabelColor() {
            return SpecialColors.TEXT_TITLE.argb();
        }
    }
}

