/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.command;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import java.nio.file.Path;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.command.GeneratePackHelper;
import slimeknights.mantle.util.JsonHelper;

public class RemoveDataCommand {
    private static final Dynamic2CommandExceptionType INVALID_REGISTRY = new Dynamic2CommandExceptionType((name, registry) -> Mantle.makeComponent("command", "key.wrong_registry", name, registry));
    private static final String STRUCTURE_SET_SUCCESS = Mantle.makeDescriptionId("command", "remove_data.structure.success");
    private static final String BIOME_MODIFIER_SUCCESS = Mantle.makeDescriptionId("command", "remove_data.biome_modifier.success");

    public static void register(LiteralArgumentBuilder<CommandSourceStack> subCommand) {
        ((LiteralArgumentBuilder)subCommand.then(Commands.m_82127_((String)"structure_set").then(Commands.m_82129_((String)"id", (ArgumentType)ResourceKeyArgument.m_212386_((ResourceKey)Registries.f_256998_)).executes(RemoveDataCommand::removeStructureSet)))).then(Commands.m_82127_((String)"biome_modifier").then(Commands.m_82129_((String)"id", (ArgumentType)ResourceKeyArgument.m_212386_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS)).executes(RemoveDataCommand::removeBiomeModifier)));
    }

    private static <T> ResourceKey<T> getResourceKey(CommandContext<CommandSourceStack> context, String name, ResourceKey<Registry<T>> registry) throws CommandSyntaxException {
        ResourceKey key = (ResourceKey)context.getArgument(name, ResourceKey.class);
        if (key.m_135783_(registry)) {
            return key;
        }
        throw INVALID_REGISTRY.create((Object)key, (Object)registry.m_135782_());
    }

    private static int removeStructureSet(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        long startTime = System.nanoTime();
        ResourceKey id = RemoveDataCommand.getResourceKey(context, "id", Registries.f_256998_);
        ResourceLocation setLocation = JsonHelper.wrap(id.m_135782_(), Registries.f_256998_.m_135782_().m_135815_() + "/", ".json");
        Path pack = GeneratePackHelper.getDatapackPath(((CommandSourceStack)context.getSource()).m_81377_());
        GeneratePackHelper.saveMcmeta(pack);
        Path path = pack.resolve(PackType.SERVER_DATA.m_10305_()).resolve(setLocation.m_135827_() + "/" + setLocation.m_135815_());
        if (!GeneratePackHelper.saveConditionRemove(path)) {
            throw GeneratePackHelper.FAILED_SAVE.create(id);
        }
        float time = (float)(System.nanoTime() - startTime) / 1000000.0f;
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)STRUCTURE_SET_SUCCESS, (Object[])new Object[]{id.m_135782_(), Float.valueOf(time), GeneratePackHelper.getOutputComponent(pack)}), true);
        return 1;
    }

    private static int removeBiomeModifier(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        long startTime = System.nanoTime();
        ResourceKey id = RemoveDataCommand.getResourceKey(context, "id", ForgeRegistries.Keys.BIOME_MODIFIERS);
        ResourceLocation modifierLocation = JsonHelper.wrap(id.m_135782_(), ForgeRegistries.Keys.BIOME_MODIFIERS.m_135782_().m_135827_() + "/" + ForgeRegistries.Keys.BIOME_MODIFIERS.m_135782_().m_135815_() + "/", ".json");
        JsonObject json = new JsonObject();
        json.addProperty("type", ForgeMod.NONE_BIOME_MODIFIER_TYPE.getId().toString());
        Path pack = GeneratePackHelper.getDatapackPath(((CommandSourceStack)context.getSource()).m_81377_());
        GeneratePackHelper.saveMcmeta(pack);
        Path path = pack.resolve(PackType.SERVER_DATA.m_10305_()).resolve(modifierLocation.m_135827_() + "/" + modifierLocation.m_135815_());
        if (!GeneratePackHelper.saveJson((JsonElement)json, path)) {
            throw GeneratePackHelper.FAILED_SAVE.create((Object)id.m_135782_());
        }
        float time = (float)(System.nanoTime() - startTime) / 1000000.0f;
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)BIOME_MODIFIER_SUCCESS, (Object[])new Object[]{id.m_135782_(), Float.valueOf(time), GeneratePackHelper.getOutputComponent(pack)}), true);
        return 1;
    }
}

