/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.datamap;

import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.mantle.data.datamap.RegistryDataMapLoader;
import slimeknights.mantle.data.loadable.record.RecordLoadable;

public abstract class RegistryDataMapProvider<R, D>
extends GenericDataProvider {
    private final Registry<R> registry;
    private final RecordLoadable<D> dataLoader;
    private final String modId;
    private final Map<ResourceLocation, Supplier<JsonObject>> entries = new HashMap<ResourceLocation, Supplier<JsonObject>>();

    public RegistryDataMapProvider(PackOutput output, PackOutput.Target type, Registry<R> registry, RecordLoadable<D> dataLoader, String folder, String modId) {
        super(output, type, folder);
        this.registry = registry;
        this.dataLoader = dataLoader;
        this.modId = modId;
    }

    public RegistryDataMapProvider(PackOutput output, PackOutput.Target type, RegistryDataMapLoader<R, D> dataLoader, String modId) {
        this(output, type, dataLoader.getRegistry(), dataLoader.getDataLoader(), dataLoader.getFolder(), modId);
    }

    protected abstract void addEntries();

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        this.addEntries();
        return RegistryDataMapProvider.allOf(this.entries.entrySet().stream().map(entry -> this.saveJson(cache, (ResourceLocation)entry.getKey(), ((Supplier)entry.getValue()).get())));
    }

    protected ResourceLocation key(String name) {
        return new ResourceLocation(this.modId, name);
    }

    protected ResourceLocation key(R entry) {
        return Objects.requireNonNull(this.registry.m_7981_(entry));
    }

    protected ResourceLocation key(Supplier<? extends R> entry) {
        return this.key(entry.get());
    }

    protected void entry(ResourceLocation key, Supplier<JsonObject> json) {
        Supplier<JsonObject> original = this.entries.putIfAbsent(key, json);
        if (original != null) {
            throw new IllegalArgumentException("Duplicate entry at " + key + ", original " + original + ", new value " + json);
        }
    }

    protected void redirect(ResourceLocation key, ResourceLocation parent) {
        this.entry((R)key, (D)((Supplier<JsonObject>)() -> {
            JsonObject json = new JsonObject();
            json.addProperty("parent", parent.toString());
            return json;
        }));
    }

    protected void redirect(String key, ResourceLocation parent) {
        this.redirect(this.key(key), parent);
    }

    protected void redirect(R key, ResourceLocation parent) {
        this.redirect(this.key(key), parent);
    }

    protected void redirect(Supplier<? extends R> key, ResourceLocation parent) {
        this.redirect(this.key(key), parent);
    }

    protected void redirect(String key, String parent) {
        this.redirect(this.key(key), this.key(parent));
    }

    protected void redirect(R key, String parent) {
        this.redirect(this.key(key), this.key(parent));
    }

    protected void redirect(Supplier<? extends R> key, String parent) {
        this.redirect(this.key(key), this.key(parent));
    }

    protected void entry(ResourceLocation key, D data) {
        this.entry((R)key, (D)new DataEntry<D>(this.dataLoader, data));
    }

    protected void entry(String key, D data) {
        this.entry((R)this.key(key), data);
    }

    protected void entry(R key, D data) {
        this.entry((R)this.key(key), data);
    }

    protected void entry(Supplier<? extends R> key, D data) {
        this.entry((R)this.key(key), data);
    }

    private record DataEntry<D>(RecordLoadable<D> loadable, D data) implements Supplier<JsonObject>
    {
        @Override
        public JsonObject get() {
            JsonObject json = new JsonObject();
            this.loadable.serialize(this.data, json);
            return json;
        }

        @Override
        public String toString() {
            return this.data.toString();
        }
    }
}

