/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.integration.jei;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import me.paulf.fairylights.util.FLMth;
import me.paulf.fairylights.util.crafting.GenericRecipe;
import me.paulf.fairylights.util.crafting.ingredient.AuxiliaryIngredient;
import me.paulf.fairylights.util.crafting.ingredient.GenericIngredient;
import me.paulf.fairylights.util.crafting.ingredient.RegularIngredient;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;

public final class GenericRecipeWrapper
implements ICraftingCategoryExtension {
    private final GenericRecipe recipe;
    private final List<List<ItemStack>> allInputs;
    private final List<List<ItemStack>> minimalInputStacks;
    private final List<ItemStack> outputs;
    private final GenericIngredient<?, ?>[] ingredientMatrix;
    private final int subtypeIndex;

    public GenericRecipeWrapper(GenericRecipe recipe) {
        this.recipe = recipe;
        ArrayList<List<ItemStack>> allInputs = new ArrayList<List<ItemStack>>();
        ArrayList<List<ItemStack>> minimalInputStacks = new ArrayList<List<ItemStack>>();
        RegularIngredient[] ingredients = recipe.getGenericIngredients();
        AuxiliaryIngredient<?>[] aux = recipe.getAuxiliaryIngredients();
        this.ingredientMatrix = new GenericIngredient[9];
        int subtypeIndex = -1;
        int auxIdx = 0;
        for (int i = 0; i < 9; ++i) {
            GenericIngredient<RegularIngredient, GenericRecipe.MatchResultRegular> ingredient;
            ImmutableList<ItemStack> ingInputs;
            int x = i % 3;
            int y = i / 3;
            boolean isEmpty = true;
            if (x < recipe.getWidth() && y < recipe.getHeight() && (ingInputs = (ingredient = ingredients[x + y * recipe.getWidth()]).getInputs()).size() > 0) {
                if (ingredient.dictatesOutputType()) {
                    minimalInputStacks.add((List<ItemStack>)ingInputs);
                    subtypeIndex = i;
                } else {
                    minimalInputStacks.add((List<ItemStack>)ImmutableList.of((Object)((ItemStack)ingInputs.get(0))));
                }
                this.ingredientMatrix[i] = ingredient;
                allInputs.add((List<ItemStack>)ingInputs);
                isEmpty = false;
            }
            if (!isEmpty) continue;
            ingredient = null;
            ImmutableList stacks = null;
            boolean dictator = false;
            while (auxIdx < aux.length) {
                ImmutableList a;
                if ((a = (ingredient = aux[auxIdx++]).getInputs()).size() <= 0) continue;
                stacks = a;
                if (!ingredient.dictatesOutputType()) break;
                subtypeIndex = i;
                dictator = true;
                break;
            }
            if (stacks == null) {
                stacks = ImmutableList.of();
                ingredient = null;
            }
            minimalInputStacks.add((List<ItemStack>)(stacks.isEmpty() || dictator ? stacks : ImmutableList.of((Object)((ItemStack)stacks.get(0)))));
            this.ingredientMatrix[i] = ingredient;
            allInputs.add((List<ItemStack>)stacks);
        }
        this.allInputs = allInputs;
        this.minimalInputStacks = minimalInputStacks;
        this.subtypeIndex = subtypeIndex;
        ImmutableList.Builder outputs = ImmutableList.builder();
        this.forOutputMatches((v, output) -> outputs.add(output));
        this.outputs = outputs.build();
    }

    private void forOutputMatches(BiConsumer<ItemStack, ItemStack> outputConsumer) {
        TransientCraftingContainer crafting = new TransientCraftingContainer(new AbstractContainerMenu(null, 0){

            public ItemStack m_7648_(Player p_38941_, int p_38942_) {
                return ItemStack.f_41583_;
            }

            public boolean m_6875_(Player player) {
                return true;
            }
        }, this.getWidth(), this.getHeight());
        if (this.subtypeIndex == -1) {
            for (int i = 0; i < this.minimalInputStacks.size(); ++i) {
                List<ItemStack> stacks = this.minimalInputStacks.get(i);
                crafting.m_6836_(i, stacks.isEmpty() ? ItemStack.f_41583_ : stacks.get(0));
            }
            if (this.recipe.matches((CraftingContainer)crafting, null)) {
                outputConsumer.accept(ItemStack.f_41583_, this.recipe.assemble((CraftingContainer)crafting, null));
            }
        } else {
            List<ItemStack> dictators = this.minimalInputStacks.get(this.subtypeIndex);
            for (ItemStack subtype : dictators) {
                crafting.m_6211_();
                for (int i = 0; i < this.minimalInputStacks.size(); ++i) {
                    if (i == this.subtypeIndex) {
                        crafting.m_6836_(i, subtype);
                        continue;
                    }
                    List<ItemStack> stacks = this.minimalInputStacks.get(i);
                    crafting.m_6836_(i, stacks.isEmpty() ? ItemStack.f_41583_ : stacks.get(0));
                }
                if (!this.recipe.matches((CraftingContainer)crafting, null)) continue;
                outputConsumer.accept(subtype, this.recipe.assemble((CraftingContainer)crafting, null));
            }
        }
    }

    public int getWidth() {
        return 3;
    }

    public int getHeight() {
        return 3;
    }

    public Input getInputsForOutput(ItemStack output) {
        RegularIngredient[] ingredients = this.recipe.getGenericIngredients();
        ArrayList<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>(9);
        GenericIngredient[] ingredientMat = new GenericIngredient[9];
        AuxiliaryIngredient<?>[] aux = this.recipe.getAuxiliaryIngredients();
        int auxIngIdx = 0;
        int auxIdx = 0;
        for (int i = 0; i < 9; ++i) {
            ImmutableList<ImmutableList<ItemStack>> ingInputs;
            int x = i % 3;
            int y = i / 3;
            RegularIngredient ingredient = null;
            if (x < this.recipe.getWidth() && y < this.recipe.getHeight()) {
                ingredient = ingredients[x + y * this.recipe.getWidth()];
                ingInputs = ingredient.getInput(output);
            } else {
                ingInputs = null;
            }
            if (ingInputs == null || ingInputs.isEmpty()) {
                boolean isEmpty = true;
                if (auxIngIdx < aux.length) {
                    ImmutableList<ImmutableList<ItemStack>> auxInputs = null;
                    AuxiliaryIngredient<?> ingredientAux = null;
                    while (auxIngIdx < aux.length && (auxInputs = (ingredientAux = aux[auxIngIdx]).getInput(output)).size() <= 0) {
                        ++auxIngIdx;
                    }
                    if (auxInputs.size() > 0) {
                        inputs.add((List)auxInputs.get(auxIdx++));
                        ingredientMat[i] = ingredientAux;
                        if (auxIdx == auxInputs.size()) {
                            auxIdx = 0;
                            ++auxIngIdx;
                        }
                        isEmpty = false;
                    }
                }
                if (!isEmpty) continue;
                inputs.add(Collections.emptyList());
                continue;
            }
            inputs.add((List)ingInputs.get(0));
            ingredientMat[i] = ingredient;
        }
        return new Input(inputs, ingredientMat);
    }

    private Input getInputsForIngredient(ItemStack ingredient) {
        TransientCraftingContainer crafting = new TransientCraftingContainer(new AbstractContainerMenu(null, 0){

            public ItemStack m_7648_(Player p_38941_, int p_38942_) {
                return ItemStack.f_41583_;
            }

            public boolean m_6875_(Player player) {
                return true;
            }
        }, this.getWidth(), this.getHeight());
        for (int i = 0; i < this.allInputs.size(); ++i) {
            List<ItemStack> options = this.allInputs.get(i);
            ItemStack matched = null;
            for (ItemStack o : options) {
                if (ingredient.m_41720_() != o.m_41720_()) continue;
                matched = ingredient.m_41777_();
                matched.m_41764_(1);
                break;
            }
            if (matched == null) continue;
            crafting.m_6211_();
            for (int n = 0; n < this.minimalInputStacks.size(); ++n) {
                List<ItemStack> stacks = this.minimalInputStacks.get(n);
                crafting.m_6836_(n, i == n ? matched : (stacks.isEmpty() ? ItemStack.f_41583_ : stacks.get(0)));
            }
            if (!this.recipe.matches((CraftingContainer)crafting, null)) continue;
            ArrayList<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>(this.allInputs.size());
            for (int n = 0; n < this.allInputs.size(); ++n) {
                List<ItemStack> stacks = this.allInputs.get(n);
                inputs.add(i == n ? Collections.singletonList(matched) : stacks);
            }
            return new Input(inputs, this.ingredientMatrix);
        }
        return null;
    }

    public List<ItemStack> getOutput(List<List<ItemStack>> inputs) {
        TransientCraftingContainer crafting = new TransientCraftingContainer(new AbstractContainerMenu(null, 0){

            public ItemStack m_7648_(Player p_38941_, int p_38942_) {
                return ItemStack.f_41583_;
            }

            public boolean m_6875_(Player player) {
                return true;
            }
        }, this.getWidth(), this.getHeight());
        int size = 1;
        for (List<ItemStack> stack : inputs) {
            if (stack.size() <= 0) continue;
            size = FLMth.lcm(stack.size(), size);
        }
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>(size);
        for (int n = 0; n < size; ++n) {
            for (int i = 0; i < inputs.size(); ++i) {
                List<ItemStack> stacks = inputs.get(i);
                crafting.m_6836_(i, stacks.isEmpty() ? ItemStack.f_41583_ : stacks.get(n % stacks.size()));
            }
            if (this.recipe.matches((CraftingContainer)crafting, null)) {
                outputs.add(this.recipe.assemble((CraftingContainer)crafting, null));
                continue;
            }
            LogManager.getLogger().debug("No recipe match for {} using inputs {}", (Object)ForgeRegistries.ITEMS.getKey((Object)this.recipe.getOutput().m_41720_()), (Object)IntStream.range(0, crafting.m_39347_() * crafting.m_39346_()).mapToObj(arg_0 -> ((CraftingContainer)crafting).m_8020_(arg_0)).map(s -> Objects.toString(ForgeRegistries.ITEMS.getKey((Object)s.m_41720_()))).collect(Collectors.joining(", ")));
        }
        return outputs;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ICraftingGridHelper craftingGridHelper, IFocusGroup focuses) {
        focuses.getFocuses((IIngredientType)VanillaTypes.ITEM_STACK).flatMap(focus -> {
            ItemStack stack = (ItemStack)focus.getTypedValue().getIngredient();
            Input input = null;
            if (focus.getRole() == RecipeIngredientRole.INPUT) {
                input = this.getInputsForIngredient(stack);
            } else if (focus.getRole() == RecipeIngredientRole.OUTPUT) {
                input = this.getInputsForOutput(stack);
            }
            return Stream.ofNullable(input);
        }).findFirst().ifPresentOrElse(input -> {
            craftingGridHelper.createAndSetOutputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, this.getOutput(input.inputs));
            List slots = craftingGridHelper.createAndSetInputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, input.inputs, this.getWidth(), this.getHeight());
            for (int i = 0; i < 9; ++i) {
                GenericIngredient<?, ?> ingredient = input.ingredients[i];
                IRecipeSlotBuilder slot = (IRecipeSlotBuilder)slots.get(i);
                slot.addTooltipCallback((recipeSlotView, tooltip) -> {
                    if (recipeSlotView.getRole() == RecipeIngredientRole.INPUT) {
                        ingredient.addTooltip(tooltip);
                    }
                });
            }
        }, () -> {
            craftingGridHelper.createAndSetOutputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, this.outputs);
            craftingGridHelper.createAndSetInputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, this.allInputs, this.getWidth(), this.getHeight());
        });
    }

    private static final class Input {
        List<List<ItemStack>> inputs;
        GenericIngredient<?, ?>[] ingredients;

        private Input(List<List<ItemStack>> inputs, GenericIngredient<?, ?>[] ingredients) {
            this.inputs = inputs;
            this.ingredients = ingredients;
        }
    }
}

