/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.network.packet.server;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.item.CameraItem;
import io.github.mortuusars.exposure.network.PacketDirection;
import io.github.mortuusars.exposure.network.packet.IPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public record OpenCameraAttachmentsPacketC2SP(int cameraSlotIndex) implements IPacket
{
    public static final ResourceLocation ID = Exposure.resource("open_camera_attachments");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public FriendlyByteBuf toBuffer(FriendlyByteBuf buffer) {
        buffer.writeInt(this.cameraSlotIndex);
        return buffer;
    }

    public static OpenCameraAttachmentsPacketC2SP fromBuffer(FriendlyByteBuf buffer) {
        return new OpenCameraAttachmentsPacketC2SP(buffer.readInt());
    }

    @Override
    public boolean handle(PacketDirection direction, @Nullable Player player) {
        if (player == null) {
            throw new IllegalStateException("Cannot handle the packet: Player was null");
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.f_8924_.execute(() -> {
                ItemStack stack = player.m_150109_().m_8020_(this.cameraSlotIndex);
                Item patt0$temp = stack.m_41720_();
                if (patt0$temp instanceof CameraItem) {
                    CameraItem cameraItem = (CameraItem)patt0$temp;
                    cameraItem.openCameraAttachmentsMenu(player, this.cameraSlotIndex);
                }
            });
        }
        return true;
    }
}

