/*
 * Decompiled with CFR 0.152.
 */
package invtweaks.events;

import com.google.common.base.Throwables;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import invtweaks.InvTweaksMod;
import invtweaks.config.ContOverride;
import invtweaks.config.InvTweaksConfig;
import invtweaks.config.Ruleset;
import invtweaks.events.KeyMappings;
import invtweaks.gui.InvTweaksButtonSort;
import invtweaks.network.NetworkDispatcher;
import invtweaks.network.PacketSortInv;
import invtweaks.util.ClientUtils;
import invtweaks.util.Sorting;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemHandlerHelper;

@Mod.EventBusSubscriber(modid="invtweaks", value={Dist.CLIENT})
public class ClientEvents {
    public static final int MIN_SLOTS = 9;
    private static final Set<Screen> screensWithExtSort = Collections.newSetFromMap(new WeakHashMap());
    private static BooleanSupplier isJEIKeyboardActive = () -> false;

    private ClientEvents() {
    }

    private static void requestSort(boolean isPlayer, String screenClass) {
        if (ClientUtils.serverConnectionExists()) {
            NetworkDispatcher.INSTANCE.sendToServer((Object)new PacketSortInv(isPlayer, screenClass));
        } else {
            Sorting.executeSort(ClientUtils.safeGetPlayer(), isPlayer, screenClass);
        }
    }

    @Nullable
    public static Slot getDefaultButtonPlacement(Collection<Slot> slots, Predicate<Slot> filter) {
        if (slots.stream().filter(filter).count() < 9L) {
            return null;
        }
        return slots.stream().filter(filter).max(Comparator.comparingInt(s -> s.f_40220_).thenComparingInt(s -> -s.f_40221_)).orElse(null);
    }

    @SubscribeEvent
    public static void onScreenEventInit(ScreenEvent.Init.Post event) {
        AbstractContainerScreen screen;
        Screen screen2 = event.getScreen();
        if (screen2 instanceof AbstractContainerScreen && !((screen = (AbstractContainerScreen)screen2) instanceof CreativeModeInventoryScreen)) {
            Slot placement = ClientEvents.getDefaultButtonPlacement((Collection<Slot>)screen.m_6262_().f_38839_, slot -> slot.f_40218_ instanceof Inventory);
            if (placement != null && InvTweaksConfig.isSortEnabled(true) && InvTweaksConfig.isButtonEnabled(true)) {
                try {
                    event.addListener((GuiEventListener)new InvTweaksButtonSort(screen.getGuiLeft() + placement.f_40220_ + 17, screen.getGuiTop() + placement.f_40221_, btn -> ClientEvents.requestSort(true, screen.getClass().getName())));
                }
                catch (Exception e) {
                    Throwables.throwIfUnchecked((Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            InvTweaksMod.LOGGER.info(screen.getClass().getName());
            ContOverride override = InvTweaksConfig.getPlayerContOverride((Player)Minecraft.m_91087_().f_91074_, screen.getClass().getName(), screen.m_6262_().getClass().getName());
            boolean isSortDisabled = Optional.ofNullable(override).filter(ContOverride::isSortDisabled).isPresent();
            if (!(screen instanceof EffectRenderingInventoryScreen) && !isSortDisabled) {
                int x = -1418392593;
                int y = -1418392593;
                if (override != null) {
                    x = override.getX();
                    y = override.getY();
                }
                if ((placement = ClientEvents.getDefaultButtonPlacement((Collection<Slot>)screen.m_6262_().f_38839_, slot -> !(slot.f_40218_ instanceof Inventory) && !(slot.f_40218_ instanceof CraftingContainer))) != null) {
                    if (x == -1418392593) {
                        x = placement.f_40220_ + 17;
                    }
                    if (y == -1418392593) {
                        y = placement.f_40221_;
                    }
                }
                if (InvTweaksConfig.isSortEnabled(false)) {
                    try {
                        if (InvTweaksConfig.isButtonEnabled(false)) {
                            event.addListener((GuiEventListener)new InvTweaksButtonSort(screen.getGuiLeft() + x, screen.getGuiTop() + y, btn -> ClientEvents.requestSort(false, screen.getClass().getName())));
                        }
                        screensWithExtSort.add((Screen)screen);
                    }
                    catch (Exception e) {
                        Throwables.throwIfUnchecked((Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    public static void setJEIKeyboardActiveFn(BooleanSupplier query) {
        isJEIKeyboardActive = query;
    }

    public static boolean isJEIKeyboardActive() {
        return isJEIKeyboardActive.getAsBoolean();
    }

    @SubscribeEvent
    public static void onKeyPressed(ScreenEvent.KeyPressed.Pre event) {
        AbstractContainerScreen screen;
        Screen screen2 = event.getScreen();
        if (screen2 instanceof AbstractContainerScreen && !((screen = (AbstractContainerScreen)screen2) instanceof CreativeModeInventoryScreen) && !(screen.m_7222_() instanceof EditBox) && !ClientEvents.isJEIKeyboardActive()) {
            boolean isPlayerSort;
            Slot slot;
            if (InvTweaksConfig.isSortEnabled(true) && KeyMappings.SORT_PLAYER.isActiveAndMatches(InputConstants.m_84827_((int)event.getKeyCode(), (int)event.getScanCode()))) {
                ClientEvents.requestSort(true, screen.getClass().getName());
            }
            if (InvTweaksConfig.isSortEnabled(false) && screensWithExtSort.contains(event.getScreen()) && KeyMappings.SORT_INVENTORY.isActiveAndMatches(InputConstants.m_84827_((int)event.getKeyCode(), (int)event.getScanCode()))) {
                ClientEvents.requestSort(false, screen.getClass().getName());
            }
            if ((slot = screen.getSlotUnderMouse()) != null && InvTweaksConfig.isSortEnabled(isPlayerSort = slot.f_40218_ instanceof Inventory) && (isPlayerSort || screensWithExtSort.contains(event.getScreen())) && KeyMappings.SORT_EITHER.isActiveAndMatches(InputConstants.m_84827_((int)event.getKeyCode(), (int)event.getScanCode()))) {
                ClientEvents.requestSort(isPlayerSort, screen.getClass().getName());
            }
        }
    }

    @SubscribeEvent
    public static void onMouseButtonPressed(ScreenEvent.MouseButtonPressed.Pre event) {
        Screen screen = event.getScreen();
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            if (!(event.getScreen() instanceof CreativeModeInventoryScreen)) {
                boolean isPlayerSort;
                boolean isMouseActive;
                boolean bl = isMouseActive = KeyMappings.SORT_EITHER.getKeyConflictContext().isActive() && KeyMappings.SORT_EITHER.m_90830_(event.getButton());
                if (!isMouseActive) {
                    return;
                }
                Slot slot = screen2.getSlotUnderMouse();
                if (slot != null && InvTweaksConfig.isSortEnabled(isPlayerSort = slot.f_40218_ instanceof Inventory) && (isPlayerSort || screensWithExtSort.contains(event.getScreen()))) {
                    ClientEvents.requestSort(isPlayerSort, screen2.getClass().getName());
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void renderOverlay(RenderGuiOverlayEvent.Post event) {
        if (event.getOverlay().equals((Object)VanillaGuiOverlay.HOTBAR.type())) {
            LocalPlayer ent = Minecraft.m_91087_().f_91074_;
            if (!InvTweaksConfig.isQuickViewEnabled()) {
                return;
            }
            Ruleset rules = InvTweaksConfig.getSelfCompiledRules();
            IntList frozen = (IntList)Optional.ofNullable(rules.catToInventorySlots("/FROZEN")).map(IntArrayList::new).orElseGet(IntArrayList::new);
            frozen.sort(null);
            assert (ent != null);
            if (Collections.binarySearch(frozen, ent.m_150109_().f_35977_) >= 0) {
                return;
            }
            HumanoidArm dominantHand = ent.m_5737_();
            int i = Minecraft.m_91087_().m_91268_().m_85445_() / 2;
            int i2 = Minecraft.m_91087_().m_91268_().m_85446_() - 16 - 3;
            int iprime = dominantHand == HumanoidArm.RIGHT ? i + 91 + 10 : i - 91 - 26;
            int itemCount = IntStream.range(0, ent.m_150109_().f_35974_.size()).filter(idx -> Collections.binarySearch(frozen, idx) < 0).mapToObj(arg_0 -> ((NonNullList)ent.m_150109_().f_35974_).get(arg_0)).filter(arg_0 -> ClientEvents.lambda$renderOverlay$8((Player)ent, arg_0)).mapToInt(ItemStack::m_41613_).sum();
            if (itemCount > ent.m_21205_().m_41613_()) {
                ItemStack toRender = ent.m_21205_().m_41777_();
                toRender.m_41764_(itemCount);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                Minecraft.m_91087_().f_91065_.m_280585_(event.getGuiGraphics(), iprime, i2, Minecraft.m_91087_().m_91296_(), (Player)ent, toRender, 0);
                RenderSystem.disableBlend();
            }
        }
    }

    private static /* synthetic */ boolean lambda$renderOverlay$8(Player ent, ItemStack st) {
        return ItemHandlerHelper.canItemStacksStack((ItemStack)st, (ItemStack)ent.m_21205_());
    }
}

