/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.armor.texture;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import slimeknights.tconstruct.library.client.armor.AbstractArmorModel;
import slimeknights.tconstruct.library.client.armor.texture.ArmorTextureSupplier;

public class TintedArmorTexture
implements ArmorTextureSupplier.ArmorTexture {
    private static final int MAX_LIGHT = LightTexture.m_109885_((int)15, (int)15);
    private final ResourceLocation texture;
    private int color = -1;
    private int luminosity = 0;

    public TintedArmorTexture(ResourceLocation texture, int color) {
        this(texture, color, 0);
    }

    public static int applyLuminosity(int packedLight, int luminosity) {
        if (luminosity >= 15) {
            return MAX_LIGHT;
        }
        return Math.max(luminosity, (packedLight & 0xFFFF) >> 4) << 4 | Math.max(luminosity, packedLight >> 20 & 0xFFFF) << 20;
    }

    @Override
    public void renderTexture(Model model, PoseStack matrices, MultiBufferSource bufferSource, int packedLight, int packedOverlay, float red, float green, float blue, float alpha, boolean hasGlint) {
        VertexConsumer buffer = ItemRenderer.m_115184_((MultiBufferSource)bufferSource, (RenderType)RenderType.m_110431_((ResourceLocation)this.texture), (boolean)false, (boolean)hasGlint);
        if (this.luminosity > 0) {
            packedLight = TintedArmorTexture.applyLuminosity(packedLight, this.luminosity);
        }
        AbstractArmorModel.renderColored(model, matrices, buffer, packedLight, packedOverlay, this.color, red, green, blue, alpha);
    }

    public TintedArmorTexture(ResourceLocation texture, int color, int luminosity) {
        this.texture = texture;
        this.color = color;
        this.luminosity = luminosity;
    }

    public TintedArmorTexture(ResourceLocation texture) {
        this.texture = texture;
    }

    public TintedArmorTexture color(int color) {
        this.color = color;
        return this;
    }

    public TintedArmorTexture luminosity(int luminosity) {
        this.luminosity = luminosity;
        return this;
    }

    public int color() {
        return this.color;
    }

    public int luminosity() {
        return this.luminosity;
    }
}

