/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json.predicate.material;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.tags.TagKey;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.loadable.record.SingletonLoader;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.TagPredicateRegistry;
import slimeknights.tconstruct.library.json.TinkerLoadables;
import slimeknights.tconstruct.library.json.predicate.material.MaterialIdPredicate;
import slimeknights.tconstruct.library.json.predicate.material.MaterialVariantPredicate;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingLookup;

public interface MaterialPredicate
extends IJsonPredicate<MaterialVariantId> {
    public static final MaterialPredicate ANY = MaterialPredicate.simple(material -> true);
    public static final MaterialPredicate NONE = MaterialPredicate.simple(material -> false);
    public static final TagPredicateRegistry<IMaterial, MaterialVariantId> LOADER = new TagPredicateRegistry("Material Predicate", (IJsonPredicate)ANY, (IJsonPredicate)NONE, TinkerLoadables.MATERIAL_TAGS, (tag, source) -> MaterialRegistry.getInstance().isInTag(source.getId(), (TagKey<IMaterial>)tag));
    public static final MaterialPredicate CASTABLE = MaterialPredicate.simple(material -> !MaterialCastingLookup.getCastingFluids(material).isEmpty());
    public static final MaterialPredicate COMPOSITE = MaterialPredicate.simple(material -> !MaterialCastingLookup.getCompositeFluids(material).isEmpty());

    default public IJsonPredicate<MaterialVariantId> inverted() {
        return LOADER.invert((IJsonPredicate)this);
    }

    public RecordLoadable<? extends MaterialPredicate> getLoader();

    public static MaterialPredicate simple(final Predicate<MaterialVariantId> predicate) {
        return (MaterialPredicate)SingletonLoader.singleton(loader -> new MaterialPredicate(){
            final /* synthetic */ RecordLoadable val$loader;
            {
                this.val$loader = recordLoadable;
            }

            public boolean matches(MaterialVariantId tool) {
                return predicate.test(tool);
            }

            @Override
            public RecordLoadable<? extends MaterialPredicate> getLoader() {
                return this.val$loader;
            }
        });
    }

    public static MaterialPredicate variant(MaterialVariantId material) {
        String variant = material.getVariant();
        if (variant.isEmpty()) {
            return new MaterialIdPredicate(material.getId());
        }
        if ("default".equals(variant)) {
            return new MaterialVariantPredicate(material.getId());
        }
        return new MaterialVariantPredicate(material);
    }

    public static IJsonPredicate<MaterialVariantId> tag(TagKey<IMaterial> tag) {
        return LOADER.tag(tag);
    }

    @SafeVarargs
    public static IJsonPredicate<MaterialVariantId> and(IJsonPredicate<MaterialVariantId> ... predicates) {
        return LOADER.and(List.of(predicates));
    }

    @SafeVarargs
    public static IJsonPredicate<MaterialVariantId> or(IJsonPredicate<MaterialVariantId> ... predicates) {
        return LOADER.or(List.of(predicates));
    }
}

