/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraftforge.common.TierSortingRegistry;
import slimeknights.mantle.client.ResourceColorManager;
import slimeknights.mantle.data.listener.ISafeManagerReloadListener;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.utils.Util;

public class HarvestTiers {
    private static final Map<Tier, Component> harvestLevelNames = Maps.newHashMap();
    public static final ISafeManagerReloadListener RELOAD_LISTENER = manager -> harvestLevelNames.clear();

    private HarvestTiers() {
    }

    private static MutableComponent makeLevelKey(Tier tier) {
        String key = Util.makeTranslationKey("harvest_tier", TierSortingRegistry.getName((Tier)tier));
        TextColor color = ResourceColorManager.getTextColor((String)key);
        return TConstruct.makeTranslation("stat", key).m_130938_(style -> style.m_131148_(color));
    }

    public static Component getName(Tier tier) {
        return harvestLevelNames.computeIfAbsent(tier, n -> HarvestTiers.makeLevelKey(tier));
    }

    public static Tier max(Tier a, Tier b) {
        List sorted = TierSortingRegistry.getSortedTiers();
        if (sorted.indexOf(b) > sorted.indexOf(a)) {
            return b;
        }
        return a;
    }

    public static Tier min(Tier a, Tier b) {
        List sorted = TierSortingRegistry.getSortedTiers();
        if (sorted.indexOf(b) < sorted.indexOf(a)) {
            return b;
        }
        return a;
    }

    public static Tier minTier() {
        List sortedTiers = TierSortingRegistry.getSortedTiers();
        if (sortedTiers.isEmpty()) {
            TConstruct.LOG.error("No sorted tiers exist, this should not happen");
            return Tiers.WOOD;
        }
        return (Tier)sortedTiers.get(0);
    }
}

