/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.component;

import java.util.Locale;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.fluid.FluidTransferHelper;
import slimeknights.mantle.util.BlockEntityHelper;
import slimeknights.tconstruct.smeltery.block.component.SearedBlock;
import slimeknights.tconstruct.smeltery.block.entity.ITankBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.component.TankBlockEntity;
import slimeknights.tconstruct.smeltery.item.TankItem;

public class SearedTankBlock
extends SearedBlock
implements TankBlockEntity.ITankBlock,
EntityBlock {
    public static final IntegerProperty LIGHT = IntegerProperty.m_61631_((String)"light", (int)0, (int)15);
    public static final ToIntFunction<BlockState> LIGHT_GETTER = state -> (Integer)state.m_61143_((Property)LIGHT);
    private final int capacity;
    private final PushReaction pushReaction;

    public SearedTankBlock(BlockBehaviour.Properties properties, int capacity, PushReaction pushReaction) {
        super(properties, true);
        this.capacity = capacity;
        this.pushReaction = pushReaction;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)LIGHT, (Comparable)Integer.valueOf(0)));
    }

    public SearedTankBlock(BlockBehaviour.Properties properties, int capacity) {
        this(properties, capacity, PushReaction.BLOCK);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{LIGHT});
    }

    public PushReaction getPistonPushReaction(BlockState pState) {
        return this.pushReaction;
    }

    @Deprecated
    public float m_7749_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1.0f;
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new TankBlockEntity(pPos, pState, this);
    }

    @Deprecated
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (FluidTransferHelper.interactWithTank((Level)world, (BlockPos)pos, (Player)player, (InteractionHand)hand, (BlockHitResult)hit)) {
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public static BlockState setLightLevel(BlockState state, BlockPlaceContext context) {
        ItemStack stack = context.m_43722_();
        FluidStack fluid = TankItem.getTank(stack, 1).getFluid();
        if (!fluid.isEmpty()) {
            state = (BlockState)state.m_61124_((Property)LIGHT, (Comparable)Integer.valueOf(fluid.getFluid().getFluidType().getLightLevel(fluid)));
        }
        return state;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return SearedTankBlock.setLightLevel(this.m_49966_(), context);
    }

    @Override
    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && (blockEntity = world.m_7702_(pos)) instanceof TankBlockEntity) {
            TankBlockEntity tank = (TankBlockEntity)blockEntity;
            tank.updateTank(nbt.m_128469_("tank"));
        }
        super.m_6402_(world, pos, state, placer, stack);
    }

    @Deprecated
    public boolean m_7278_(BlockState state) {
        return true;
    }

    @Deprecated
    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        return ITankBlockEntity.getComparatorInputOverride((LevelAccessor)worldIn, pos);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack stack = new ItemStack((ItemLike)this);
        BlockEntityHelper.get(TankBlockEntity.class, (BlockGetter)world, (BlockPos)pos).ifPresent(te -> te.setTankTag(stack));
        return stack;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    public static enum TankType implements StringRepresentable
    {
        FUEL_TANK(4000),
        FUEL_GAUGE(4000),
        INGOT_TANK(4320),
        INGOT_GAUGE(4320);

        private final int capacity;

        public String m_7912_() {
            return this.toString().toLowerCase(Locale.US);
        }

        private TankType(int capacity) {
            this.capacity = capacity;
        }

        public int getCapacity() {
            return this.capacity;
        }
    }
}

