/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.menu;

import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tables.block.entity.table.CraftingStationBlockEntity;
import slimeknights.tconstruct.tables.menu.TabbedContainerMenu;
import slimeknights.tconstruct.tables.menu.slot.PlayerSensitiveLazyResultSlot;

public class CraftingStationContainerMenu
extends TabbedContainerMenu<CraftingStationBlockEntity> {
    private final PlayerSensitiveLazyResultSlot resultSlot;

    public CraftingStationContainerMenu(int id, Inventory inv, @Nullable CraftingStationBlockEntity tile) {
        super((MenuType)TinkerTables.craftingStationContainer.get(), id, inv, tile);
        if (tile != null) {
            tile.syncRecipe(inv.f_35978_);
            for (int row = 0; row < 3; ++row) {
                for (int col = 0; col < 3; ++col) {
                    this.m_38897_(new Slot((Container)tile, col + row * 3, 30 + col * 18, 17 + row * 18));
                }
            }
            this.resultSlot = new PlayerSensitiveLazyResultSlot(inv.f_35978_, tile.getCraftingResult(), 124, 35);
            this.m_38897_(this.resultSlot);
            this.addChestSideInventory();
        } else {
            this.resultSlot = null;
        }
        this.addInventorySlots();
    }

    public CraftingStationContainerMenu(int id, Inventory inv, FriendlyByteBuf buf) {
        this(id, inv, (CraftingStationBlockEntity)CraftingStationContainerMenu.getTileEntityFromBuf((FriendlyByteBuf)buf, CraftingStationBlockEntity.class));
    }

    public ItemStack m_7648_(Player player, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot == this.resultSlot) {
            if (this.tile != null && slot.m_6657_()) {
                ItemStack original = slot.m_7993_().m_41777_();
                ItemStack result = ((CraftingStationBlockEntity)this.tile).getResultForPlayer(player);
                if (!result.m_41619_()) {
                    boolean nothingDone = true;
                    if (this.subContainers.size() > 0) {
                        nothingDone = this.refillAnyContainer(result, this.subContainers);
                    }
                    nothingDone &= this.moveToPlayerInventory(result);
                    if (this.subContainers.size() > 0) {
                        nothingDone &= this.moveToAnyContainer(result, this.subContainers);
                    }
                    if (!nothingDone) {
                        ((CraftingStationBlockEntity)this.tile).takeResult(player, result, result.m_41613_());
                        ((CraftingStationBlockEntity)this.tile).getCraftingResult().m_6211_();
                        return original;
                    }
                } else {
                    ((CraftingStationBlockEntity)this.tile).notifyUncraftable(player);
                }
            }
            return ItemStack.f_41583_;
        }
        return super.m_7648_(player, index);
    }

    public void m_6199_(Container inventoryIn) {
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        return slot != this.resultSlot && super.m_5882_(stack, slot);
    }
}

