/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modules.ranged;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.loadable.record.SingletonLoader;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.modifiers.hook.ranged.BowAmmoModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.capability.inventory.ToolInventoryCapability;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.tools.modules.InventorySelectionModule;

public enum TrickQuiverModule implements ModifierModule,
BowAmmoModifierHook,
GeneralInteractionModifierHook,
ModifierRemovalHook,
InventorySelectionModule
{
    INSTANCE;

    public static final SingletonLoader<TrickQuiverModule> LOADER;
    private static final List<ModuleHook<?>> DEFAULT_HOOKS;
    private static final ResourceLocation SELECTED_SLOT;
    private static final Component DISABLED;
    private static final String SELECTED;

    public RecordLoadable<TrickQuiverModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public ItemStack findAmmo(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, ItemStack standardAmmo, Predicate<ItemStack> ammoPredicate) {
        return modifier.getHook(ToolInventoryCapability.HOOK).getStack(tool, modifier, tool.getPersistentData().getInt(SELECTED_SLOT));
    }

    @Override
    public void shrinkAmmo(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, ItemStack ammo, int needed) {
        ammo.m_41774_(needed);
        modifier.getHook(ToolInventoryCapability.HOOK).setStack(tool, modifier, tool.getPersistentData().getInt(SELECTED_SLOT), ammo);
    }

    @Override
    public void onDisableSelection(IToolStackView tool, ModifierEntry modifier, Player player) {
        player.m_5661_(DISABLED, true);
    }

    @Override
    public void onInventorySelect(IToolStackView tool, ModifierEntry modifier, Player player, int newIndex, ItemStack stack) {
        player.m_5661_((Component)Component.m_237110_((String)SELECTED, (Object[])new Object[]{stack.m_41786_(), newIndex + 1}), true);
    }

    @Override
    public InteractionResult onToolUse(IToolStackView tool, ModifierEntry modifier, Player player, InteractionHand hand, InteractionSource source) {
        if (!player.m_6047_()) {
            return this.selectNext(tool, modifier, player, SELECTED_SLOT) ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    @Override
    @Nullable
    public Component onRemoved(IToolStackView tool, Modifier modifier) {
        tool.getPersistentData().remove(SELECTED_SLOT);
        return null;
    }

    static {
        LOADER = new SingletonLoader((Object)INSTANCE);
        DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.BOW_AMMO, ModifierHooks.GENERAL_INTERACT, ModifierHooks.REMOVE);
        SELECTED_SLOT = TConstruct.getResource("trick_quiver_selected");
        DISABLED = TConstruct.makeTranslation("modifier", "trick_quiver.disabled");
        SELECTED = TConstruct.makeTranslationKey("modifier", "trick_quiver.selected");
    }
}

