/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building;

import dev.huskuraft.effortless.api.core.GameMode;
import dev.huskuraft.effortless.api.core.Item;
import dev.huskuraft.effortless.api.core.ItemStack;
import dev.huskuraft.effortless.api.core.Player;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface Storage {
    public static final Storage FULL = new Storage(){

        @Override
        public Optional<ItemStack> searchTag(ItemStack stack) {
            return Optional.of(stack.copy());
        }

        @Override
        public Optional<ItemStack> search(Item item) {
            return Optional.of(item.getDefaultStack());
        }

        @Override
        public boolean consume(ItemStack stack) {
            return true;
        }

        @Override
        public int consume(Item item, int count) {
            return count;
        }

        @Override
        public int getCount(Item item) {
            return Integer.MAX_VALUE;
        }

        @Override
        public List<ItemStack> contents() {
            return List.of();
        }
    };
    public static final Storage EMPTY = new Storage(){

        @Override
        public Optional<ItemStack> searchTag(ItemStack stack) {
            return Optional.empty();
        }

        @Override
        public Optional<ItemStack> search(Item item) {
            return Optional.empty();
        }

        @Override
        public boolean consume(ItemStack stack) {
            return false;
        }

        @Override
        public int consume(Item item, int count) {
            return 0;
        }

        @Override
        public int getCount(Item item) {
            return 0;
        }

        @Override
        public List<ItemStack> contents() {
            return List.of();
        }
    };

    public static Storage create(final Player player, final boolean copy) {
        return new Storage(){
            private final Storage storage;
            {
                this.storage = switch (player.getGameMode()) {
                    default -> throw new IncompatibleClassChangeError();
                    case GameMode.SURVIVAL, GameMode.ADVENTURE -> {
                        if (copy) {
                            yield Storage.create(player.getInventory().getItems().stream().map(ItemStack::copy).toList(), false);
                        }
                        yield Storage.create(player.getInventory().getItems(), false);
                    }
                    case GameMode.CREATIVE -> Storage.merge(Storage.create(player.getInventory().getItems().stream().map(ItemStack::copy).toList(), true), Storage.full());
                    case GameMode.SPECTATOR -> Storage.empty();
                };
            }

            private Storage getStorage() {
                return this.storage;
            }

            @Override
            public Optional<ItemStack> searchTag(ItemStack stack) {
                return this.getStorage().searchTag(stack);
            }

            @Override
            public Optional<ItemStack> search(Item item) {
                return this.getStorage().search(item);
            }

            @Override
            public boolean consume(ItemStack stack) {
                return this.getStorage().consume(stack);
            }

            @Override
            public int consume(Item item, int count) {
                return this.getStorage().consume(item, count);
            }

            @Override
            public int getCount(Item item) {
                return this.getStorage().getCount(item);
            }

            @Override
            public List<ItemStack> contents() {
                return this.getStorage().contents();
            }
        };
    }

    public static Storage merge(final Storage ... storages) {
        return new Storage(){

            @Override
            public Optional<ItemStack> searchTag(ItemStack stack) {
                for (Storage storage : storages) {
                    Optional<ItemStack> found = storage.searchTag(stack);
                    if (!found.isPresent()) continue;
                    return found;
                }
                return Optional.empty();
            }

            @Override
            public Optional<ItemStack> search(Item item) {
                for (Storage storage : storages) {
                    Optional<ItemStack> found = storage.search(item);
                    if (!found.isPresent()) continue;
                    return found;
                }
                return Optional.empty();
            }

            @Override
            public boolean consume(ItemStack stack) {
                for (Storage storage : storages) {
                    if (!storage.consume(stack)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public int consume(Item item, int count) {
                int consumed = 0;
                for (Storage storage : storages) {
                    if ((consumed += storage.consume(item, count - consumed)) < count) continue;
                    return consumed;
                }
                return consumed;
            }

            @Override
            public int getCount(Item item) {
                long result = 0L;
                for (Storage storage : storages) {
                    result += (long)storage.getCount(item);
                }
                return (int)Math.min(result, Integer.MAX_VALUE);
            }

            @Override
            public List<ItemStack> contents() {
                return Arrays.stream(storages).map(Storage::contents).flatMap(Collection::stream).toList();
            }
        };
    }

    public static Storage full() {
        return FULL;
    }

    public static Storage empty() {
        return EMPTY;
    }

    public static Storage create(final List<ItemStack> itemStacks, final boolean infinite) {
        return new Storage(){
            private final Map<Item, ItemStack> cache = new HashMap<Item, ItemStack>();

            @Override
            public Optional<ItemStack> search(Item item) {
                ItemStack last = this.cache.get(item);
                if (last != null && !last.isEmpty()) {
                    return Optional.of(last).map(stack -> infinite ? stack.copy() : stack);
                }
                for (ItemStack itemStack : itemStacks) {
                    if (!itemStack.getItem().equals(item) || itemStack.isEmpty()) continue;
                    this.cache.put(item, itemStack);
                    return Optional.of(itemStack).map(stack -> infinite ? stack.copy() : stack);
                }
                this.cache.put(item, ItemStack.empty());
                return Optional.empty();
            }

            @Override
            public Optional<ItemStack> searchTag(ItemStack itemStack) {
                return Optional.empty();
            }

            @Override
            public boolean consume(ItemStack itemStack) {
                Optional<ItemStack> found = this.searchTag(itemStack);
                if (found.isEmpty()) {
                    return false;
                }
                if (infinite) {
                    return true;
                }
                if (itemStack.getCount() > found.get().getCount()) {
                    return false;
                }
                found.get().decrease(itemStack.getCount());
                return true;
            }

            @Override
            public int consume(Item item, int count) {
                if (infinite) {
                    return count;
                }
                int consumed = 0;
                for (ItemStack content : this.contents()) {
                    if (content.getItem().equals(item)) {
                        int available = Math.min(content.getCount(), count - consumed);
                        content.decrease(available);
                        consumed += available;
                    }
                    if (consumed < count) continue;
                    return consumed;
                }
                return consumed;
            }

            @Override
            public int getCount(Item item) {
                if (infinite) {
                    return Integer.MAX_VALUE;
                }
                int result = 0;
                for (ItemStack content : this.contents()) {
                    if (!content.getItem().equals(item)) continue;
                    result += content.getCount();
                }
                return result;
            }

            @Override
            public List<ItemStack> contents() {
                return itemStacks;
            }
        };
    }

    public Optional<ItemStack> searchTag(ItemStack var1);

    public Optional<ItemStack> search(Item var1);

    public boolean consume(ItemStack var1);

    public int consume(Item var1, int var2);

    public int getCount(Item var1);

    public List<ItemStack> contents();
}

