/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.operation.block;

import dev.huskuraft.effortless.Effortless;
import dev.huskuraft.effortless.api.core.BlockEntity;
import dev.huskuraft.effortless.api.core.BlockState;
import dev.huskuraft.effortless.api.tag.RecordTag;
import dev.huskuraft.effortless.building.operation.OperationResult;
import dev.huskuraft.effortless.building.operation.block.BlockOperation;
import dev.huskuraft.effortless.building.operation.block.BlockOperationResultType;
import javax.annotation.Nullable;

public abstract class BlockOperationResult
extends OperationResult {
    protected final BlockOperation operation;
    protected final BlockOperationResultType result;
    protected final BlockState blockStateBeforeOp;
    protected final BlockState blockStateAfterOp;
    protected final RecordTag entityTagBeforeOp;
    protected final RecordTag entityTagAfterOp;

    protected BlockOperationResult(BlockOperation operation, BlockOperationResultType result, BlockState blockStateBeforeOp, BlockState blockStateAfterOp, RecordTag entityTagBeforeOp, RecordTag entityTagAfterOp) {
        this.operation = operation;
        this.result = result;
        this.blockStateBeforeOp = blockStateBeforeOp;
        this.blockStateAfterOp = blockStateAfterOp;
        this.entityTagBeforeOp = entityTagBeforeOp;
        this.entityTagAfterOp = entityTagAfterOp;
    }

    protected BlockOperationResult(BlockOperation operation, BlockOperationResultType result, BlockState blockStateBeforeOp, BlockState blockStateAfterOp) {
        this.operation = operation;
        this.result = result;
        this.blockStateBeforeOp = blockStateBeforeOp;
        this.blockStateAfterOp = blockStateAfterOp;
        this.entityTagBeforeOp = null;
        this.entityTagAfterOp = null;
    }

    @Override
    public BlockOperation getOperation() {
        return this.operation;
    }

    @Nullable
    public final BlockState getBlockStateToBreak() {
        return this.blockStateBeforeOp;
    }

    @Nullable
    public final BlockState getBlockStatePlaced() {
        return this.blockStateAfterOp;
    }

    @Nullable
    public final BlockState getBlockStateToPlace() {
        return this.getOperation().getBlockState();
    }

    @Nullable
    public RecordTag getEntityTagToBreak() {
        return this.entityTagBeforeOp;
    }

    @Nullable
    public RecordTag getEntityTagPlaced() {
        return this.entityTagAfterOp;
    }

    @Nullable
    public RecordTag getEntityTagToPlace() {
        return this.getOperation().getEntityTag();
    }

    @Nullable
    public BlockEntity getBlockEntityToBreak() {
        return this.getBlockEntity(this.getBlockStateToBreak(), this.getEntityTagToBreak());
    }

    @Nullable
    public BlockEntity getBlockEntityPlaced() {
        return this.getBlockEntity(this.getBlockStatePlaced(), this.getEntityTagPlaced());
    }

    @Nullable
    public BlockEntity getBlockEntityToPlace() {
        return this.getBlockEntity(this.getBlockStateToPlace(), this.getEntityTagToPlace());
    }

    private BlockEntity getBlockEntity(BlockState blockState, RecordTag entityTag) {
        if (blockState == null) {
            return null;
        }
        BlockEntity blockEntity = blockState.getEntity(this.getOperation().getBlockPosition());
        if (blockEntity == null) {
            return null;
        }
        if (entityTag != null) {
            try {
                blockEntity.setTag(entityTag);
            }
            catch (Exception e) {
                Effortless.LOGGER.warn("Fail to set block entity tag for: {}", blockEntity.refs());
            }
        }
        return blockEntity;
    }

    @Nullable
    public final BlockState getBlockStateForRenderer() {
        if (this.getBlockStateToBreak() == null || this.getBlockStateToPlace() == null) {
            return null;
        }
        if (!this.getBlockStateToBreak().isAir() && this.getBlockStateToPlace().isAir()) {
            return this.getBlockStateToBreak();
        }
        return this.getBlockStateToPlace();
    }

    @Nullable
    public final BlockEntity getBlockEntityForRenderer() {
        return this.getBlockEntityToPlace();
    }

    @Override
    public int getAffectedBlockCount() {
        return this.result().success() ? 1 : 0;
    }

    public BlockOperationResultType result() {
        return this.result;
    }
}

