/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.pattern;

import dev.huskuraft.effortless.api.core.BlockEntity;
import dev.huskuraft.effortless.api.core.BlockInteraction;
import dev.huskuraft.effortless.api.core.BlockPosition;
import dev.huskuraft.effortless.api.core.Direction;
import dev.huskuraft.effortless.api.math.Vector3d;
import dev.huskuraft.effortless.api.math.Vector3i;

public class MoveContext {
    private final Vector3i amount;
    private final PositionType positionType;

    private MoveContext(Vector3i amount, PositionType positionType) {
        this.amount = amount;
        this.positionType = positionType;
    }

    public static MoveContext relative(Vector3i amount) {
        return new MoveContext(amount, PositionType.RELATIVE);
    }

    public static MoveContext relative(int x, int y, int z) {
        return new MoveContext(new Vector3i(x, y, z), PositionType.RELATIVE);
    }

    public static MoveContext absolute(Vector3i amount) {
        return new MoveContext(amount, PositionType.ABSOLUTE);
    }

    public BlockInteraction move(BlockInteraction blockInteraction) {
        Direction direction = blockInteraction.getDirection();
        BlockPosition blockPosition = this.move(blockInteraction.getBlockPosition());
        Vector3d location = blockInteraction.getPosition().add(blockPosition.sub(blockInteraction.getBlockPosition()).toVector3d());
        return new BlockInteraction(location, direction, blockPosition, blockInteraction.isInside());
    }

    public Vector3i move(Vector3i vector) {
        return switch (this.positionType.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> vector.add(this.amount);
            case 1 -> this.amount;
        };
    }

    public BlockPosition move(BlockPosition blockPosition) {
        return switch (this.positionType.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> blockPosition.add(this.amount);
            case 1 -> BlockPosition.at(this.amount);
        };
    }

    public BlockEntity move(BlockEntity blockEntity) {
        return blockEntity;
    }

    public static enum PositionType {
        RELATIVE,
        ABSOLUTE;

    }
}

