/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.session;

import dev.huskuraft.effortless.api.core.BlockInteraction;
import dev.huskuraft.effortless.api.core.BlockState;
import dev.huskuraft.effortless.api.core.InteractionHand;
import dev.huskuraft.effortless.api.core.Items;
import dev.huskuraft.effortless.api.core.Player;
import dev.huskuraft.effortless.api.core.World;
import dev.huskuraft.effortless.api.platform.Entrance;
import dev.huskuraft.effortless.api.tag.RecordTag;
import dev.huskuraft.effortless.building.BuildState;
import dev.huskuraft.effortless.building.BuildType;
import dev.huskuraft.effortless.building.Context;
import dev.huskuraft.effortless.building.Storage;
import dev.huskuraft.effortless.building.clipboard.Snapshot;
import dev.huskuraft.effortless.building.interceptor.BuildInterceptor;
import dev.huskuraft.effortless.building.interceptor.FtbChunksInterceptor;
import dev.huskuraft.effortless.building.interceptor.OpenPacInterceptor;
import dev.huskuraft.effortless.building.operation.OperationFilter;
import dev.huskuraft.effortless.building.operation.batch.BatchOperation;
import dev.huskuraft.effortless.building.operation.batch.BatchOperationResult;
import dev.huskuraft.effortless.building.operation.batch.DeferredBatchOperation;
import dev.huskuraft.effortless.building.operation.block.BlockInteractOperation;
import dev.huskuraft.effortless.building.operation.block.BlockOperation;
import dev.huskuraft.effortless.building.operation.block.BlockStateCopyOperation;
import dev.huskuraft.effortless.building.operation.block.BlockStateCopyOperationResult;
import dev.huskuraft.effortless.building.operation.block.BlockStateUpdateOperation;
import dev.huskuraft.effortless.building.pattern.Transformer;
import dev.huskuraft.effortless.building.pattern.randomize.ItemRandomizer;
import dev.huskuraft.effortless.building.session.Session;
import dev.huskuraft.effortless.networking.packets.player.PlayerSnapshotCapturePacket;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BatchBuildSession
implements Session {
    private final Entrance entrance;
    private final Player player;
    private final World world;
    private final Context context;
    private final List<BuildInterceptor> interceptors;
    private BatchOperationResult lastResult;

    public BatchBuildSession(Entrance entrance, Player player, Context context) {
        this.entrance = entrance;
        this.world = player.getWorld();
        this.player = player;
        this.context = context;
        this.interceptors = BatchBuildSession.createInterceptors(entrance, player.getWorld(), player, context);
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    private static List<BuildInterceptor> createInterceptors(Entrance entrance, World world, Player player, Context context) {
        return Stream.of(new OpenPacInterceptor(entrance), new FtbChunksInterceptor(entrance)).filter(BuildInterceptor::isEnabled).collect(Collectors.toUnmodifiableList());
    }

    public Entrance getEntrance() {
        return this.entrance;
    }

    protected BlockOperation createBlockPlaceOperationFromInteraction(Player player, World world, Context context, Storage storage, BlockInteraction interaction, BlockState blockState, RecordTag entityTag) {
        return new BlockStateUpdateOperation(this, context, storage, interaction, blockState, entityTag, context.extras().extras());
    }

    protected BlockOperation createBlockBreakOperationFromInteraction(Player player, World world, Context context, Storage storage, BlockInteraction interaction) {
        return new BlockStateUpdateOperation(this, context, storage, interaction, Items.AIR.item().getBlock().getDefaultBlockState(), null, context.extras().extras());
    }

    protected BlockOperation createBlockInteractOperationFromInteraction(Player player, World world, Context context, Storage storage, BlockInteraction interaction) {
        return new BlockInteractOperation(this, context, storage, interaction, context.extras().extras());
    }

    protected BlockOperation createBlockCopyOperationFromInteraction(Player player, World world, Context context, Storage storage, BlockInteraction interaction) {
        return new BlockStateCopyOperation(this, context, storage, interaction, context.extras().extras());
    }

    protected BatchOperation create(World world, Player player, Context context) {
        Storage storage = Storage.create(player, context.isPreviewType() || context.isBuildClientType());
        ItemRandomizer inHandTransformer = ItemRandomizer.single(null, player.getItemStack(InteractionHand.MAIN).getItem());
        BatchOperation operations = new DeferredBatchOperation(context, () -> switch (context.buildState()) {
            default -> throw new IncompatibleClassChangeError();
            case BuildState.IDLE -> Stream.empty();
            case BuildState.BREAK_BLOCK -> context.collectInteractions().map(interaction -> this.createBlockBreakOperationFromInteraction(player, world, context, storage, (BlockInteraction)interaction));
            case BuildState.PLACE_BLOCK -> context.collectInteractions().map(interaction -> this.createBlockPlaceOperationFromInteraction(player, world, context, storage, (BlockInteraction)interaction, Items.AIR.item().getBlock().getDefaultBlockState(), null));
            case BuildState.INTERACT_BLOCK -> context.collectInteractions().map(interaction -> this.createBlockInteractOperationFromInteraction(player, world, context, storage, (BlockInteraction)interaction));
            case BuildState.COPY_STRUCTURE -> context.collectInteractions().map(interaction -> this.createBlockCopyOperationFromInteraction(player, world, context, storage, (BlockInteraction)interaction));
            case BuildState.PASTE_STRUCTURE -> context.clipboard().snapshot().blockData().stream().map(blockSnapshot -> {
                BlockInteraction interaction = context.getInteraction(0).withBlockPosition(context.getInteraction(0).blockPosition().add(blockSnapshot.blockPosition()));
                return this.createBlockPlaceOperationFromInteraction(player, world, context, storage, interaction, blockSnapshot.blockState(), blockSnapshot.entityTag());
            });
        });
        if (context.buildState() == BuildState.PLACE_BLOCK) {
            operations = (BatchOperation)inHandTransformer.transform(operations);
        }
        if (context.pattern().enabled()) {
            for (Transformer transformer : context.pattern().transformers()) {
                if (!transformer.isValid()) continue;
                operations = (BatchOperation)transformer.transform(operations);
            }
        }
        operations = operations.flatten().filter(Objects::nonNull).filter(OperationFilter.distinctBlockOperations());
        return operations;
    }

    @Override
    public List<BuildInterceptor> getInterceptors() {
        return this.interceptors;
    }

    @Override
    public synchronized BatchOperationResult commit() {
        if (this.lastResult == null) {
            this.lastResult = this.create(this.world, this.player, this.context).commit();
            this.saveClipboard();
        }
        return this.lastResult;
    }

    protected void saveClipboard() {
        if (this.world.isClient()) {
            return;
        }
        if (this.context.buildState() != BuildState.COPY_STRUCTURE) {
            return;
        }
        if (this.context.buildType() != BuildType.BUILD) {
            return;
        }
        if (!this.context.clipboard().enabled()) {
            return;
        }
        Snapshot snapshot = new Snapshot("", System.currentTimeMillis(), this.lastResult.getResults().stream().map(BlockStateCopyOperationResult.class::cast).map(BlockStateCopyOperationResult::getBlockData).filter(blockData -> this.context.clipboard().copyAir() || blockData.blockState() != null && !blockData.blockState().isAir()).toList());
        this.getEntrance().getChannel().sendPacket(new PlayerSnapshotCapturePacket(this.player.getId(), snapshot), this.player);
    }
}

