/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.structure.builder.standard;

import com.google.common.collect.Sets;
import dev.huskuraft.effortless.api.core.BlockInteraction;
import dev.huskuraft.effortless.api.core.BlockPosition;
import dev.huskuraft.effortless.api.core.Player;
import dev.huskuraft.effortless.api.math.MathUtils;
import dev.huskuraft.effortless.building.Context;
import dev.huskuraft.effortless.building.structure.BuildMode;
import dev.huskuraft.effortless.building.structure.builder.BlockStructure;
import dev.huskuraft.effortless.building.structure.builder.standard.Single;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;

public record DiagonalLine() implements BlockStructure
{
    private static Set<BlockPosition> getDiagonalLine(List<BlockPosition> positions, int radius, boolean hollow) {
        Set<Object> result = Sets.newLinkedHashSet();
        for (int i = 0; !positions.isEmpty() && i < positions.size() - 1; ++i) {
            int domstep;
            int dz;
            int dy;
            BlockPosition pos1 = positions.get(i);
            BlockPosition pos2 = positions.get(i + 1);
            int x1 = pos1.x();
            int y1 = pos1.y();
            int z1 = pos1.z();
            int x2 = pos2.x();
            int y2 = pos2.y();
            int z2 = pos2.z();
            int tipx = x1;
            int tipy = y1;
            int tipz = z1;
            int dx = MathUtils.abs(x2 - x1);
            if (dx + (dy = MathUtils.abs(y2 - y1)) + (dz = MathUtils.abs(z2 - z1)) == 0) {
                result.add(BlockPosition.at(tipx, tipy, tipz));
                continue;
            }
            int dm = MathUtils.max(MathUtils.max(dx, dy), dz);
            if (dm == dx) {
                for (domstep = 0; domstep <= dx; ++domstep) {
                    tipx = x1 + domstep * (x2 - x1 > 0 ? 1 : -1);
                    tipy = (int)MathUtils.round((double)y1 + (double)domstep * (double)dy / (double)dx * (double)(y2 - y1 > 0 ? 1 : -1));
                    tipz = (int)MathUtils.round((double)z1 + (double)domstep * (double)dz / (double)dx * (double)(z2 - z1 > 0 ? 1 : -1));
                    result.add(BlockPosition.at(tipx, tipy, tipz));
                }
                continue;
            }
            if (dm == dy) {
                for (domstep = 0; domstep <= dy; ++domstep) {
                    tipy = y1 + domstep * (y2 - y1 > 0 ? 1 : -1);
                    tipx = (int)MathUtils.round((double)x1 + (double)domstep * (double)dx / (double)dy * (double)(x2 - x1 > 0 ? 1 : -1));
                    tipz = (int)MathUtils.round((double)z1 + (double)domstep * (double)dz / (double)dy * (double)(z2 - z1 > 0 ? 1 : -1));
                    result.add(BlockPosition.at(tipx, tipy, tipz));
                }
                continue;
            }
            for (domstep = 0; domstep <= dz; ++domstep) {
                tipz = z1 + domstep * (z2 - z1 > 0 ? 1 : -1);
                tipy = (int)MathUtils.round((double)y1 + (double)domstep * (double)dy / (double)dz * (double)(y2 - y1 > 0 ? 1 : -1));
                tipx = (int)MathUtils.round((double)x1 + (double)domstep * (double)dx / (double)dz * (double)(x2 - x1 > 0 ? 1 : -1));
                result.add(BlockPosition.at(tipx, tipy, tipz));
            }
        }
        result = BlockStructure.getBallooned((Set<BlockPosition>)result, radius);
        if (hollow) {
            result = BlockStructure.getHollowed((Set<BlockPosition>)result);
        }
        return result;
    }

    protected static Stream<BlockPosition> collectDiagonalLine(Context context) {
        return DiagonalLine.getDiagonalLine(context.getPositions(), 0, false).stream();
    }

    public static Stream<BlockPosition> collectDiagonalLine(List<BlockPosition> positions, int radius, boolean hollow) {
        return DiagonalLine.getDiagonalLine(positions, 0, false).stream();
    }

    public static Stream<BlockPosition> collectDiagonalLine(BlockPosition pos1, BlockPosition pos2, int radius, boolean hollow) {
        return DiagonalLine.getDiagonalLine(List.of(pos1, pos2), 0, false).stream();
    }

    @Override
    public BlockInteraction trace(Player player, Context context, int index) {
        return switch (index) {
            case 0 -> Single.traceSingle(player, context);
            case 1 -> Single.traceSingle(player, context);
            default -> null;
        };
    }

    @Override
    public Stream<BlockPosition> collect(Context context, int index) {
        return switch (index) {
            case 1 -> Single.collectSingleBlocks(context);
            case 2 -> DiagonalLine.collectDiagonalLine(context);
            default -> Stream.empty();
        };
    }

    @Override
    public int traceSize(Context context) {
        return 2;
    }

    @Override
    public BuildMode getMode() {
        return BuildMode.DIAGONAL_LINE;
    }
}

