/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.fabric.events;

import com.google.auto.service.AutoService;
import dev.huskuraft.effortless.api.core.InteractionType;
import dev.huskuraft.effortless.api.events.impl.ClientEventRegistry;
import dev.huskuraft.effortless.api.events.lifecycle.ClientTick;
import dev.huskuraft.effortless.api.input.InputKey;
import dev.huskuraft.effortless.fabric.core.MinecraftConvertor;
import dev.huskuraft.effortless.fabric.events.common.ClientRenderEvents;
import dev.huskuraft.effortless.fabric.events.common.ClientShadersEvents;
import dev.huskuraft.effortless.fabric.events.common.InteractionInputEvents;
import dev.huskuraft.effortless.fabric.events.common.KeyboardInputEvents;
import dev.huskuraft.effortless.fabric.events.common.PlatformLifecycleEvents;
import dev.huskuraft.effortless.fabric.networking.FabricNetworking;
import dev.huskuraft.effortless.fabric.platform.MinecraftClient;
import dev.huskuraft.effortless.fabric.renderer.MinecraftRenderer;
import dev.huskuraft.effortless.fabric.renderer.MinecraftShader;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_293;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_5944;

@AutoService(value={ClientEventRegistry.class})
public class FabricClientEventRegistry
extends ClientEventRegistry {
    public FabricClientEventRegistry() {
        PlatformLifecycleEvents.CLIENT_START.register(() -> {
            this.getClientStartEvent().invoker().onClientStart(new MinecraftClient(class_310.method_1551()));
            this.getRegisterNetworkEvent().invoker().onRegisterNetwork(FabricNetworking::register);
            this.getRegisterKeysEvent().invoker().onRegisterKeys(key1 -> KeyBindingHelper.registerKeyBinding((class_304)((class_304)key1.getKeyBinding().reference())));
        });
        ClientShadersEvents.REGISTER.register((provider, sink) -> this.getRegisterShaderEvent().invoker().onRegisterShader((resource, format, consumer) -> sink.register(new class_5944(provider, resource.getPath(), (class_293)format.reference()), shaderInstance -> consumer.accept(new MinecraftShader((class_5944)shaderInstance)))));
        ClientTickEvents.START_CLIENT_TICK.register(minecraft -> this.getClientTickEvent().invoker().onClientTick(new MinecraftClient(minecraft), ClientTick.Phase.START));
        ClientTickEvents.END_CLIENT_TICK.register(minecraft -> this.getClientTickEvent().invoker().onClientTick(new MinecraftClient(minecraft), ClientTick.Phase.END));
        WorldRenderEvents.AFTER_ENTITIES.register(context -> this.getRenderWorldEvent().invoker().onRenderWorld(new MinecraftRenderer(context.matrixStack()), context.tickDelta()));
        ClientRenderEvents.GUI.register((guiGraphics, f) -> this.getRenderGuiEvent().invoker().onRenderGui(new MinecraftRenderer(guiGraphics.method_51448()), f));
        KeyboardInputEvents.KEY_INPUT.register((key, scanCode, action, modifiers) -> this.getKeyInputEvent().invoker().onKeyInput(new InputKey(key, scanCode, action, modifiers)));
        InteractionInputEvents.ATTACK.register((player, hand) -> this.getInteractionInputEvent().invoker().onInteractionInput(InteractionType.ATTACK, MinecraftConvertor.fromPlatformInteractionHand(hand)).interruptsFurtherEvaluation());
        InteractionInputEvents.USE_ITEM.register((player, hand) -> this.getInteractionInputEvent().invoker().onInteractionInput(InteractionType.USE_ITEM, MinecraftConvertor.fromPlatformInteractionHand(hand)).interruptsFurtherEvaluation());
    }
}

