/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.screen.item;

import dev.huskuraft.effortless.api.core.Item;
import dev.huskuraft.effortless.api.core.ItemStack;
import dev.huskuraft.effortless.api.core.Items;
import dev.huskuraft.effortless.api.gui.AbstractPanelScreen;
import dev.huskuraft.effortless.api.gui.button.Button;
import dev.huskuraft.effortless.api.gui.text.TextWidget;
import dev.huskuraft.effortless.api.platform.Entrance;
import dev.huskuraft.effortless.api.text.Text;
import dev.huskuraft.effortless.screen.item.EffortlessItemPickerScreen;
import dev.huskuraft.effortless.screen.item.ItemStackList;
import java.util.List;
import java.util.function.Consumer;

public class EffortlessItemsScreen
extends AbstractPanelScreen {
    private final Consumer<List<Item>> consumer;
    private TextWidget titleTextWidget;
    private ItemStackList entries;
    private Button deleteButton;
    private Button clearButton;
    private Button addButton;
    private Button cancelButton;
    private Button saveButton;
    private List<Item> originalItems;
    private List<Item> items;

    public EffortlessItemsScreen(Entrance entrance, Text title, List<Item> items, Consumer<List<Item>> consumer) {
        super(entrance, title, 264, 238);
        this.consumer = consumer;
        this.originalItems = items.stream().distinct().toList();
        this.items = items.stream().distinct().toList();
    }

    @Override
    public void onCreate() {
        this.titleTextWidget = this.addWidget(new TextWidget(this.getEntrance(), this.getLeft() + this.getWidth() / 2, this.getTop() + 18 - 10, this.getScreenTitle().withColor(0x404040), TextWidget.Gravity.CENTER));
        this.entries = this.addWidget(new ItemStackList(this.getEntrance(), this.getLeft() + 6, this.getTop() + 18, this.getWidth() - 12 - 8, this.getHeight() - 18 - 54));
        this.entries.setAlwaysShowScrollbar(true);
        this.deleteButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.delete"), button -> {
            if (this.entries.hasSelected()) {
                this.entries.deleteSelected();
            }
        }).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 1.0f, 0.0f, 0.33333334f).build());
        this.clearButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.clear"), button -> this.entries.clear()).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 1.0f, 0.33333334f, 0.33333334f).build());
        this.addButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.add"), button -> new EffortlessItemPickerScreen(this.getEntrance(), item -> item != Items.AIR.item(), item -> {
            if (item != null && !this.items.contains(item)) {
                this.entries.insertSelected(item.getDefaultStack());
                this.onReload();
            }
        }).attach()).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 1.0f, 0.6666667f, 0.33333334f).build());
        this.entries.reset(this.items.stream().map(Item::getDefaultStack).toList());
        this.cancelButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.cancel"), button -> this.detach()).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 0.0f, 0.0f, 0.5f).build());
        this.saveButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.save"), button -> {
            this.consumer.accept(this.items);
            this.detach();
        }).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 0.0f, 0.5f, 0.5f).build());
    }

    @Override
    public void onReload() {
        this.items = this.entries.items().stream().map(ItemStack::getItem).toList();
        this.deleteButton.setActive(this.entries.hasSelected());
        this.clearButton.setActive(!this.entries.items().isEmpty());
    }
}

