/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.screen.settings;

import dev.huskuraft.effortless.EffortlessClient;
import dev.huskuraft.effortless.api.gui.AbstractPanelScreen;
import dev.huskuraft.effortless.api.gui.button.Button;
import dev.huskuraft.effortless.api.gui.text.TextWidget;
import dev.huskuraft.effortless.api.gui.tooltip.TooltipHelper;
import dev.huskuraft.effortless.api.platform.Entrance;
import dev.huskuraft.effortless.api.text.ChatFormatting;
import dev.huskuraft.effortless.api.text.Text;
import dev.huskuraft.effortless.networking.packets.player.PlayerPermissionCheckPacket;
import dev.huskuraft.effortless.screen.builer.EffortlessBuilderSettingsScreen;
import dev.huskuraft.effortless.screen.general.EffortlessGlobalGeneralSettingsScreen;
import dev.huskuraft.effortless.screen.settings.EffortlessNotAnOperatorScreen;
import dev.huskuraft.effortless.screen.settings.EffortlessSessionStatusScreen;
import dev.huskuraft.effortless.session.config.ConstraintConfig;
import java.util.ArrayList;

public class EffortlessSettingsScreen
extends AbstractPanelScreen {
    private Button constraintButton;
    private Button buildertButton;

    public EffortlessSettingsScreen(Entrance entrance) {
        super(entrance, Text.translate("effortless.settings.title"), 192, 96);
    }

    @Override
    protected EffortlessClient getEntrance() {
        return (EffortlessClient)super.getEntrance();
    }

    @Override
    public void onCreate() {
        this.addWidget(new TextWidget(this.getEntrance(), this.getLeft() + this.getWidth() / 2, this.getTop() + 18 - 10, this.getScreenTitle().withColor(0x404040), TextWidget.Gravity.CENTER));
        this.constraintButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.general_settings.title"), button -> {
            if (!this.getEntrance().getSessionManager().isSessionValid()) {
                this.getEntrance().getClient().execute(() -> new EffortlessSessionStatusScreen(this.getEntrance()).attach());
            } else {
                this.getEntrance().getChannel().sendPacket(new PlayerPermissionCheckPacket(this.getEntrance().getClient().getPlayer().getId()), packet -> {
                    if (packet.granted()) {
                        this.getEntrance().getClient().execute(() -> new EffortlessGlobalGeneralSettingsScreen(this.getEntrance(), this.getEntrance().getSessionManager().getServerSessionConfigOrEmpty().getGlobalConfig(), config -> this.getEntrance().getSessionManager().updateGlobalConfig((ConstraintConfig)config)).attach());
                    } else {
                        this.getEntrance().getClient().execute(() -> new EffortlessNotAnOperatorScreen(this.getEntrance()).attach());
                    }
                });
            }
        }).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 2.0f, 0.0f, 1.0f).build());
        this.buildertButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.builder_settings.title"), button -> new EffortlessBuilderSettingsScreen(this.getEntrance()).attach()).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 1.0f, 0.0f, 1.0f).build());
        this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.done"), button -> this.detach()).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 0.0f, 0.0f, 1.0f).build());
    }

    @Override
    public void onReload() {
        ArrayList<Text> constraintTooltip = new ArrayList<Text>();
        constraintTooltip.add(Text.translate("effortless.general_settings.title").withStyle(ChatFormatting.WHITE));
        constraintTooltip.add(TooltipHelper.holdShiftForSummary());
        if (TooltipHelper.isSummaryButtonDown()) {
            constraintTooltip.add(Text.empty());
            constraintTooltip.addAll(TooltipHelper.wrapLines(this.getTypeface(), Text.translate("effortless.general_settings.tooltip", Text.text("[%s]".formatted("effortless.toml")).withStyle(ChatFormatting.GOLD)).withStyle(ChatFormatting.GRAY)));
        }
        this.constraintButton.setTooltip(constraintTooltip);
        ArrayList<Text> builderTooltip = new ArrayList<Text>();
        builderTooltip.add(Text.translate("effortless.builder_settings.title").withStyle(ChatFormatting.WHITE));
        builderTooltip.add(TooltipHelper.holdShiftForSummary());
        if (TooltipHelper.isSummaryButtonDown()) {
            builderTooltip.add(Text.empty());
            builderTooltip.addAll(TooltipHelper.wrapLines(this.getTypeface(), Text.translate("effortless.builder_settings.tooltip", Text.text("[%s]".formatted("effortless-client.toml")).withStyle(ChatFormatting.GOLD)).withStyle(ChatFormatting.GRAY)));
        }
        this.buildertButton.setTooltip(builderTooltip);
    }
}

