/*
 * Decompiled with CFR 0.152.
 */
package artifacts.forge.mixin.item.wearable;

import artifacts.Artifacts;
import artifacts.item.ArtifactItem;
import artifacts.item.wearable.ArtifactAttributeModifier;
import artifacts.item.wearable.WearableArtifactItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import top.theillusivec4.curios.api.CuriosApi;

@Mixin(value={WearableArtifactItem.class})
public abstract class WearableArtifactItemMixin
extends ArtifactItem {
    @Shadow
    public abstract List<ArtifactAttributeModifier> getAttributeModifiers();

    @Override
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltipList, TooltipFlag flags) {
        super.m_7373_(stack, world, tooltipList, flags);
        Set curioTags = CuriosApi.getItemStackSlots((ItemStack)stack, (boolean)true).keySet();
        ArrayList slots = new ArrayList(curioTags);
        if (!Artifacts.CONFIG.client.showTooltips || this.isCosmetic() || slots.isEmpty() || this.getAttributeModifiers().isEmpty()) {
            return;
        }
        tooltipList.add((Component)Component.m_237119_());
        String identifier = slots.contains("curio") ? "curio" : (String)slots.get(0);
        tooltipList.add((Component)Component.m_237115_((String)("curios.modifiers." + identifier)));
        for (ArtifactAttributeModifier modifier : this.getAttributeModifiers()) {
            double amount = modifier.getAmount();
            if (modifier.getOperation() == AttributeModifier.Operation.ADDITION) {
                if (modifier.getAttribute().equals(Attributes.f_22278_)) {
                    amount *= 10.0;
                }
            } else {
                amount *= 100.0;
            }
            tooltipList.add((Component)Component.m_237110_((String)("attribute.modifier.plus." + modifier.getOperation().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(amount), Component.m_237115_((String)modifier.getAttribute().m_22087_())}).m_130940_(ChatFormatting.BLUE));
        }
    }
}

