/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client.gui;

import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.p3pp3rf1y.sophisticatedcore.client.gui.StorageScreenBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.TextBox;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.util.Easing;

class SearchBox
extends TextBox {
    private static final List<Component> TOOLTIP = List.of(Component.m_237115_((String)TranslationHelper.INSTANCE.translGui("text_box.search_box")), Component.m_237115_((String)TranslationHelper.INSTANCE.translGui("text_box.search_box_detail")).m_130940_(ChatFormatting.GRAY));
    public static final String MAGNIFYING_GLASS = "\ud83d\udd0d";
    public static final int UNFOCUSED_COLOR = 0xBBBBBB;
    private final StorageScreenBase<?> screen;
    private long lastFocusChangeTime = 0L;
    private final int maximizedX;
    private final int maximizedWidth;

    public SearchBox(Position position, Dimension dimension, StorageScreenBase<?> screen) {
        super(position, dimension);
        this.screen = screen;
        this.setTextColor(0xBBBBBB);
        this.setTextColorUneditable(0xBBBBBB);
        this.setBordered(false);
        this.setMaxLength(50);
        this.setUnfocusedEmptyHint(MAGNIFYING_GLASS);
        this.maximizedX = position.x();
        this.maximizedWidth = dimension.width();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.m_5953_(mouseX, mouseY)) {
            return false;
        }
        if (this.isEditable()) {
            if (button == 0) {
                this.m_93692_(true);
                this.screen.m_7522_(this);
            } else if (button == 1) {
                this.setValue("");
            }
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    @Override
    public void m_93692_(boolean focused) {
        if (this.m_93696_() != focused) {
            this.lastFocusChangeTime = System.currentTimeMillis();
        }
        super.m_93692_(focused);
        if (focused) {
            this.setTextColor(-1);
        } else {
            this.setTextColor(0xBBBBBB);
        }
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, Minecraft minecraft, int mouseX, int mouseY) {
        int minWidth = this.getHeight();
        if (this.m_93696_() && this.maximizedWidth > this.getWidth() || !this.m_93696_() && this.getValue().isEmpty() && this.getWidth() > minWidth) {
            float ratio = Easing.EASE_IN_OUT_CUBIC.ease(Math.min((float)(System.currentTimeMillis() - this.lastFocusChangeTime) / 200.0f, 1.0f));
            int currentWidth = this.m_93696_() ? (int)((float)minWidth + (float)(this.maximizedWidth - minWidth) * ratio) : (int)((float)this.maximizedWidth - (float)(this.maximizedWidth - minWidth) * ratio);
            this.setPosition(new Position(this.maximizedX + this.maximizedWidth - currentWidth, this.y));
            this.updateDimensions(currentWidth, this.getHeight());
        }
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
        guiGraphics.m_280509_(this.x, this.y, this.x + this.getWidth(), this.y + this.getHeight(), -8947849);
        guiGraphics.m_280168_().m_85849_();
    }

    @Override
    public void renderTooltip(Screen screen, GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(screen, guiGraphics, mouseX, mouseY);
        if (!this.m_93696_() && this.m_5953_(mouseX, mouseY)) {
            guiGraphics.m_280677_(screen.f_96547_, TOOLTIP, Optional.empty(), mouseX, mouseY);
        }
    }
}

