/*
 * Decompiled with CFR 0.152.
 */
package github.pitbox46.itemblacklist.blacklist;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import github.pitbox46.itemblacklist.ItemBlacklist;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public final class ItemBanPredicate
implements BiPredicate<ItemStack, Player> {
    public static final Codec<ItemBanPredicate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.PASSTHROUGH.xmap(p_253507_ -> (JsonElement)p_253507_.convert((DynamicOps)ItemBlacklist.MODIFIED_JSON_OPS).getValue(), p_253513_ -> new Dynamic((DynamicOps)ItemBlacklist.MODIFIED_JSON_OPS, p_253513_)).fieldOf("item_predicate").xmap(ItemPredicate::m_45051_, ItemPredicate::m_45048_).forGetter(ItemBanPredicate::itemPredicate), (App)Codec.STRING.listOf().optionalFieldOf("groups", new ArrayList()).xmap(ArrayList::new, ArrayList::new).forGetter(ItemBanPredicate::groupKeys), (App)Codec.BOOL.optionalFieldOf("ban_nonplayer", (Object)true).forGetter(ItemBanPredicate::banNonPlayerItems)).apply((Applicative)instance, ItemBanPredicate::new));
    private final ItemPredicate itemPredicate;
    private final ArrayList<String> groupKeys;
    private final boolean banNonPlayerItems;
    private final Object2BooleanMap<Player> cachedPlayers = new Object2BooleanOpenHashMap();

    public ItemBanPredicate(ItemPredicate itemPredicate, ArrayList<String> groupKeys, boolean banNonPlayerItems) {
        this.itemPredicate = itemPredicate;
        this.groupKeys = groupKeys;
        this.banNonPlayerItems = banNonPlayerItems;
    }

    @Override
    public boolean test(@Nonnull ItemStack stack, @Nullable Player player) {
        if (player == null) {
            return this.banNonPlayerItems && this.itemPredicate.m_45049_(stack);
        }
        if (this.cachedPlayers.computeIfAbsent((Object)player, p -> ItemBlacklist.BLACKLIST.isPlayerInGroups((Collection<String>)this.groupKeys, (Player)p))) {
            return this.itemPredicate().m_45049_(stack);
        }
        return false;
    }

    public void recalculate() {
        this.cachedPlayers.clear();
    }

    public ItemPredicate itemPredicate() {
        return this.itemPredicate;
    }

    public ArrayList<String> groupKeys() {
        return this.groupKeys;
    }

    public boolean banNonPlayerItems() {
        return this.banNonPlayerItems;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ItemBanPredicate that = (ItemBanPredicate)obj;
        return Objects.equals(this.itemPredicate, that.itemPredicate) && Objects.equals(this.groupKeys, that.groupKeys) && this.banNonPlayerItems == that.banNonPlayerItems;
    }

    public int hashCode() {
        return Objects.hash(this.itemPredicate, this.groupKeys, this.banNonPlayerItems);
    }

    public String toString() {
        return "ItemBanPredicate[itemPredicate=" + String.valueOf(this.itemPredicate) + ", groups=" + String.valueOf(this.groupKeys) + "banNonPlayerItems=" + this.banNonPlayerItems + "]";
    }
}

