/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.client.level.entities.model;

import com.blackgear.vanillabackport.client.level.entities.animation.CreakingAnimation;
import com.blackgear.vanillabackport.common.level.entities.creaking.Creaking;
import java.util.List;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CreakingModel<T extends Creaking>
extends HierarchicalModel<T> {
    public static final List<ModelPart> NO_PARTS = List.of();
    private final ModelPart root;
    private final ModelPart head;
    private final List<ModelPart> headParts;
    private boolean eyesGlowing;

    public CreakingModel(ModelPart root) {
        this.root = root.m_171324_("root");
        ModelPart upperBody = this.root.m_171324_("upper_body");
        this.head = upperBody.m_171324_("head");
        this.headParts = List.of(this.head);
    }

    private static MeshDefinition createMesh() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition base = mesh.m_171576_();
        PartDefinition root = base.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition upperBody = root.m_171599_("upper_body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.0f, (float)-19.0f, (float)0.0f));
        upperBody.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.0f, -10.0f, -3.0f, 6.0f, 10.0f, 6.0f).m_171514_(28, 31).m_171481_(-3.0f, -13.0f, -3.0f, 6.0f, 3.0f, 6.0f).m_171514_(12, 40).m_171481_(3.0f, -13.0f, 0.0f, 9.0f, 14.0f, 0.0f).m_171514_(34, 12).m_171481_(-12.0f, -14.0f, 0.0f, 9.0f, 14.0f, 0.0f), PartPose.m_171419_((float)-3.0f, (float)-11.0f, (float)0.0f));
        upperBody.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171481_(0.0f, -3.0f, -3.0f, 6.0f, 13.0f, 5.0f).m_171514_(24, 0).m_171481_(-6.0f, -4.0f, -3.0f, 6.0f, 7.0f, 5.0f), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)1.0f));
        upperBody.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(22, 13).m_171481_(-2.0f, -1.5f, -1.5f, 3.0f, 21.0f, 3.0f).m_171514_(46, 0).m_171481_(-2.0f, 19.5f, -1.5f, 3.0f, 4.0f, 3.0f), PartPose.m_171419_((float)-7.0f, (float)-9.5f, (float)1.5f));
        upperBody.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(30, 40).m_171481_(0.0f, -1.0f, -1.5f, 3.0f, 16.0f, 3.0f).m_171514_(52, 12).m_171481_(0.0f, -5.0f, -1.5f, 3.0f, 4.0f, 3.0f).m_171514_(52, 19).m_171481_(0.0f, 15.0f, -1.5f, 3.0f, 4.0f, 3.0f), PartPose.m_171419_((float)6.0f, (float)-9.0f, (float)0.5f));
        root.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(42, 40).m_171481_(-1.5f, 0.0f, -1.5f, 3.0f, 16.0f, 3.0f).m_171514_(45, 55).m_171481_(-1.5f, 15.7f, -4.5f, 5.0f, 0.0f, 9.0f), PartPose.m_171419_((float)1.5f, (float)-16.0f, (float)0.5f));
        root.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 34).m_171481_(-3.0f, -1.5f, -1.5f, 3.0f, 19.0f, 3.0f).m_171514_(45, 46).m_171481_(-5.0f, 17.2f, -4.5f, 5.0f, 0.0f, 9.0f).m_171514_(12, 34).m_171481_(-3.0f, -4.5f, -1.5f, 3.0f, 3.0f, 3.0f), PartPose.m_171419_((float)-1.0f, (float)-17.5f, (float)0.5f));
        return mesh;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = CreakingModel.createMesh();
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        this.eyesGlowing = ((Creaking)((Object)entity)).isTearingDown() ? ((Creaking)((Object)entity)).hasGlowingEyes() : ((Creaking)((Object)entity)).isActive();
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        if (((Creaking)((Object)entity)).canMove()) {
            this.m_267799_(CreakingAnimation.CREAKING_WALK, limbSwing, limbSwingAmount, 1.0f, 1.0f);
        }
        this.m_233381_(((Creaking)((Object)entity)).attackAnimationState, CreakingAnimation.CREAKING_ATTACK, ageInTicks);
        this.m_233381_(((Creaking)((Object)entity)).invulnerabilityAnimationState, CreakingAnimation.CREAKING_INVULNERABLE, ageInTicks);
        this.m_233381_(((Creaking)((Object)entity)).deathAnimationState, CreakingAnimation.CREAKING_DEATH, ageInTicks);
    }

    public List<ModelPart> getHeadParts() {
        return !this.eyesGlowing ? NO_PARTS : this.headParts;
    }
}

